/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.upgrade;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.client.util.TintColor;
import me.desht.modularrouters.core.ModSounds;
import me.desht.modularrouters.item.IPlayerOwned;
import me.desht.modularrouters.item.upgrade.UpgradeItem;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class SecurityUpgrade
extends UpgradeItem
implements IPlayerOwned {
    private static final String NBT_PLAYERS = "Players";
    private static final int MAX_PLAYERS = 6;

    @Override
    public void addExtraInformation(ItemStack itemstack, List<Component> list) {
        String owner = this.getOwnerName(itemstack);
        if (owner == null) {
            owner = "-";
        }
        list.add((Component)ClientUtil.xlate("modularrouters.itemText.security.owner", ChatFormatting.AQUA + owner));
        Set<String> names = SecurityUpgrade.getPlayerNames(itemstack);
        if (!names.isEmpty()) {
            list.add((Component)ClientUtil.xlate("modularrouters.itemText.security.count", names.size(), 6));
            list.addAll(names.stream().map(name -> " \u2022 " + ChatFormatting.YELLOW + name).sorted().map(Component::m_237113_).toList());
        }
    }

    @Override
    public void onCompiled(ItemStack stack, ModularRouterBlockEntity router) {
        super.onCompiled(stack, router);
        router.addPermittedIds(this.getPlayerIDs(stack));
    }

    @Override
    public TintColor getItemTint() {
        return new TintColor(64, 64, 255);
    }

    private Set<UUID> getPlayerIDs(ItemStack stack) {
        CompoundTag compound = stack.m_41783_();
        if (compound == null) {
            return Collections.emptySet();
        }
        HashSet res = Sets.newHashSet();
        UUID ownerID = this.getOwnerID(stack);
        if (ownerID == null) {
            return Collections.emptySet();
        }
        res.add(ownerID);
        if (compound.m_128441_(NBT_PLAYERS)) {
            CompoundTag p = compound.m_128469_(NBT_PLAYERS);
            res.addAll(p.m_128431_().stream().map(UUID::fromString).toList());
        }
        return res;
    }

    private static Set<String> getPlayerNames(ItemStack stack) {
        CompoundTag compound = stack.m_41783_();
        if (compound != null && compound.m_128441_(NBT_PLAYERS)) {
            CompoundTag p = compound.m_128469_(NBT_PLAYERS);
            return p.m_128431_().stream().map(arg_0 -> ((CompoundTag)p).m_128461_(arg_0)).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
        }
        return Collections.emptySet();
    }

    private static Result addPlayer(ItemStack stack, String id, String name) {
        CompoundTag compound = stack.m_41783_();
        if (compound != null) {
            CompoundTag p;
            if (!compound.m_128441_(NBT_PLAYERS)) {
                compound.m_128365_(NBT_PLAYERS, (Tag)new CompoundTag());
            }
            if ((p = compound.m_128469_(NBT_PLAYERS)).m_128441_(id)) {
                return Result.ALREADY_ADDED;
            }
            if (p.m_128440_() >= 6) {
                return Result.FULL;
            }
            p.m_128359_(id, name);
            return Result.ADDED;
        }
        return Result.ERROR;
    }

    private static Result removePlayer(ItemStack stack, String id) {
        CompoundTag compound = stack.m_41783_();
        if (compound != null) {
            CompoundTag p;
            if (!compound.m_128441_(NBT_PLAYERS)) {
                compound.m_128365_(NBT_PLAYERS, (Tag)new CompoundTag());
            }
            if ((p = compound.m_128469_(NBT_PLAYERS)).m_128441_(id)) {
                p.m_128473_(id);
                return Result.REMOVED;
            }
            return Result.NOT_PRESENT;
        }
        return Result.ERROR;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!player.m_20193_().f_46443_ && player.m_20161_()) {
            this.setOwner(stack, player);
            player.m_5661_((Component)Component.m_237110_((String)"modularrouters.itemText.security.owner", (Object[])new Object[]{player.m_5446_().getString()}), false);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity entity, InteractionHand hand) {
        if (entity instanceof Player) {
            Result res;
            Player targetPlayer = (Player)entity;
            String id = targetPlayer.m_20148_().toString();
            String name = targetPlayer.m_5446_().toString();
            Result result = res = player.m_20161_() ? SecurityUpgrade.removePlayer(stack, id) : SecurityUpgrade.addPlayer(stack, id, name);
            if (player.m_9236_().f_46443_) {
                player.m_5496_(res.isError() ? (SoundEvent)ModSounds.ERROR.get() : (SoundEvent)ModSounds.SUCCESS.get(), 1.0f, 1.0f);
            } else {
                player.m_5661_((Component)Component.m_237110_((String)("modularrouters.chatText.security." + res.toString()), (Object[])new Object[]{name}), false);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    static enum Result {
        ADDED,
        REMOVED,
        FULL,
        ALREADY_ADDED,
        ERROR,
        NOT_PRESENT;


        boolean isError() {
            return this != ADDED && this != REMOVED;
        }
    }
}

