/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book;

import com.klikli_dev.modonomicon.book.BookEntry;
import com.klikli_dev.modonomicon.book.BookEntryParent;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class EntryConnectionRenderer {
    public int blitOffset;
    public ResourceLocation entryTextures;

    public EntryConnectionRenderer(ResourceLocation entryTextures) {
        this.entryTextures = entryTextures;
    }

    public void renderLinedUpEntries(GuiGraphics guiGraphics, BookEntry entry, BookEntry parentEntry, BookEntryParent parent, boolean isVertical) {
        if (isVertical) {
            this.drawVerticalLine(guiGraphics, parentEntry.getX(), entry.getY(), parentEntry.getY());
            if (parent.drawArrow()) {
                if (parentEntry.getY() > entry.getY()) {
                    this.drawUpArrow(guiGraphics, entry.getX(), entry.getY() + 1);
                } else {
                    this.drawDownArrow(guiGraphics, entry.getX(), entry.getY() - 1);
                }
            }
        } else {
            this.drawHorizontalLine(guiGraphics, parentEntry.getY(), entry.getX(), parentEntry.getX());
            if (parent.drawArrow()) {
                if (parentEntry.getX() > entry.getX()) {
                    this.drawLeftArrow(guiGraphics, entry.getX() + 1, entry.getY());
                } else {
                    this.drawRightArrow(guiGraphics, entry.getX() - 1, entry.getY());
                }
            }
        }
    }

    public void renderSmallCurves(GuiGraphics guiGraphics, BookEntry entry, BookEntry parentEntry, BookEntryParent parent) {
        this.drawVerticalLine(guiGraphics, entry.getX(), parentEntry.getY(), entry.getY());
        this.drawHorizontalLine(guiGraphics, parentEntry.getY(), parentEntry.getX(), entry.getX());
        if (entry.getX() > parentEntry.getX()) {
            if (entry.getY() > parentEntry.getY()) {
                this.drawSmallCurveLeftDown(guiGraphics, entry.getX(), parentEntry.getY());
                if (parent.drawArrow()) {
                    this.drawDownArrow(guiGraphics, entry.getX(), entry.getY() - 1);
                }
            } else {
                this.drawSmallCurveLeftUp(guiGraphics, entry.getX(), parentEntry.getY());
                if (parent.drawArrow()) {
                    this.drawUpArrow(guiGraphics, entry.getX(), entry.getY() + 1);
                }
            }
        } else if (entry.getY() > parentEntry.getY()) {
            this.drawSmallCurveRightDown(guiGraphics, entry.getX(), parentEntry.getY());
            if (parent.drawArrow()) {
                this.drawDownArrow(guiGraphics, entry.getX(), entry.getY() - 1);
            }
        } else {
            this.drawSmallCurveRightUp(guiGraphics, entry.getX(), parentEntry.getY());
            if (parent.drawArrow()) {
                this.drawUpArrow(guiGraphics, entry.getX(), entry.getY() + 1);
            }
        }
    }

    public void renderSmallCurvesReversed(GuiGraphics guiGraphics, BookEntry entry, BookEntry parentEntry, BookEntryParent parent) {
        this.drawHorizontalLine(guiGraphics, entry.getY(), entry.getX(), parentEntry.getX());
        this.drawVerticalLine(guiGraphics, parentEntry.getX(), parentEntry.getY(), entry.getY());
        if (entry.getX() > parentEntry.getX()) {
            if (entry.getY() > parentEntry.getY()) {
                this.drawSmallCurveRightUp(guiGraphics, parentEntry.getX(), entry.getY());
                if (parent.drawArrow()) {
                    this.drawRightArrow(guiGraphics, entry.getX() - 1, entry.getY());
                }
            } else {
                this.drawSmallCurveRightDown(guiGraphics, entry.getX() - 1, parentEntry.getY() - 1);
                if (parent.drawArrow()) {
                    this.drawRightArrow(guiGraphics, entry.getX() - 1, entry.getY());
                }
            }
        } else if (entry.getY() > parentEntry.getY()) {
            this.drawSmallCurveLeftUp(guiGraphics, parentEntry.getX(), parentEntry.getY() + 1);
            if (parent.drawArrow()) {
                this.drawLeftArrow(guiGraphics, entry.getX() + 1, entry.getY());
            }
        } else {
            this.drawSmallCurveLeftDown(guiGraphics, entry.getX() + 1, parentEntry.getY() - 1);
            if (parent.drawArrow()) {
                this.drawLeftArrow(guiGraphics, entry.getX() + 1, entry.getY());
            }
        }
    }

    public void renderLargeCurves(GuiGraphics guiGraphics, BookEntry entry, BookEntry parentEntry, BookEntryParent parent) {
        this.drawHorizontalLineShortened(guiGraphics, parentEntry.getY(), parentEntry.getX(), entry.getX());
        this.drawVerticalLineShortened(guiGraphics, entry.getX(), entry.getY(), parentEntry.getY());
        if (entry.getX() > parentEntry.getX()) {
            if (entry.getY() > parentEntry.getY()) {
                this.drawLargeCurveLeftDown(guiGraphics, entry.getX() - 1, parentEntry.getY());
                if (parent.drawArrow()) {
                    this.drawDownArrow(guiGraphics, entry.getX(), entry.getY() - 1);
                }
            } else {
                this.drawLargeCurveLeftUp(guiGraphics, entry.getX() - 1, parentEntry.getY() - 1);
                if (parent.drawArrow()) {
                    this.drawUpArrow(guiGraphics, entry.getX(), entry.getY() + 1);
                }
            }
        } else if (entry.getY() > parentEntry.getY()) {
            this.drawLargeCurveRightDown(guiGraphics, entry.getX(), parentEntry.getY());
            if (parent.drawArrow()) {
                this.drawDownArrow(guiGraphics, entry.getX(), entry.getY() - 1);
            }
        } else {
            this.drawLargeCurveRightUp(guiGraphics, entry.getX(), parentEntry.getY() - 1);
            if (parent.drawArrow()) {
                this.drawUpArrow(guiGraphics, entry.getX(), entry.getY() + 1);
            }
        }
    }

    public void renderLargeCurvesReversed(GuiGraphics guiGraphics, BookEntry entry, BookEntry parentEntry, BookEntryParent parent) {
        this.drawHorizontalLineShortened(guiGraphics, entry.getY(), entry.getX(), parentEntry.getX());
        this.drawVerticalLineShortened(guiGraphics, parentEntry.getX(), parentEntry.getY(), entry.getY());
        if (entry.getX() > parentEntry.getX()) {
            if (entry.getY() > parentEntry.getY()) {
                this.drawLargeCurveRightUp(guiGraphics, parentEntry.getX(), entry.getY() - 1);
            } else {
                this.drawLargeCurveRightDown(guiGraphics, parentEntry.getX(), entry.getY());
            }
            if (parent.drawArrow()) {
                this.drawRightArrow(guiGraphics, entry.getX() - 1, entry.getY());
            }
        } else {
            if (entry.getY() > parentEntry.getY()) {
                this.drawLargeCurveLeftUp(guiGraphics, parentEntry.getX() - 1, parentEntry.getY() + 1);
            } else {
                this.drawLargeCurveLeftDown(guiGraphics, parentEntry.getX() - 1, entry.getY());
            }
            if (parent.drawArrow()) {
                this.drawLeftArrow(guiGraphics, entry.getX() + 1, entry.getY());
            }
        }
    }

    public void render(GuiGraphics guiGraphics, BookEntry entry, BookEntryParent parent) {
        BookEntry parentEntry = parent.getEntry();
        if (parent.isLineEnabled() && parentEntry.getCategory().equals(entry.getCategory())) {
            int deltaX = Math.abs(entry.getX() - parentEntry.getX());
            int deltaY = Math.abs(entry.getY() - parentEntry.getY());
            if (deltaX == 0 || deltaY == 0) {
                this.renderLinedUpEntries(guiGraphics, entry, parentEntry, parent, deltaX == 0);
            } else if (deltaX < 2 || deltaY < 2) {
                if (!parent.isLineReversed()) {
                    this.renderSmallCurves(guiGraphics, entry, parentEntry, parent);
                } else {
                    this.renderSmallCurvesReversed(guiGraphics, entry, parentEntry, parent);
                }
            } else if (!parent.isLineReversed()) {
                this.renderLargeCurves(guiGraphics, entry, parentEntry, parent);
            } else {
                this.renderLargeCurvesReversed(guiGraphics, entry, parentEntry, parent);
            }
        }
    }

    protected void setBlitOffset(int blitOffset) {
        this.blitOffset = blitOffset;
    }

    protected int screenX(int x) {
        return x * 30;
    }

    protected int screenY(int y) {
        return y * 30;
    }

    protected void blit(GuiGraphics guiGraphics, int pX, int pY, float pUOffset, float pVOffset, int pUWidth, int pVHeight) {
        guiGraphics.m_280398_(this.entryTextures, pX, pY, this.blitOffset, pUOffset, pVOffset, pUWidth, pVHeight, 256, 256);
    }

    protected void drawSmallCurveLeftDown(GuiGraphics guiGraphics, int x, int y) {
        this.blit(guiGraphics, this.screenX(x), this.screenY(y), 0.0f, 226.0f, 30, 30);
    }

    protected void drawSmallCurveRightDown(GuiGraphics guiGraphics, int x, int y) {
        this.blit(guiGraphics, this.screenX(x), this.screenY(y), 30.0f, 226.0f, 30, 30);
    }

    protected void drawSmallCurveLeftUp(GuiGraphics guiGraphics, int x, int y) {
        this.blit(guiGraphics, this.screenX(x), this.screenY(y), 0.0f, 196.0f, 30, 30);
    }

    protected void drawSmallCurveRightUp(GuiGraphics guiGraphics, int x, int y) {
        this.blit(guiGraphics, this.screenX(x), this.screenY(y), 30.0f, 196.0f, 30, 30);
    }

    protected void drawLargeCurveLeftDown(GuiGraphics guiGraphics, int x, int y) {
        this.blit(guiGraphics, this.screenX(x), this.screenY(y), 62.0f, 196.0f, 60, 60);
    }

    protected void drawLargeCurveRightDown(GuiGraphics guiGraphics, int x, int y) {
        this.blit(guiGraphics, this.screenX(x), this.screenY(y), 122.0f, 196.0f, 60, 60);
    }

    protected void drawLargeCurveLeftUp(GuiGraphics guiGraphics, int x, int y) {
        this.blit(guiGraphics, this.screenX(x), this.screenY(y), 62.0f, 134.0f, 60, 60);
    }

    protected void drawLargeCurveRightUp(GuiGraphics guiGraphics, int x, int y) {
        this.blit(guiGraphics, this.screenX(x), this.screenY(y), 122.0f, 134.0f, 60, 60);
    }

    void drawVerticalLineAt(GuiGraphics guiGraphics, int x, int y) {
        this.blit(guiGraphics, this.screenX(x), this.screenY(y), 184.0f, 164.0f, 30, 31);
    }

    void drawHorizontalLineAt(GuiGraphics guiGraphics, int x, int y) {
        this.blit(guiGraphics, this.screenX(x), this.screenY(y), 184.0f, 226.0f, 31, 30);
    }

    void drawVerticalLine(GuiGraphics guiGraphics, int x, int startY, int endY) {
        int temp = startY;
        startY = Math.min(startY, endY);
        endY = Math.max(endY, temp);
        for (int j = startY + 1; j < endY; ++j) {
            this.drawVerticalLineAt(guiGraphics, x, j);
        }
    }

    void drawHorizontalLine(GuiGraphics guiGraphics, int y, int startX, int endX) {
        int temp = startX;
        startX = Math.min(startX, endX);
        endX = Math.max(endX, temp);
        for (int j = startX + 1; j < endX; ++j) {
            this.drawHorizontalLineAt(guiGraphics, j, y);
        }
    }

    void drawHorizontalLineShortened(GuiGraphics guiGraphics, int y, int startX, int endX) {
        int temp = startX;
        endX = startX > endX ? ++endX : --endX;
        startX = Math.min(startX, endX);
        endX = Math.max(endX, temp);
        for (int j = startX + 1; j < endX; ++j) {
            this.drawHorizontalLineAt(guiGraphics, j, y);
        }
    }

    void drawVerticalLineShortened(GuiGraphics guiGraphics, int x, int startY, int endY) {
        int temp = startY;
        endY = startY > endY ? ++endY : --endY;
        startY = Math.min(startY, endY);
        endY = Math.max(endY, temp);
        for (int j = startY + 1; j < endY; ++j) {
            this.drawVerticalLineAt(guiGraphics, x, j);
        }
    }

    void drawUpArrow(GuiGraphics guiGraphics, int x, int y) {
        this.blit(guiGraphics, this.screenX(x), this.screenY(y) - 1, 0.0f, 134.0f, 30, 30);
    }

    void drawDownArrow(GuiGraphics guiGraphics, int x, int y) {
        this.blit(guiGraphics, this.screenX(x), this.screenY(y) + 1, 0.0f, 164.0f, 30, 30);
    }

    void drawRightArrow(GuiGraphics guiGraphics, int x, int y) {
        this.blit(guiGraphics, this.screenX(x) + 1, this.screenY(y), 30.0f, 134.0f, 30, 30);
    }

    void drawLeftArrow(GuiGraphics guiGraphics, int x, int y) {
        this.blit(guiGraphics, this.screenX(x) - 1, this.screenY(y), 30.0f, 164.0f, 30, 30);
    }
}

