/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.networking;

import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookEntry;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.networking.Message;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class ClickReadAllButtonMessage
implements Message {
    public static final ResourceLocation ID = new ResourceLocation("modonomicon", "click_read_all_button");
    public ResourceLocation bookId;
    public boolean readAll;

    public ClickReadAllButtonMessage(ResourceLocation bookId, boolean readAll) {
        this.bookId = bookId;
        this.readAll = readAll;
    }

    public ClickReadAllButtonMessage(FriendlyByteBuf buf) {
        this.decode(buf);
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130085_(this.bookId);
        buf.writeBoolean(this.readAll);
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.bookId = buf.m_130281_();
        this.readAll = buf.readBoolean();
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player) {
        Book book = BookDataManager.get().getBook(this.bookId);
        if (book != null) {
            boolean anyRead = false;
            for (BookEntry entry : book.getEntries().values()) {
                if (!this.readAll && !BookUnlockStateManager.get().isUnlockedFor((Player)player, entry) || !BookUnlockStateManager.get().readFor(player, entry)) continue;
                anyRead = true;
            }
            if (anyRead) {
                BookUnlockStateManager.get().updateAndSyncFor(player);
            }
        }
    }
}

