/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.bookstate;

import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.book.BookCommand;
import com.klikli_dev.modonomicon.book.BookEntry;
import com.klikli_dev.modonomicon.bookstate.BookStatesSaveData;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStates;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.networking.SyncBookUnlockStatesMessage;
import com.klikli_dev.modonomicon.platform.Services;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class BookUnlockStateManager {
    private static final BookUnlockStateManager instance = new BookUnlockStateManager();
    public BookStatesSaveData saveData;

    public static BookUnlockStateManager get() {
        return instance;
    }

    private BookUnlockStates getStateFor(Player player) {
        this.getSaveDataIfNecessary(player);
        return this.saveData.getUnlockStates(player.m_20148_());
    }

    public String getUnlockCodeFor(Player player, Book book) {
        return this.getStateFor(player).getUnlockCode(book);
    }

    public Book applyUnlockCodeFor(ServerPlayer player, String unlockCode) {
        Book book = this.getStateFor((Player)player).applyUnlockCode(unlockCode);
        if (book != null) {
            this.saveData.m_77762_();
            this.syncFor(player);
        }
        return book;
    }

    public void syncFor(ServerPlayer player) {
        Services.NETWORK.sendTo(player, new SyncBookUnlockStatesMessage(this.getStateFor((Player)player)));
    }

    public void updateAndSyncFor(final ServerPlayer player) {
        if (BookDataManager.get().areBooksBuilt()) {
            this.getStateFor((Player)player).update(player);
            this.saveData.m_77762_();
            this.syncFor(player);
        } else {
            Timer timer = new Timer(true);
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    player.f_8924_.execute(() -> BookUnlockStateManager.this.updateAndSyncFor(player));
                }
            }, 1000L);
        }
    }

    public List<ResourceLocation> getBooksFor(Player player) {
        return this.getStateFor(player).getBooks();
    }

    public void resetFor(ServerPlayer player, Book book) {
        this.getStateFor((Player)player).reset(book);
        this.saveData.m_77762_();
        this.syncFor(player);
    }

    public boolean isUnlockedFor(Player player, BookCategory category) {
        return this.getStateFor(player).isUnlocked(category);
    }

    public boolean isUnlockedFor(Player player, BookEntry entry) {
        return this.getStateFor(player).isUnlocked(entry);
    }

    public boolean isReadFor(Player player, BookEntry entry) {
        return this.getStateFor(player).isRead(entry);
    }

    public boolean canRunFor(Player player, BookCommand command) {
        return this.getStateFor(player).canRun(command);
    }

    public void setRunFor(Player player, BookCommand command) {
        this.getStateFor(player).setRun(command);
    }

    public boolean readFor(ServerPlayer player, BookEntry entry) {
        return this.getStateFor((Player)player).read(entry, player);
    }

    public void onAdvancement(ServerPlayer player) {
        this.updateAndSyncFor(player);
    }

    private void getSaveDataIfNecessary(Player player) {
        if (this.saveData == null && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.saveData = (BookStatesSaveData)serverPlayer.m_20194_().m_129783_().m_8895_().m_164861_(BookStatesSaveData::load, BookStatesSaveData::new, "modonomicon_book_states");
        }
    }
}

