/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book.page;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.book.BookEntry;
import com.klikli_dev.modonomicon.book.BookTextHolder;
import com.klikli_dev.modonomicon.book.RenderedBookTextHolder;
import com.klikli_dev.modonomicon.book.page.BookPage;
import com.klikli_dev.modonomicon.client.gui.book.markdown.BookTextRenderer;
import com.klikli_dev.modonomicon.util.BookGsonHelper;
import java.util.Arrays;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;

public class BookSpotlightPage
extends BookPage {
    protected BookTextHolder title;
    protected BookTextHolder text;
    protected Ingredient item;

    public BookSpotlightPage(BookTextHolder title, BookTextHolder text, Ingredient item, String anchor) {
        super(anchor);
        this.title = title;
        this.text = text;
        this.item = item;
    }

    public static BookSpotlightPage fromJson(JsonObject json) {
        BookTextHolder title = BookGsonHelper.getAsBookTextHolder(json, "title", BookTextHolder.EMPTY);
        Ingredient item = Ingredient.m_43917_((JsonElement)json.get("item"));
        BookTextHolder text = BookGsonHelper.getAsBookTextHolder(json, "text", BookTextHolder.EMPTY);
        String anchor = GsonHelper.m_13851_((JsonObject)json, (String)"anchor", (String)"");
        return new BookSpotlightPage(title, text, item, anchor);
    }

    public static BookSpotlightPage fromNetwork(FriendlyByteBuf buffer) {
        BookTextHolder title = BookTextHolder.fromNetwork(buffer);
        Ingredient item = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        BookTextHolder text = BookTextHolder.fromNetwork(buffer);
        String anchor = buffer.m_130277_();
        return new BookSpotlightPage(title, text, item, anchor);
    }

    public Ingredient getItem() {
        return this.item;
    }

    public BookTextHolder getTitle() {
        return this.title;
    }

    public BookTextHolder getText() {
        return this.text;
    }

    public boolean hasTitle() {
        return !this.title.isEmpty();
    }

    @Override
    public ResourceLocation getType() {
        return ModonomiconConstants.Data.Page.SPOTLIGHT;
    }

    @Override
    public void build(Level level, BookEntry parentEntry, int pageNum) {
        super.build(level, parentEntry, pageNum);
        if (this.title.isEmpty()) {
            this.title = new BookTextHolder((Component)((MutableComponent)this.item.m_43908_()[0].m_41786_()).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_178520_(this.getParentEntry().getBook().getDefaultTitleColor())));
        }
    }

    @Override
    public void prerenderMarkdown(BookTextRenderer textRenderer) {
        super.prerenderMarkdown(textRenderer);
        if (!this.title.hasComponent()) {
            this.title = new BookTextHolder((Component)Component.m_237115_((String)this.title.getKey()).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_178520_(this.getParentEntry().getBook().getDefaultTitleColor())));
        }
        if (!this.text.hasComponent()) {
            this.text = new RenderedBookTextHolder(this.text, textRenderer.render(this.text.getString()));
        }
    }

    @Override
    public void toNetwork(FriendlyByteBuf buffer) {
        this.title.toNetwork(buffer);
        this.item.m_43923_(buffer);
        this.text.toNetwork(buffer);
        buffer.m_130070_(this.anchor);
    }

    @Override
    public boolean matchesQuery(String query) {
        return this.title.getString().toLowerCase().contains(query) || Arrays.stream(this.item.m_43908_()).anyMatch(i -> I18n.m_118938_((String)i.m_41778_(), (Object[])new Object[0]).toLowerCase().contains(query)) || this.text.getString().toLowerCase().contains(query);
    }
}

