/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.book.BookCommand;
import com.klikli_dev.modonomicon.book.BookEntryParent;
import com.klikli_dev.modonomicon.book.BookIcon;
import com.klikli_dev.modonomicon.book.ResolvedBookEntryParent;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.BookNoneCondition;
import com.klikli_dev.modonomicon.book.error.BookErrorManager;
import com.klikli_dev.modonomicon.book.page.BookPage;
import com.klikli_dev.modonomicon.client.gui.book.markdown.BookTextRenderer;
import com.klikli_dev.modonomicon.data.JsonLoader;
import com.klikli_dev.modonomicon.data.LoaderRegistry;
import com.klikli_dev.modonomicon.data.NetworkLoader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.Level;

public class BookEntry {
    protected ResourceLocation id;
    protected ResourceLocation categoryId;
    protected BookCategory category;
    protected Book book;
    protected List<BookEntryParent> parents;
    protected String name;
    protected String description;
    protected BookIcon icon;
    protected int x;
    protected int y;
    protected int entryBackgroundUIndex;
    protected int entryBackgroundVIndex;
    protected boolean hideWhileLocked;
    protected List<BookPage> pages;
    protected BookCondition condition;
    protected ResourceLocation categoryToOpenId;
    protected BookCategory categoryToOpen;
    protected ResourceLocation commandToRunOnFirstReadId;
    protected BookCommand commandToRunOnFirstRead;

    public BookEntry(ResourceLocation id, ResourceLocation categoryId, String name, String description, BookIcon icon, int x, int y, int entryBackgroundUIndex, int entryBackgroundVIndex, boolean hideWhileLocked, BookCondition condition, List<BookEntryParent> parents, List<BookPage> pages, ResourceLocation categoryToOpenId, ResourceLocation commandToRunOnFirstReadId) {
        this.id = id;
        this.categoryId = categoryId;
        this.name = name;
        this.description = description;
        this.icon = icon;
        this.x = x;
        this.y = y;
        this.entryBackgroundUIndex = entryBackgroundUIndex;
        this.entryBackgroundVIndex = entryBackgroundVIndex;
        this.parents = parents;
        this.pages = pages;
        this.condition = condition;
        this.hideWhileLocked = hideWhileLocked;
        this.categoryToOpenId = categoryToOpenId;
        this.commandToRunOnFirstReadId = commandToRunOnFirstReadId;
    }

    public static BookEntry fromJson(ResourceLocation id, JsonObject json) {
        ResourceLocation categoryId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"category"));
        String name = GsonHelper.m_13906_((JsonObject)json, (String)"name");
        String description = GsonHelper.m_13851_((JsonObject)json, (String)"description", (String)"");
        BookIcon icon = BookIcon.fromJson(json.get("icon"));
        int x = GsonHelper.m_13927_((JsonObject)json, (String)"x");
        int y = GsonHelper.m_13927_((JsonObject)json, (String)"y");
        int entryBackgroundUIndex = GsonHelper.m_13824_((JsonObject)json, (String)"background_u_index", (int)0);
        int entryBackgroundVIndex = GsonHelper.m_13824_((JsonObject)json, (String)"background_v_index", (int)0);
        boolean hideWhileLocked = GsonHelper.m_13855_((JsonObject)json, (String)"hide_while_locked", (boolean)false);
        ArrayList<BookEntryParent> parentEntries = new ArrayList<BookEntryParent>();
        if (json.has("parents")) {
            JsonArray parents = GsonHelper.m_13933_((JsonObject)json, (String)"parents");
            for (Object parent : parents) {
                parentEntries.add(BookEntryParent.fromJson(parent.getAsJsonObject()));
            }
        }
        ArrayList<BookPage> pages = new ArrayList<BookPage>();
        if (json.has("pages")) {
            JsonArray jsonPages = GsonHelper.m_13933_((JsonObject)json, (String)"pages");
            for (JsonElement pageElem : jsonPages) {
                BookErrorManager.get().setContext("Page Index: {}", pages.size());
                JsonObject pageJson = GsonHelper.m_13918_((JsonElement)pageElem, (String)"page");
                ResourceLocation type = new ResourceLocation(GsonHelper.m_13906_((JsonObject)pageJson, (String)"type"));
                JsonLoader<? extends BookPage> loader = LoaderRegistry.getPageJsonLoader(type);
                BookPage page = loader.fromJson(pageJson);
                pages.add(page);
            }
        }
        BookCondition condition = new BookNoneCondition();
        if (json.has("condition")) {
            condition = BookCondition.fromJson(json.getAsJsonObject("condition"));
        }
        ResourceLocation categoryToOpen = null;
        if (json.has("category_to_open")) {
            categoryToOpen = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"category_to_open"));
        }
        ResourceLocation commandToRunOnFirstRead = null;
        if (json.has("command_to_run_on_first_read")) {
            commandToRunOnFirstRead = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"command_to_run_on_first_read"));
        }
        return new BookEntry(id, categoryId, name, description, icon, x, y, entryBackgroundUIndex, entryBackgroundVIndex, hideWhileLocked, condition, parentEntries, pages, categoryToOpen, commandToRunOnFirstRead);
    }

    public static BookEntry fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
        ResourceLocation categoryId = buffer.m_130281_();
        String name = buffer.m_130277_();
        String description = buffer.m_130277_();
        BookIcon icon = BookIcon.fromNetwork(buffer);
        int x = buffer.m_130242_();
        int y = buffer.m_130242_();
        int entryBackgroundUIndex = buffer.m_130242_();
        int entryBackgroundVIndex = buffer.m_130242_();
        boolean hideWhileLocked = buffer.readBoolean();
        ArrayList<BookEntryParent> parentEntries = new ArrayList<BookEntryParent>();
        int parentCount = buffer.m_130242_();
        for (int i = 0; i < parentCount; ++i) {
            parentEntries.add(BookEntryParent.fromNetwork(buffer));
        }
        ArrayList<BookPage> pages = new ArrayList<BookPage>();
        int pageCount = buffer.m_130242_();
        for (int i = 0; i < pageCount; ++i) {
            ResourceLocation type = buffer.m_130281_();
            NetworkLoader<? extends BookPage> loader = LoaderRegistry.getPageNetworkLoader(type);
            BookPage page = loader.fromNetwork(buffer);
            pages.add(page);
        }
        BookCondition condition = BookCondition.fromNetwork(buffer);
        ResourceLocation categoryToOpen = (ResourceLocation)buffer.m_236868_(FriendlyByteBuf::m_130281_);
        ResourceLocation commandToRunOnFirstRead = (ResourceLocation)buffer.m_236868_(FriendlyByteBuf::m_130281_);
        return new BookEntry(id, categoryId, name, description, icon, x, y, entryBackgroundUIndex, entryBackgroundVIndex, hideWhileLocked, condition, parentEntries, pages, categoryToOpen, commandToRunOnFirstRead);
    }

    public BookCategory getCategoryToOpen() {
        return this.categoryToOpen;
    }

    public BookCommand getCommandToRunOnFirstRead() {
        return this.commandToRunOnFirstRead;
    }

    public void build(Level level, BookCategory category) {
        this.category = category;
        this.book = category.getBook();
        ArrayList<BookEntryParent> newParents = new ArrayList<BookEntryParent>();
        for (BookEntryParent parent : this.getParents()) {
            BookEntry parentEntry = this.book.getEntry(parent.getEntryId());
            newParents.add(new ResolvedBookEntryParent(parentEntry));
        }
        this.parents = newParents;
        if (this.categoryToOpenId != null) {
            this.categoryToOpen = this.book.getCategory(this.categoryToOpenId);
            if (this.categoryToOpen == null) {
                BookErrorManager.get().error("Category to open \"" + this.categoryToOpenId + "\" does not exist in this book. Set to null.");
                this.categoryToOpenId = null;
            }
        }
        if (this.commandToRunOnFirstReadId != null) {
            this.commandToRunOnFirstRead = this.book.getCommand(this.commandToRunOnFirstReadId);
            if (this.commandToRunOnFirstRead == null) {
                BookErrorManager.get().error("Command to run on first read \"" + this.commandToRunOnFirstReadId + "\" does not exist in this book. Set to null.");
                this.commandToRunOnFirstReadId = null;
            }
        }
        int pageNum = 0;
        for (BookPage page : this.pages) {
            BookErrorManager.get().getContextHelper().pageNumber = pageNum;
            page.build(level, this, pageNum);
            BookErrorManager.get().getContextHelper().pageNumber = -1;
            ++pageNum;
        }
    }

    public void prerenderMarkdown(BookTextRenderer textRenderer) {
        for (BookPage page : this.pages) {
            BookErrorManager.get().getContextHelper().pageNumber = page.getPageNumber();
            page.prerenderMarkdown(textRenderer);
            BookErrorManager.get().getContextHelper().pageNumber = -1;
        }
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.categoryId);
        buffer.m_130070_(this.name);
        buffer.m_130070_(this.description);
        this.icon.toNetwork(buffer);
        buffer.m_130130_(this.x);
        buffer.m_130130_(this.y);
        buffer.m_130130_(this.entryBackgroundUIndex);
        buffer.m_130130_(this.entryBackgroundVIndex);
        buffer.writeBoolean(this.hideWhileLocked);
        buffer.m_130130_(this.parents.size());
        for (BookEntryParent parent : this.parents) {
            parent.toNetwork(buffer);
        }
        buffer.m_130130_(this.pages.size());
        for (BookPage page : this.pages) {
            buffer.m_130085_(page.getType());
            page.toNetwork(buffer);
        }
        BookCondition.toNetwork(this.condition, buffer);
        buffer.m_236821_((Object)this.categoryToOpenId, FriendlyByteBuf::m_130085_);
        buffer.m_236821_((Object)this.commandToRunOnFirstReadId, FriendlyByteBuf::m_130085_);
    }

    public int getY() {
        return this.y;
    }

    public int getX() {
        return this.x;
    }

    public boolean hideWhileLocked() {
        return this.hideWhileLocked;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public ResourceLocation getCategoryId() {
        return this.categoryId;
    }

    public BookCategory getCategory() {
        return this.category;
    }

    public List<BookEntryParent> getParents() {
        return this.parents;
    }

    public String getName() {
        return this.name;
    }

    public BookIcon getIcon() {
        return this.icon;
    }

    public String getDescription() {
        return this.description;
    }

    public List<BookPage> getPages() {
        return this.pages;
    }

    public Book getBook() {
        return this.book;
    }

    public int getPageNumberForAnchor(String anchor) {
        List<BookPage> pages = this.getPages();
        for (int i = 0; i < pages.size(); ++i) {
            BookPage page = pages.get(i);
            if (!anchor.equals(page.getAnchor())) continue;
            return i;
        }
        return -1;
    }

    public BookCondition getCondition() {
        return this.condition;
    }

    public void setCondition(BookCondition condition) {
        this.condition = condition;
    }

    public int getEntryBackgroundUIndex() {
        return this.entryBackgroundUIndex;
    }

    public int getEntryBackgroundVIndex() {
        return this.entryBackgroundVIndex;
    }

    public boolean matchesQuery(String query) {
        if (this.getName().toLowerCase().contains(query)) {
            return true;
        }
        for (BookPage page : this.getPages()) {
            if (!page.matchesQuery(query)) continue;
            return true;
        }
        return false;
    }
}

