/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.dfu;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.embeddedt.modernfix.dfu.DFUBlaster;

public class LazyDataFixer
implements DataFixer {
    private static final Logger LOGGER = LogManager.getLogger((String)"ModernFix");
    private DataFixer backingDataFixer;
    private final Supplier<DataFixer> dfuSupplier;

    public LazyDataFixer(Supplier<DataFixer> dfuSupplier) {
        LOGGER.info("Bypassed Mojang DFU");
        this.backingDataFixer = null;
        this.dfuSupplier = dfuSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataFixer getDataFixer() {
        LazyDataFixer lazyDataFixer = this;
        synchronized (lazyDataFixer) {
            if (this.backingDataFixer == null) {
                LOGGER.info("Instantiating Mojang DFU");
                DFUBlaster.blastMaps();
                this.backingDataFixer = this.dfuSupplier.get();
            }
        }
        return this.backingDataFixer;
    }

    public <T> Dynamic<T> update(DSL.TypeReference type, Dynamic<T> input, int version, int newVersion) {
        if (version >= newVersion) {
            return input;
        }
        return this.getDataFixer().update(type, input, version, newVersion);
    }

    public Schema getSchema(int key) {
        return this.getDataFixer().getSchema(key);
    }
}

