/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.inventory.client;

import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class GuiMGUButton
extends Button {
    private static final ResourceLocation TEXTURES = new ResourceLocation("mob_grinding_utils:textures/gui/absorption_hopper_gui.png");
    private static final ResourceLocation SOLIDIFIER_TEXTURES = new ResourceLocation("mob_grinding_utils:textures/gui/solidifier_gui.png");
    public Size size;
    public int id;

    public GuiMGUButton(int x, int y, Size s, int idIn, Component title, Button.OnPress pressedAction) {
        super(x, y, s.width, s.height, title, pressedAction, f_252438_);
        this.size = s;
        this.id = idIn;
    }

    public void m_88315_(@Nonnull GuiGraphics gg, int mouseX, int mouseY, float partialTicks) {
        Minecraft mc = Minecraft.m_91087_();
        Font fontrenderer = mc.f_91062_;
        if (this.f_93624_) {
            boolean hover;
            boolean bl = hover = mouseX >= this.m_252754_() && mouseY >= this.m_252907_() && mouseX < this.m_252754_() + this.f_93618_ && mouseY < this.m_252907_() + this.f_93619_;
            if (hover) {
                gg.m_280246_(0.75f, 1.0f, 0.75f, 1.0f);
            } else {
                gg.m_280246_(0.75f, 0.75f, 0.75f, 0.5f);
            }
            gg.m_280218_(this.getTextures(this.size), this.m_252754_(), this.m_252907_(), this.size.u, this.size.v, this.f_93618_, this.f_93619_);
            gg.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            int textColour = 0xE0E0E0;
            if (this.getFGColor() != 0) {
                textColour = this.getFGColor();
            } else if (!this.f_93623_) {
                textColour = 0xA0A0A0;
            } else if (this.m_198029_()) {
                textColour = 0xFFFFA0;
            }
            gg.m_280653_(fontrenderer, this.m_6035_(), this.m_252754_() + this.f_93618_ / 2, this.m_252907_() + (this.f_93619_ - 8) / 2, textColour);
        }
    }

    public ResourceLocation getTextures(Size size) {
        return switch (size) {
            default -> throw new IncompatibleClassChangeError();
            case Size.SMALL, Size.MEDIUM, Size.LARGE -> TEXTURES;
            case Size.SOLIDIFIER, Size.SOLIDIFIER_ON -> SOLIDIFIER_TEXTURES;
        };
    }

    static enum Size {
        SMALL(16, 16, 103, 228),
        MEDIUM(32, 16, 0, 228),
        LARGE(68, 16, 33, 228),
        SOLIDIFIER(34, 16, 178, 92),
        SOLIDIFIER_ON(20, 16, 178, 110);

        final int width;
        final int height;
        final int u;
        final int v;

        private Size(int w, int h, int U, int V) {
            this.width = w;
            this.height = h;
            this.u = U;
            this.v = V;
        }
    }
}

