/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mob_grinding_utils.tile.TileEntityTank;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class BlockTank
extends BaseEntityBlock {
    public BlockTank(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new TileEntityTank(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, @Nonnull BlockState pState, @Nonnull BlockEntityType<T> pBlockEntityType) {
        return pLevel.f_46443_ ? null : TileEntityTank::serverTick;
    }

    @Nonnull
    public RenderShape m_7514_(@Nonnull BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        BlockEntity tileentity;
        if (!world.f_46443_ && !player.m_150110_().f_35937_ && (tileentity = world.m_7702_(pos)) instanceof TileEntityTank) {
            CompoundTag nbt = new CompoundTag();
            ((TileEntityTank)tileentity).m_183515_(nbt);
            ItemStack stack = new ItemStack((ItemLike)Item.m_41439_((Block)this), 1);
            if (((TileEntityTank)tileentity).tank.getFluidAmount() > 0) {
                stack.m_41751_(nbt);
            }
            Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)stack);
            world.m_46747_(pos);
        }
    }

    public void m_6402_(@Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState state, LivingEntity placer, @Nonnull ItemStack stack) {
        BlockEntity tileentity;
        super.m_6402_(world, pos, state, placer, stack);
        if (!world.f_46443_ && stack.m_41782_() && (tileentity = world.m_7702_(pos)) instanceof TileEntityTank && !stack.m_41783_().m_128441_("Empty")) {
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)stack.m_41783_());
            ((TileEntityTank)tileentity).tank.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, Level world, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity tileentity = world.m_7702_(pos);
        if (tileentity instanceof TileEntityTank) {
            LazyOptional fluidHandler = tileentity.getCapability(ForgeCapabilities.FLUID_HANDLER, hit.m_82434_());
            fluidHandler.ifPresent(handler -> {
                if (player.m_21120_(hand).m_41619_() && !handler.getFluidInTank(0).isEmpty()) {
                    player.m_5661_((Component)Component.m_237115_((String)(handler.getFluidInTank(0).getDisplayName().getString() + ": " + handler.getFluidInTank(0).getAmount() + "/" + handler.getTankCapacity(0))), true);
                } else {
                    FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (Level)world, (BlockPos)pos, (Direction)hit.m_82434_());
                }
            });
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

