/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.common.items.gadget;

import com.direwolf20.mininggadgets.common.blocks.MinersLight;
import com.direwolf20.mininggadgets.common.blocks.RenderBlock;
import com.direwolf20.mininggadgets.common.items.gadget.MiningProperties;
import com.direwolf20.mininggadgets.common.tiles.RenderBlockTileEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class MiningCollect {
    public static List<BlockPos> collect(Player player, BlockHitResult startBlock, Level world, int range, MiningProperties.SizeMode sizeMode) {
        int midRange;
        ArrayList<BlockPos> coordinates = new ArrayList<BlockPos>();
        BlockPos startPos = startBlock.m_82425_();
        if (range == 1) {
            if (!MiningCollect.isValid(player, startBlock.m_82425_(), world)) {
                return coordinates;
            }
            coordinates.add(startBlock.m_82425_());
            return coordinates;
        }
        Direction side = startBlock.m_82434_();
        boolean vertical = side.m_122434_().m_122478_();
        Direction up = vertical ? player.m_6350_() : Direction.UP;
        Direction down = up.m_122424_();
        Direction right = vertical ? up.m_122427_() : side.m_122428_();
        Direction left = right.m_122424_();
        int upRange = midRange = (range - 1) / 2;
        int downRange = midRange;
        if (!vertical && range > 3) {
            if (sizeMode == MiningProperties.SizeMode.AUTO) {
                double hitBlockPos;
                double myYPos = player.m_20182_().m_82507_(Direction.UP.m_122434_());
                if (Math.abs(myYPos - (hitBlockPos = (double)startBlock.m_82425_().m_123304_(Direction.UP.m_122434_()))) < 2.0) {
                    downRange = 1;
                    upRange = range - 2;
                }
            } else if (sizeMode == MiningProperties.SizeMode.PATHWAY) {
                downRange = 1;
                upRange = range - 2;
            }
        }
        BlockPos topLeft = startPos.m_5484_(up, upRange).m_5484_(left, midRange);
        BlockPos bottomRight = startPos.m_5484_(down, downRange).m_5484_(right, midRange);
        return BlockPos.m_121990_((BlockPos)topLeft, (BlockPos)bottomRight).map(BlockPos::m_7949_).filter(e -> MiningCollect.isValid(player, e, world)).collect(Collectors.toList());
    }

    private static boolean isValid(Player player, BlockPos pos, Level world) {
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() instanceof RenderBlock) {
            return true;
        }
        if (!state.m_60819_().m_76178_() && !state.m_61138_((Property)BlockStateProperties.f_61362_) || world.m_46859_(pos)) {
            return false;
        }
        if (state.m_60800_((BlockGetter)world, pos) < 0.0f) {
            return false;
        }
        BlockEntity te = world.m_7702_(pos);
        if (te != null && !(te instanceof RenderBlockTileEntity)) {
            return false;
        }
        if (state.m_60734_() instanceof DoorBlock) {
            return false;
        }
        return !(state.m_60734_() instanceof MinersLight);
    }
}

