/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.client.screens;

import com.direwolf20.mininggadgets.common.containers.ModificationTableContainer;
import com.direwolf20.mininggadgets.common.items.MiningGadget;
import com.direwolf20.mininggadgets.common.items.UpgradeCard;
import com.direwolf20.mininggadgets.common.items.upgrade.Upgrade;
import com.direwolf20.mininggadgets.common.items.upgrade.UpgradeTools;
import com.direwolf20.mininggadgets.common.network.PacketHandler;
import com.direwolf20.mininggadgets.common.network.packets.PacketExtractUpgrade;
import com.direwolf20.mininggadgets.common.network.packets.PacketInsertUpgrade;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.gui.widget.ScrollPanel;
import net.minecraftforge.common.ForgeI18n;

public class ModificationTableScreen
extends AbstractContainerScreen<ModificationTableContainer> {
    private ResourceLocation GUI = new ResourceLocation("mininggadgets", "textures/gui/modificationtable.png");
    private BlockPos tePos;
    private ModificationTableContainer container;
    private Inventory playerInventory;
    private ScrollingUpgrades scrollingUpgrades;

    public ModificationTableScreen(ModificationTableContainer container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.tePos = container.getTE().m_58899_();
        this.container = container;
        this.playerInventory = inv;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.scrollingUpgrades.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.m_280072_(guiGraphics, mouseX, mouseY);
        int relX = this.f_96543_ / 2;
        int relY = this.f_96544_ / 2;
        guiGraphics.m_280137_(this.f_96547_, ForgeI18n.getPattern((String)String.format("%s.%s", "mininggadgets", "text.modification_table")), relX, relY - 100, 0xFFFFFF);
        if (this.container.getUpgradesCache().size() == 0) {
            String string = ForgeI18n.getPattern((String)String.format("%s.%s", "mininggadgets", "text.empty_table_helper"));
            String[] parts = string.split("\n");
            for (int i = 0; i < parts.length; ++i) {
                int n = relX + 17 - this.f_96547_.m_92895_(parts[0]) / 2;
                Objects.requireNonNull(this.f_96547_);
                this.drawScaledCenteredString(guiGraphics, n, relY - 68 + i * 9, 0.8f, parts[i], 0xFFFFFF);
            }
        }
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    private void drawScaledCenteredString(GuiGraphics guiGraphics, int x, int y, float scale, String textComponent, int color) {
        PoseStack matrices = guiGraphics.m_280168_();
        matrices.m_85836_();
        matrices.m_252880_((float)x, (float)y, 0.0f);
        matrices.m_85841_(scale, scale, scale);
        guiGraphics.m_280488_(this.f_96547_, textComponent, 0, 0, color);
        matrices.m_85849_();
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int relX = (this.f_96543_ - this.f_97726_) / 2;
        int relY = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280218_(this.GUI, relX - 23, relY, 0, 0, this.f_97726_ + 23, this.f_97727_);
    }

    public void m_7856_() {
        super.m_7856_();
        this.scrollingUpgrades = new ScrollingUpgrades(Minecraft.m_91087_(), this.f_97726_ - 14, 72, this.f_97736_ + 7, this.f_97735_ + 7, this);
        this.m_142416_((GuiEventListener)this.scrollingUpgrades);
    }

    public boolean m_6375_(double mouseXIn, double mouseYIn, int p_231044_5_) {
        ItemStack heldStack = ((ModificationTableContainer)this.f_97732_).m_142621_();
        ItemStack gadget = ((Slot)this.container.f_38839_.get(0)).m_7993_();
        if (!gadget.m_41619_() && gadget.m_41720_() instanceof MiningGadget && !heldStack.m_41619_() && heldStack.m_41720_() instanceof UpgradeCard && this.scrollingUpgrades.m_5953_(mouseXIn, mouseYIn)) {
            if (UpgradeTools.containsUpgrade(gadget, ((UpgradeCard)heldStack.m_41720_()).getUpgrade())) {
                return false;
            }
            PacketHandler.sendToServer(new PacketInsertUpgrade(this.tePos, heldStack));
            ((ModificationTableContainer)this.f_97732_).m_142503_(ItemStack.f_41583_);
        }
        return super.m_6375_(mouseXIn, mouseYIn, p_231044_5_);
    }

    private static class ScrollingUpgrades
    extends ScrollPanel
    implements NarratableEntry {
        ModificationTableScreen parent;
        Upgrade upgrade = null;

        ScrollingUpgrades(Minecraft client, int width, int height, int top, int left, ModificationTableScreen parent) {
            super(client, width, height, top, left);
            this.parent = parent;
        }

        public boolean m_6050_(double mouseX, double mouseY, double scroll) {
            if (this.getContentHeight() < this.height) {
                return false;
            }
            return super.m_6050_(mouseX, mouseY, scroll);
        }

        protected int getContentHeight() {
            return (int)Math.ceil((float)this.parent.container.getUpgradesCache().size() / 7.0f) * 20;
        }

        protected void drawPanel(GuiGraphics guiGraphics, int entryRight, int relativeY, Tesselator tess, int mouseX, int mouseY) {
            Enum currentUpgrade = null;
            int x = entryRight - this.width + 3;
            int y = relativeY;
            int index = 0;
            for (Upgrade upgrade : this.parent.container.getUpgradesCache()) {
                guiGraphics.m_280480_(new ItemStack((ItemLike)upgrade.getCardItem().get()), x, y);
                if (this.m_5953_(mouseX, mouseY) && mouseX > x && mouseX < x + 15 && mouseY > y && mouseY < y + 15) {
                    currentUpgrade = upgrade;
                }
                x += 22;
                if (++index % 7 != 0) continue;
                y += 20;
                x = entryRight - this.width + 3;
            }
            if (currentUpgrade == null || !currentUpgrade.equals((Object)this.upgrade)) {
                this.upgrade = currentUpgrade;
            }
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (!this.m_5953_(mouseX, mouseY) || this.upgrade == null) {
                return false;
            }
            PacketHandler.sendToServer(new PacketExtractUpgrade(this.parent.tePos, this.upgrade.getName(), this.upgrade.getName().length()));
            return super.m_6375_(mouseX, mouseY, button);
        }

        public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
            if (this.upgrade != null) {
                guiGraphics.m_280245_(Minecraft.m_91087_().f_91062_, Lists.transform((List)new ItemStack((ItemLike)this.upgrade.getCardItem().get()).m_41651_((Player)this.parent.getMinecraft().f_91074_, (TooltipFlag)TooltipFlag.Default.f_256752_), Component::m_7532_), mouseX, mouseY);
            }
        }

        public NarratableEntry.NarrationPriority m_142684_() {
            return NarratableEntry.NarrationPriority.NONE;
        }

        public void m_142291_(NarrationElementOutput p_169152_) {
        }
    }
}

