/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.util;

import com.ldtteam.structurize.blockentities.interfaces.IBlueprintDataProviderBE;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.colony.buildings.HiringMode;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.util.InventoryUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BuildingUtils {
    public static final Predicate<JobEntry> UNRESTRICTED = job -> true;

    private BuildingUtils() {
    }

    public static ItemStack getItemStackForHutFromInventory(Inventory inventory, String hut) {
        int slot = InventoryUtils.findFirstSlotInProviderNotEmptyWith((ICapabilityProvider)inventory.f_35978_, item -> item.m_41720_() instanceof BlockItem && ((BlockItem)item.m_41720_()).m_40614_() instanceof AbstractBlockHut && ForgeRegistries.BLOCKS.getKey((Object)((BlockItem)item.m_41720_()).m_40614_()).m_135815_().endsWith(hut));
        if (slot != -1) {
            return inventory.m_8020_(slot);
        }
        return ItemStack.f_41583_;
    }

    @NotNull
    public static Predicate<JobEntry> getAllowedJobs(@NotNull Level world, @NotNull BlockPos buildingPos) {
        IBlueprintDataProviderBE provider;
        Set jobTags;
        BlockEntity blockEntity = world.m_7702_(buildingPos);
        if (blockEntity instanceof IBlueprintDataProviderBE && !(jobTags = ((List)(provider = (IBlueprintDataProviderBE)blockEntity).getPositionedTags().getOrDefault(BlockPos.f_121853_, new ArrayList())).stream().filter(t -> t.startsWith("job=")).map(t -> t.substring(4)).collect(Collectors.toSet())).isEmpty()) {
            return job -> jobTags.contains(job.getKey().m_135815_()) || jobTags.contains(job.getKey().toString());
        }
        return UNRESTRICTED;
    }

    public static boolean canAutoHire(@NotNull IBuilding building, @NotNull HiringMode hiringMode, @Nullable JobEntry job) {
        return building.canAssignCitizens() && (hiringMode == HiringMode.DEFAULT && !building.getColony().isManualHiring() || hiringMode == HiringMode.AUTO) && (job == null || BuildingUtils.getAllowedJobs(building.getColony().getWorld(), building.getPosition()).test(job));
    }
}

