/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.research;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.research.IResearchRequirement;
import com.minecolonies.api.research.ModResearchRequirements;
import com.minecolonies.api.research.registry.ResearchRequirementEntry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;

public class ResearchResearchRequirement
implements IResearchRequirement {
    private static final String TAG_ID = "id";
    private static final String TAG_NAME = "name";
    private final ResourceLocation researchId;
    private final MutableComponent researchName;

    public ResearchResearchRequirement(ResourceLocation researchId) {
        this.researchId = researchId;
        this.researchName = Component.m_237115_((String)("com." + researchId.m_135827_() + ".research." + researchId.m_135815_().replaceAll("[ /]", ".") + ".name"));
    }

    public ResearchResearchRequirement(ResourceLocation researchId, MutableComponent researchName) {
        this.researchId = researchId;
        this.researchName = researchName;
    }

    public ResearchResearchRequirement(CompoundTag nbt) {
        this.researchId = new ResourceLocation(nbt.m_128461_(TAG_ID));
        this.researchName = Component.m_237115_((String)nbt.m_128461_(TAG_NAME));
    }

    public ResourceLocation getResearchId() {
        return this.researchId;
    }

    @Override
    public boolean isFulfilled(IColony colony) {
        return colony.getResearchManager().getResearchTree().hasCompletedResearch(this.researchId);
    }

    @Override
    public MutableComponent getDesc() {
        return Component.m_237110_((String)"com.minecolonies.coremod.research.requirement.research", (Object[])new Object[]{this.researchName});
    }

    @Override
    public ResearchRequirementEntry getRegistryEntry() {
        return (ResearchRequirementEntry)ModResearchRequirements.researchResearchRequirement.get();
    }

    @Override
    public CompoundTag writeToNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_(TAG_ID, this.researchId.toString());
        nbt.m_128359_(TAG_NAME, this.researchName.m_214077_() instanceof TranslatableContents ? ((TranslatableContents)this.researchName.m_214077_()).m_237508_() : "");
        return nbt;
    }
}

