/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.quests.triggers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.quests.IQuestTriggerTemplate;
import com.minecolonies.api.quests.ITriggerReturnData;
import com.minecolonies.api.util.constant.ColonyConstants;
import com.minecolonies.core.quests.triggers.CitizenTriggerReturnData;
import java.util.Collections;
import java.util.List;

public class CitizenQuestTriggerTemplate
implements IQuestTriggerTemplate {
    public JsonElement matchTag = null;
    public JsonElement notMatchTag = null;

    public CitizenQuestTriggerTemplate(JsonObject tag) {
        if (tag.has("match")) {
            this.matchTag = tag.get("match");
        }
        if (tag.has("notmatch")) {
            this.notMatchTag = tag.get("notmatch");
        }
    }

    public static CitizenQuestTriggerTemplate createStateTrigger(JsonObject questTriggerJson) {
        JsonObject subObj = questTriggerJson.get("state").getAsJsonObject();
        return new CitizenQuestTriggerTemplate(subObj);
    }

    @Override
    public ITriggerReturnData canTriggerQuest(IColony colony) {
        List<ICitizenData> citizenDataList = colony.getCitizenManager().getCitizens();
        if (this.matchTag == null && this.notMatchTag == null) {
            if (citizenDataList.isEmpty()) {
                return new CitizenTriggerReturnData(null);
            }
            return new CitizenTriggerReturnData(citizenDataList.get(ColonyConstants.rand.nextInt(citizenDataList.size())));
        }
        Collections.shuffle(citizenDataList);
        for (ICitizenData data : citizenDataList) {
            if (this.matchTag != null && !IQuestTriggerTemplate.matchNbt(data.serializeNBT(), this.matchTag) || this.notMatchTag != null && IQuestTriggerTemplate.matchNbt(data.serializeNBT(), this.notMatchTag)) continue;
            return new CitizenTriggerReturnData(data);
        }
        return new CitizenTriggerReturnData(null);
    }
}

