/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony.citizen;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.network.messages.server.AbstractColonyServerMessage;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class TransferItemsToCitizenRequestMessage
extends AbstractColonyServerMessage {
    private int citizenId;
    private ItemStack itemStack;
    private int quantity;

    public TransferItemsToCitizenRequestMessage() {
    }

    public TransferItemsToCitizenRequestMessage(IColony colony, @NotNull ICitizenDataView citizenDataView, ItemStack itemStack, int quantity) {
        super(colony);
        this.citizenId = citizenDataView.getId();
        this.itemStack = itemStack;
        this.quantity = quantity;
    }

    @Override
    public void fromBytesOverride(@NotNull FriendlyByteBuf buf) {
        this.citizenId = buf.readInt();
        this.itemStack = buf.m_130267_();
        this.quantity = buf.readInt();
    }

    @Override
    public void toBytesOverride(@NotNull FriendlyByteBuf buf) {
        buf.writeInt(this.citizenId);
        buf.m_130055_(this.itemStack);
        buf.writeInt(this.quantity);
    }

    @Override
    protected void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony) {
        int tempAmount;
        int count;
        ICitizenData citizenData = colony.getCitizenManager().getCivilian(this.citizenId);
        if (citizenData == null) {
            Log.getLogger().warn("TransferItemsRequestMessage citizenData is null");
            return;
        }
        Optional<AbstractEntityCitizen> optionalEntityCitizen = citizenData.getEntity();
        if (!optionalEntityCitizen.isPresent()) {
            Log.getLogger().warn("TransferItemsRequestMessage entity citizen is null");
            return;
        }
        ServerPlayer player = ctxIn.getSender();
        if (player == null) {
            return;
        }
        boolean isCreative = player.m_7500_();
        if (this.quantity <= 0 && !isCreative) {
            Log.getLogger().warn("TransferItemsRequestMessage quantity below 0");
            return;
        }
        Map<ItemStorage, ItemStorage> previousContent = null;
        int amountToTake = isCreative ? this.quantity : Math.min(this.quantity, InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((Container)player.m_150109_()), stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, this.itemStack)));
        ArrayList<Object> itemsToPut = new ArrayList<Object>();
        for (tempAmount = amountToTake; tempAmount > 0; tempAmount -= count) {
            count = Math.min(this.itemStack.m_41741_(), tempAmount);
            ItemStack stack2 = this.itemStack.m_41777_();
            stack2.m_41764_(count);
            itemsToPut.add(stack2);
        }
        AbstractEntityCitizen citizen = optionalEntityCitizen.get();
        if (!isCreative && ((Boolean)MineColonies.getConfig().getServer().debugInventories.get()).booleanValue()) {
            previousContent = InventoryUtils.getAllItemsForProviders(new IItemHandler[]{citizen.getInventoryCitizen(), new InvWrapper((Container)player.m_150109_())});
        }
        tempAmount = 0;
        for (ItemStack itemStack : itemsToPut) {
            ItemStack remainingItemStack = InventoryUtils.addItemStackToItemHandlerWithResult((IItemHandler)citizen.getInventoryCitizen(), itemStack);
            if (!ItemStackUtils.isEmpty(remainingItemStack)) {
                tempAmount += itemStack.m_41613_() - remainingItemStack.m_41613_();
                break;
            }
            tempAmount += itemStack.m_41613_();
        }
        if (!isCreative) {
            ItemStack itemsTaken;
            for (int amountToRemoveFromPlayer = tempAmount; amountToRemoveFromPlayer > 0; amountToRemoveFromPlayer -= ItemStackUtils.getSize(itemsTaken)) {
                int n = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)new InvWrapper((Container)player.m_150109_()), stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, this.itemStack));
                itemsTaken = player.m_150109_().m_7407_(n, amountToRemoveFromPlayer);
            }
        }
        if (!isCreative && previousContent != null && ((Boolean)MineColonies.getConfig().getServer().debugInventories.get()).booleanValue()) {
            InventoryUtils.doStorageSetsMatch(previousContent, InventoryUtils.getAllItemsForProviders(new IItemHandler[]{citizen.getInventoryCitizen(), new InvWrapper((Container)player.m_150109_())}), true);
        }
    }
}

