/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony.building.worker;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.core.colony.buildings.modules.AbstractCraftingBuildingModule;
import com.minecolonies.core.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class ChangeRecipePriorityMessage
extends AbstractBuildingServerMessage<IBuilding> {
    private int recipeLocation;
    private boolean up;
    private int id;
    private boolean fullMove;

    public ChangeRecipePriorityMessage() {
    }

    public ChangeRecipePriorityMessage(@NotNull IBuildingView building, int location, boolean up, int id, boolean fullMove) {
        super(building);
        this.recipeLocation = location;
        this.up = up;
        this.id = id;
        this.fullMove = fullMove;
    }

    @Override
    public void fromBytesOverride(@NotNull FriendlyByteBuf buf) {
        this.recipeLocation = buf.readInt();
        this.up = buf.readBoolean();
        this.id = buf.readInt();
        this.fullMove = buf.readBoolean();
    }

    @Override
    public void toBytesOverride(@NotNull FriendlyByteBuf buf) {
        buf.writeInt(this.recipeLocation);
        buf.writeBoolean(this.up);
        buf.writeInt(this.id);
        buf.writeBoolean(this.fullMove);
    }

    @Override
    protected void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony, IBuilding building) {
        IBuildingModule iBuildingModule = building.getModule(this.id);
        if (iBuildingModule instanceof AbstractCraftingBuildingModule) {
            AbstractCraftingBuildingModule module = (AbstractCraftingBuildingModule)iBuildingModule;
            if (this.up) {
                module.switchOrder(this.recipeLocation, this.recipeLocation - 1, this.fullMove);
            } else {
                module.switchOrder(this.recipeLocation, this.recipeLocation + 1, this.fullMove);
            }
        }
    }
}

