/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.network.messages.server.AbstractColonyServerMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeFreeToInteractBlockMessage
extends AbstractColonyServerMessage {
    private BlockPos pos = new BlockPos(0, 0, 0);
    private BlockState block = Blocks.f_50493_.m_49966_();
    private MessageType type;
    private MessageMode mode;

    public ChangeFreeToInteractBlockMessage() {
    }

    public ChangeFreeToInteractBlockMessage(@NotNull IColonyView colony, @NotNull Block block, @NotNull MessageType type) {
        super(colony);
        this.pos = new BlockPos(0, 0, 0);
        this.block = block.m_49966_();
        this.type = type;
        this.mode = MessageMode.BLOCK;
    }

    public ChangeFreeToInteractBlockMessage(@NotNull IColonyView colony, @NotNull BlockPos pos, @NotNull MessageType type) {
        super(colony);
        this.pos = pos;
        this.block = Blocks.f_50493_.m_49966_();
        this.type = type;
        this.mode = MessageMode.LOCATION;
    }

    @Override
    public void fromBytesOverride(@NotNull FriendlyByteBuf buf) {
        this.block = Block.m_49803_((int)buf.readInt());
        this.pos = buf.m_130135_();
        this.type = MessageType.values()[buf.readInt()];
        this.mode = MessageMode.values()[buf.readInt()];
    }

    @Override
    public void toBytesOverride(@NotNull FriendlyByteBuf buf) {
        buf.writeInt(Block.m_49956_((BlockState)this.block));
        buf.m_130064_(this.pos);
        buf.writeInt(this.type.ordinal());
        buf.writeInt(this.mode.ordinal());
    }

    @Override
    @Nullable
    public Action permissionNeeded() {
        return Action.EDIT_PERMISSIONS;
    }

    @Override
    protected void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony) {
        ServerPlayer player = ctxIn.getSender();
        if (player == null) {
            return;
        }
        if (this.type == MessageType.ADD_BLOCK) {
            switch (this.mode) {
                case LOCATION: {
                    colony.addFreePosition(this.pos);
                    MessageUtils.format("com.minecolonies.coremod.item.permissionscepter.addposition.success", this.pos.m_123341_(), this.pos.m_123342_(), this.pos.m_123343_()).sendTo(new Player[]{player});
                    break;
                }
                case BLOCK: {
                    colony.addFreeBlock(this.block.m_60734_());
                    MessageUtils.format("com.minecolonies.coremod.item.permissionscepter.addblock.success", ForgeRegistries.BLOCKS.getKey((Object)this.block.m_60734_())).sendTo(new Player[]{player});
                    break;
                }
            }
        } else {
            switch (this.mode) {
                case LOCATION: {
                    colony.removeFreePosition(this.pos);
                    MessageUtils.format("com.minecolonies.coremod.item.permissionscepter.removelocation.success", this.pos.m_123341_(), this.pos.m_123342_(), this.pos.m_123343_()).sendTo(new Player[]{player});
                    break;
                }
                case BLOCK: {
                    colony.removeFreeBlock(this.block.m_60734_());
                    MessageUtils.format("com.minecolonies.coremod.item.permissionscepter.removeblock.success", ForgeRegistries.BLOCKS.getKey((Object)this.block.m_60734_())).sendTo(new Player[]{player});
                    break;
                }
            }
        }
    }

    public static enum MessageType {
        REMOVE_BLOCK,
        ADD_BLOCK;

    }

    public static enum MessageMode {
        LOCATION,
        BLOCK;

    }
}

