/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.client.colony;

import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.workorders.IWorkOrder;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.core.colony.Colony;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColonyViewWorkOrderMessage
implements IMessage {
    private int colonyId;
    private ResourceKey<Level> dimension;
    private FriendlyByteBuf workOrderBuffer;

    public ColonyViewWorkOrderMessage() {
    }

    public ColonyViewWorkOrderMessage(@NotNull Colony colony, @NotNull List<IWorkOrder> workOrderList) {
        this.colonyId = colony.getID();
        this.workOrderBuffer = new FriendlyByteBuf(Unpooled.buffer());
        this.dimension = colony.getDimension();
        this.workOrderBuffer.writeInt(workOrderList.size());
        for (IWorkOrder workOrder : workOrderList) {
            workOrder.serializeViewNetworkData(this.workOrderBuffer);
        }
    }

    @Override
    public void fromBytes(@NotNull FriendlyByteBuf buf) {
        FriendlyByteBuf newbuf = new FriendlyByteBuf(buf.retain());
        this.colonyId = newbuf.readInt();
        this.dimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(newbuf.m_130136_(Short.MAX_VALUE)));
        this.workOrderBuffer = newbuf;
    }

    @Override
    public void toBytes(@NotNull FriendlyByteBuf buf) {
        this.workOrderBuffer.resetReaderIndex();
        buf.writeInt(this.colonyId);
        buf.m_130070_(this.dimension.m_135782_().toString());
        buf.writeBytes((ByteBuf)this.workOrderBuffer);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        IColonyManager.getInstance().handleColonyViewWorkOrderMessage(this.colonyId, this.workOrderBuffer, this.dimension);
        this.workOrderBuffer.release();
    }
}

