/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.client;

import com.minecolonies.api.network.IMessage;
import com.minecolonies.core.client.render.worldevent.PathfindingDebugRenderer;
import com.minecolonies.core.entity.pathfinding.MNode;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class SyncPathReachedMessage
implements IMessage {
    public Set<BlockPos> reached = new HashSet<BlockPos>();

    public SyncPathReachedMessage() {
    }

    public SyncPathReachedMessage(Set<BlockPos> reached) {
        this.reached = reached;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.reached.size());
        for (BlockPos node : this.reached) {
            buf.m_130064_(node);
        }
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf) {
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.reached.add(buf.m_130135_());
        }
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        for (MNode node : PathfindingDebugRenderer.lastDebugNodesPath) {
            if (!this.reached.contains(node.pos)) continue;
            node.setReachedByWorker(true);
        }
    }
}

