/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.client;

import com.minecolonies.api.network.IMessage;
import com.minecolonies.core.client.render.worldevent.PathfindingDebugRenderer;
import com.minecolonies.core.entity.pathfinding.MNode;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class SyncPathMessage
implements IMessage {
    public Set<MNode> lastDebugNodesVisited = new HashSet<MNode>();
    public Set<MNode> lastDebugNodesNotVisited = new HashSet<MNode>();
    public Set<MNode> lastDebugNodesPath = new HashSet<MNode>();

    public SyncPathMessage() {
    }

    public SyncPathMessage(Set<MNode> lastDebugNodesVisited, Set<MNode> lastDebugNodesNotVisited, Set<MNode> lastDebugNodesPath) {
        this.lastDebugNodesVisited = lastDebugNodesVisited;
        this.lastDebugNodesNotVisited = lastDebugNodesNotVisited;
        this.lastDebugNodesPath = lastDebugNodesPath;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.lastDebugNodesVisited.size());
        for (MNode node : this.lastDebugNodesVisited) {
            node.serializeToBuf(buf);
        }
        buf.writeInt(this.lastDebugNodesNotVisited.size());
        for (MNode node : this.lastDebugNodesNotVisited) {
            node.serializeToBuf(buf);
        }
        buf.writeInt(this.lastDebugNodesPath.size());
        for (MNode node : this.lastDebugNodesPath) {
            node.serializeToBuf(buf);
        }
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf) {
        int i;
        int size = buf.readInt();
        for (i = 0; i < size; ++i) {
            this.lastDebugNodesVisited.add(new MNode(buf));
        }
        size = buf.readInt();
        for (i = 0; i < size; ++i) {
            this.lastDebugNodesNotVisited.add(new MNode(buf));
        }
        size = buf.readInt();
        for (i = 0; i < size; ++i) {
            this.lastDebugNodesPath.add(new MNode(buf));
        }
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        PathfindingDebugRenderer.lastDebugNodesVisited = this.lastDebugNodesVisited;
        PathfindingDebugRenderer.lastDebugNodesNotVisited = this.lastDebugNodesNotVisited;
        PathfindingDebugRenderer.lastDebugNodesPath = this.lastDebugNodesPath;
    }
}

