/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.client;

import com.ldtteam.structurize.storage.StructurePacks;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.event.ColonyCreatedEvent;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.tileentities.TileEntityColonyBuilding;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class CreateColonyMessage
implements IMessage {
    BlockPos townHall;
    boolean claim;
    String colonyName;
    String packName;
    String pathName;

    public CreateColonyMessage() {
    }

    public CreateColonyMessage(BlockPos townHall, boolean claim, String colonyName, String packName, String pathName) {
        this.townHall = townHall;
        this.claim = claim;
        this.colonyName = colonyName;
        this.packName = packName;
        this.pathName = pathName;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.townHall);
        buf.writeBoolean(this.claim);
        buf.m_130070_(this.colonyName);
        buf.m_130070_(this.packName);
        buf.m_130070_(this.pathName);
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf) {
        this.townHall = buf.m_130135_();
        this.claim = buf.readBoolean();
        this.colonyName = buf.m_130136_(Short.MAX_VALUE);
        this.packName = buf.m_130136_(Short.MAX_VALUE);
        this.pathName = buf.m_130136_(Short.MAX_VALUE);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        ServerPlayer sender = ctxIn.getSender();
        Level world = ctxIn.getSender().f_19853_;
        if (sender == null) {
            return;
        }
        IColony colony = IColonyManager.getInstance().getClosestColony(world, this.townHall);
        String pack = this.packName;
        BlockEntity tileEntity = world.m_7702_(this.townHall);
        if (!(tileEntity instanceof TileEntityColonyBuilding)) {
            MessageUtils.format("com.minecolonies.coremod.gui.colony.create.notileentity", new Object[0]).withPriority(MessageUtils.MessagePriority.DANGER).sendTo(new Player[]{sender});
            return;
        }
        TileEntityColonyBuilding hut = (TileEntityColonyBuilding)tileEntity;
        if (hut.getStructurePack() != null && this.claim) {
            pack = hut.getStructurePack().getName();
        }
        if (((List)hut.getPositionedTags().getOrDefault(BlockPos.f_121853_, new ArrayList())).contains("deactivated")) {
            hut.reactivate();
            if (hut.getStructurePack() != null) {
                pack = hut.getStructurePack().getName();
            }
        }
        hut.setStructurePack(StructurePacks.getStructurePack((String)pack));
        hut.setBlueprintPath(this.pathName);
        double spawnDistance = Math.sqrt(BlockPosUtil.getDistanceSquared2D(this.townHall, ((ServerLevel)world).m_220360_()));
        if (spawnDistance < (double)((Integer)MineColonies.getConfig().getServer().minDistanceFromWorldSpawn.get()).intValue()) {
            if (!world.f_46443_) {
                MessageUtils.format("com.minecolonies.coremod.tooclose", MineColonies.getConfig().getServer().minDistanceFromWorldSpawn.get()).sendTo(new Player[]{sender});
            }
            return;
        }
        if (spawnDistance > (double)((Integer)MineColonies.getConfig().getServer().maxDistanceFromWorldSpawn.get()).intValue()) {
            if (!world.f_46443_) {
                MessageUtils.format("com.minecolonies.coremod.toofar", MineColonies.getConfig().getServer().maxDistanceFromWorldSpawn.get()).sendTo(new Player[]{sender});
            }
            return;
        }
        if (colony != null && !IColonyManager.getInstance().isFarEnoughFromColonies(world, this.townHall)) {
            MessageUtils.format("com.minecolonies.coremod.gui.colony.denied.tooclose", colony.getName()).sendTo(new Player[]{sender});
            return;
        }
        IColony ownedColony = IColonyManager.getInstance().getIColonyByOwner(world, (Player)sender);
        if (ownedColony == null) {
            IColony createdColony = IColonyManager.getInstance().createColony(world, this.townHall, (Player)sender, this.colonyName, pack);
            createdColony.getBuildingManager().addNewBuilding((TileEntityColonyBuilding)tileEntity, world);
            MessageUtils.format("com.minecolonies.coremod.progress.colony_founded", new Object[0]).withPriority(MessageUtils.MessagePriority.IMPORTANT).sendTo(new Player[]{sender});
            if (isLogicalServer) {
                MinecraftForge.EVENT_BUS.post((Event)new ColonyCreatedEvent(createdColony));
            }
            return;
        }
        ownedColony.getPackageManager().sendColonyViewPackets();
        ownedColony.getPackageManager().sendPermissionsPackets();
        MessageUtils.format("com.minecolonies.coremod.gui.colony.create.failed", new Object[0]).withPriority(MessageUtils.MessagePriority.DANGER).sendTo(new Player[]{sender});
    }
}

