/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.generation.defaults;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minecolonies.api.quests.registries.QuestRegistries;
import com.minecolonies.api.util.Log;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.Util;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.resource.PathPackResources;
import org.jetbrains.annotations.NotNull;

public class QuestTranslationProvider
implements DataProvider {
    private final PackOutput packOutput;

    public QuestTranslationProvider(@NotNull PackOutput packOutput) {
        this.packOutput = packOutput;
    }

    @NotNull
    public String m_6055_() {
        return "QuestTranslationProvider";
    }

    @NotNull
    public CompletableFuture<?> m_213708_(@NotNull CachedOutput cache) {
        PackOutput.PathProvider questProvider = this.packOutput.m_245269_(PackOutput.Target.DATA_PACK, "quests");
        ArrayList quests = new ArrayList();
        try (PathPackResources pack = new PathPackResources("minecolonies.src", false, Path.of("..", "src", "main", "resources"));){
            pack.m_8031_(PackType.SERVER_DATA, "minecolonies", "quests", (questId, stream) -> {
                if (!questId.m_135815_().endsWith(".json")) {
                    return;
                }
                ResourceLocation questPath = new ResourceLocation(questId.m_135827_(), questId.m_135815_().replace("quests/", "").replace(".json", ""));
                String baseKey = questPath.m_135827_() + ".quests." + questPath.m_135815_().replace("/", ".");
                JsonObject langJson = new JsonObject();
                quests.add(CompletableFuture.supplyAsync(() -> {
                    try {
                        JsonObject questJson;
                        try (InputStreamReader reader = new InputStreamReader((InputStream)stream.m_247737_());){
                            questJson = GsonHelper.m_13859_((Reader)reader);
                        }
                        this.processQuest(langJson, baseKey, questJson);
                        return questJson;
                    }
                    catch (Exception e) {
                        Log.getLogger().error("Failed to process {}", (Object)questPath.toString(), (Object)e);
                        return null;
                    }
                }, Util.m_183991_()).thenComposeAsync(json -> {
                    if (json != null) {
                        return DataProvider.m_253162_((CachedOutput)cache, (JsonElement)json, (Path)questProvider.m_245731_(questPath)).thenApply(q -> langJson);
                    }
                    return CompletableFuture.completedFuture(null);
                }, (Executor)Util.m_183991_()));
            });
        }
        return CompletableFuture.allOf((CompletableFuture[])quests.toArray(CompletableFuture[]::new)).thenComposeAsync(v -> this.saveLanguage(cache, quests.stream().map(q -> (JsonObject)q.join()).toList()), (Executor)Util.m_183991_());
    }

    @NotNull
    private CompletableFuture<?> saveLanguage(@NotNull CachedOutput cache, @NotNull List<JsonObject> langJsons) {
        JsonObject langJson = new JsonObject();
        for (JsonObject questLang : langJsons) {
            for (Map.Entry entry : questLang.entrySet()) {
                langJson.add((String)entry.getKey(), (JsonElement)entry.getValue());
            }
        }
        PackOutput.PathProvider langProvider = this.packOutput.m_245269_(PackOutput.Target.RESOURCE_PACK, "lang");
        Path langFile = langProvider.m_245527_(new ResourceLocation("minecolonies", "quests"), "json");
        return DataProvider.m_253162_((CachedOutput)cache, (JsonElement)langJson, (Path)langFile);
    }

    private void processQuest(JsonObject langJson, String baseKey, JsonObject json) {
        String name = json.get("name").getAsString();
        langJson.addProperty(baseKey, name);
        json.addProperty("name", baseKey);
        int objectiveCount = 0;
        for (JsonElement objectivesJson : json.get("objectives").getAsJsonArray()) {
            String objectiveKey = baseKey + ".obj" + objectiveCount;
            JsonObject objective = objectivesJson.getAsJsonObject();
            this.processObjective(langJson, objectiveKey, objective);
            ++objectiveCount;
        }
    }

    private void processObjective(JsonObject langJson, String baseKey, JsonObject json) {
        ResourceLocation type = new ResourceLocation(json.get("type").getAsString());
        if (type.equals((Object)QuestRegistries.DIALOGUE_OBJECTIVE_ID)) {
            langJson.addProperty(baseKey, json.get("text").getAsString());
            json.addProperty("text", baseKey);
            int answerCount = 0;
            for (JsonElement answerJson : json.get("options").getAsJsonArray()) {
                String answerKey = baseKey + ".answer" + answerCount;
                langJson.addProperty(answerKey, answerJson.getAsJsonObject().get("answer").getAsString());
                answerJson.getAsJsonObject().addProperty("answer", answerKey);
                JsonObject result = answerJson.getAsJsonObject().get("result").getAsJsonObject();
                this.processObjective(langJson, answerKey + ".reply", result);
                ++answerCount;
            }
        }
    }
}

