/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.pathfinding.pathjobs;

import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.entity.pathfinding.PathingOptions;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.ColonyUtils;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import com.minecolonies.core.entity.pathfinding.MNode;
import com.minecolonies.core.entity.pathfinding.pathjobs.AbstractPathJob;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.NotNull;

public class PathJobPathway
extends AbstractPathJob {
    private final List<IBuilding> buildings;
    private int colonyid = -1;
    private double addCost = 1.0;

    public PathJobPathway(int colonyID, List<IBuilding> buildings, Level world, @NotNull BlockPos start, BlockPos end, int range, EntityCitizen citizen) {
        super(world, start, end, range, (LivingEntity)citizen);
        this.colonyid = colonyID;
        this.buildings = buildings;
        this.setPathingOptions(new PathingOptions().withJumpCost(100.0).withStartSwimCost(30.0).withSwimCost(5.0).withCanSwim(true).withCanEnterDoors(true));
    }

    @Override
    protected double computeHeuristic(BlockPos pos) {
        LevelChunk chunk = (LevelChunk)this.world.m_6325_(pos.m_123341_() >> 4, pos.m_123343_() >> 4);
        if (ColonyUtils.getOwningColony(chunk) == this.colonyid) {
            return Math.sqrt(this.end.m_123331_((Vec3i)pos)) / (double)(ColonyUtils.getAllClaimingBuildings(chunk).size() + 1);
        }
        return Math.sqrt(this.end.m_123331_((Vec3i)pos));
    }

    @Override
    protected boolean isAtDestination(MNode n) {
        return this.end.m_123331_((Vec3i)n.pos) < 25.0;
    }

    @Override
    protected double getNodeResultScore(MNode n) {
        double dist = Math.sqrt(this.end.m_123331_((Vec3i)n.pos));
        if (dist < 15.0) {
            return n.getCost();
        }
        return dist;
    }

    @Override
    protected boolean isPassable(BlockPos pos, boolean head, MNode currentnode) {
        if (super.isPassable(pos, head, currentnode)) {
            for (IBuilding building : this.buildings) {
                if (!BlockPosUtil.isInArea((BlockPos)building.getCorners().m_14418_(), (BlockPos)building.getCorners().m_14419_(), pos) || BlockPosUtil.isInArea((BlockPos)building.getCorners().m_14418_(), (BlockPos)building.getCorners().m_14419_(), this.end) || BlockPosUtil.isInArea((BlockPos)building.getCorners().m_14418_(), (BlockPos)building.getCorners().m_14419_(), this.start)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    protected double calcAdditionalCost(double stepCost, MNode parent, BlockPos pos, BlockState state) {
        if (parent.parent != null && parent.pos.m_123341_() == parent.parent.pos.m_123341_() && pos.m_123341_() != parent.pos.m_123341_()) {
            return stepCost * 10.0;
        }
        if (parent.parent != null && parent.pos.m_123343_() == parent.parent.pos.m_123343_() && pos.m_123343_() != parent.pos.m_123343_()) {
            return stepCost * 10.0;
        }
        return stepCost;
    }
}

