/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.pathfinding;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;

public class CachingBlockLookup {
    private int centerX;
    private int centerY;
    private int centerZ;
    private final LevelReader world;
    private final BlockPos.MutableBlockPos temp = new BlockPos.MutableBlockPos();
    private final BlockState[] states = new BlockState[125];

    public CachingBlockLookup(BlockPos center, LevelReader world) {
        this.centerX = center.m_123341_() + 2;
        this.centerY = center.m_123342_() + 2;
        this.centerZ = center.m_123343_() + 2;
        this.world = world;
    }

    public BlockState getBlockState(BlockPos pos) {
        int xPos = this.centerX - pos.m_123341_();
        int yPos = this.centerY - pos.m_123342_();
        int zPos = this.centerZ - pos.m_123343_();
        if (xPos < 0 || xPos > 4 || yPos < 0 || yPos > 4 || zPos < 0 || zPos > 4) {
            return this.world.m_8055_(pos);
        }
        int index = xPos + yPos * 5 + zPos * 5 * 5;
        BlockState state = this.states[index];
        if (state == null) {
            this.states[index] = state = this.world.m_8055_(pos);
        }
        return state;
    }

    public BlockState getBlockState(int x, int y, int z) {
        int xPos = this.centerX - x;
        int yPos = this.centerY - y;
        int zPos = this.centerZ - z;
        if (xPos < 0 || xPos > 4 || yPos < 0 || yPos > 4 || zPos < 0 || zPos > 4) {
            return this.world.m_8055_((BlockPos)this.temp.m_122178_(x, y, z));
        }
        int index = xPos + yPos * 5 + zPos * 5 * 5;
        BlockState state = this.states[index];
        if (state == null) {
            this.states[index] = state = this.world.m_8055_((BlockPos)this.temp.m_122178_(x, y, z));
        }
        return state;
    }

    public void resetToNextPos(BlockPos next) {
        for (int i = 0; i < this.states.length; ++i) {
            this.states[i] = null;
        }
        this.centerX = next.m_123341_() + 2;
        this.centerY = next.m_123342_() + 2;
        this.centerZ = next.m_123343_() + 2;
    }
}

