/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.production.herders;

import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.api.util.constant.ColonyConstants;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.buildings.modules.AnimalHerdingModule;
import com.minecolonies.core.colony.buildings.modules.BuildingModules;
import com.minecolonies.core.colony.jobs.AbstractJob;
import com.minecolonies.core.entity.ai.workers.AbstractEntityAIInteract;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEntityAIHerder<J extends AbstractJob<?, J>, B extends AbstractBuilding>
extends AbstractEntityAIInteract<J, B> {
    private static final int ANIMAL_MULTIPLIER = 2;
    private static final int NUM_OF_ANIMALS_TO_BREED = 2;
    private static final int EXTRA_BREEDING_ITEMS_REQUEST = 8;
    protected static final int BUTCHERING_ATTACK_DAMAGE = 5;
    private static final int DISTANCE_TO_BREED = 10;
    private static final int BUTCHER_DELAY = 20;
    private static final int DECIDING_DELAY = 80;
    private static final int BREEDING_DELAY = 40;
    public static final int LIMIT_TO_FEED_CHILDREN = 10;
    private static final int ACTIONS_FOR_DUMP = 10;
    private static final double MAX_ENTITY_AGE = -24000.0;
    protected static final double XP_PER_ACTION = 0.5;
    private static final double FEED_CHANCE = 0.1;
    @Nullable
    protected AnimalHerdingModule current_module;
    private final List<Animal> animalsToBreed = new ArrayList<Animal>();
    private final Map<UUID, Long> fedRecently = new HashMap<UUID, Long>();
    private int breedTimeOut = 0;

    public AbstractEntityAIHerder(@NotNull J job) {
        super(job);
        super.registerTargets(new AITarget<AIWorkerState>(AIWorkerState.IDLE, AIWorkerState.START_WORKING, 1), new AITarget<Object>(AIWorkerState.START_WORKING, this::startWorkingAtOwnBuilding, 20), new AITarget<Object>(AIWorkerState.PREPARING, this::prepareForHerding, 20), new AITarget<Object>(AIWorkerState.DECIDE, this::decideWhatToDo, 80), new AITarget<Object>(AIWorkerState.HERDER_BREED, this::breedAnimals, 40), new AITarget<Object>(AIWorkerState.HERDER_BUTCHER, this::butcherAnimals, 20), new AITarget<Object>(AIWorkerState.HERDER_PICKUP, this::pickupItems, 20), new AITarget<Object>(AIWorkerState.HERDER_FEED, this::feedAnimal, 20));
        this.worker.m_21553_(true);
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 10;
    }

    @Override
    @NotNull
    protected List<ItemStack> itemsNiceToHave() {
        List<ItemStack> list = super.itemsNiceToHave();
        for (AnimalHerdingModule module : this.building.getModulesByType(AnimalHerdingModule.class)) {
            list.addAll(this.getRequestBreedingItems(module));
        }
        return list;
    }

    @NotNull
    public List<ToolType> getExtraToolsNeeded() {
        ArrayList<ToolType> toolsNeeded = new ArrayList<ToolType>();
        toolsNeeded.add(ToolType.AXE);
        return toolsNeeded;
    }

    @NotNull
    public List<ItemStack> getExtraItemsNeeded() {
        return new ArrayList<ItemStack>();
    }

    public IAIState decideWhatToDo() {
        this.worker.getCitizenData().setVisibleStatus(VisibleCitizenStatus.WORKING);
        if (this.breedTimeOut > 0) {
            this.breedTimeOut -= 80;
        }
        for (AnimalHerdingModule module : this.building.getModulesByType(AnimalHerdingModule.class)) {
            boolean hasBreedingItem;
            List<Animal> animals = this.searchForAnimals(module::isCompatible);
            if (animals.isEmpty()) continue;
            this.current_module = module;
            int numOfBreedableAnimals = 0;
            for (Animal entity : animals) {
                if (!AbstractEntityAIHerder.isBreedAble(entity)) continue;
                ++numOfBreedableAnimals;
            }
            boolean bl = hasBreedingItem = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), stack -> ItemStackUtils.compareItemStackListIgnoreStackSize(module.getBreedingItems(), stack)) > 1;
            if (ColonyConstants.rand.nextDouble() < 0.1 && !this.searchForItemsInArea().isEmpty()) {
                return AIWorkerState.HERDER_PICKUP;
            }
            if (ColonyConstants.rand.nextDouble() < this.chanceToButcher(animals)) {
                return AIWorkerState.HERDER_BUTCHER;
            }
            if (this.canBreedChildren() && numOfBreedableAnimals >= 2 && hasBreedingItem && this.breedTimeOut == 0) {
                return AIWorkerState.HERDER_BREED;
            }
            if (!(ColonyConstants.rand.nextDouble() < 0.1) || !hasBreedingItem) continue;
            return AIWorkerState.HERDER_FEED;
        }
        return AIWorkerState.START_WORKING;
    }

    protected static boolean isBreedAble(Animal entity) {
        return entity.m_146764_() == 0 && (entity.m_27593_() || entity.m_5957_());
    }

    protected boolean isFeedAble(Animal entity) {
        return entity.m_6162_() && -24000.0 / (double)entity.m_146764_() <= 1.0 + (double)this.getSecondarySkillLevel() / 100.0;
    }

    protected boolean canBreedChildren() {
        return this.building.getSetting(AbstractBuilding.BREEDING).getValue();
    }

    private IAIState startWorkingAtOwnBuilding() {
        if (this.walkToBuilding()) {
            return this.getState();
        }
        return AIWorkerState.PREPARING;
    }

    private IAIState prepareForHerding() {
        if (this.current_module == null) {
            return AIWorkerState.DECIDE;
        }
        for (ToolType tool : this.getExtraToolsNeeded()) {
            if (!this.checkForToolOrWeapon(tool)) continue;
            return this.getState();
        }
        for (ItemStack breedingItem : this.current_module.getBreedingItems()) {
            this.checkIfRequestForItemExistOrCreateAsync(breedingItem, breedingItem.m_41613_() * 8, breedingItem.m_41613_());
        }
        for (ItemStack item : this.getExtraItemsNeeded()) {
            this.checkIfRequestForItemExistOrCreateAsync(item);
        }
        return AIWorkerState.DECIDE;
    }

    protected IAIState butcherAnimals() {
        if (this.current_module == null) {
            return AIWorkerState.DECIDE;
        }
        List<Animal> animals = this.searchForAnimals(this.current_module::isCompatible);
        if (!this.equipTool(InteractionHand.MAIN_HAND, ToolType.AXE)) {
            return AIWorkerState.START_WORKING;
        }
        if (animals.isEmpty()) {
            return AIWorkerState.DECIDE;
        }
        BlockPos center = this.getCenterOfHerd(animals);
        animals.sort(Comparator.comparingDouble(an -> an.m_20183_().m_123331_((Vec3i)center)).reversed());
        Animal toKill = null;
        for (Animal entity : animals) {
            if (entity.m_6162_() || entity.m_27593_() || toKill != null && (entity.f_19853_.m_45527_(entity.m_20183_()) || !toKill.f_19853_.m_45527_(toKill.m_20183_()))) continue;
            toKill = entity;
        }
        if (toKill == null) {
            return AIWorkerState.DECIDE;
        }
        this.butcherAnimal(toKill);
        if (!toKill.m_6084_()) {
            this.worker.getCitizenExperienceHandler().addExperience(0.5);
            this.incrementActionsDoneAndDecSaturation();
            this.fedRecently.remove(toKill.m_20148_());
            return AIWorkerState.DECIDE;
        }
        return AIWorkerState.HERDER_BUTCHER;
    }

    private BlockPos getCenterOfHerd(List<? extends Animal> animals) {
        if (animals.isEmpty()) {
            return BlockPos.f_121853_;
        }
        Vec3 avg = new Vec3(0.0, 0.0, 0.0);
        for (Animal animal : animals) {
            avg = avg.m_82549_(animal.m_20182_());
        }
        return BlockPos.m_274446_((Position)avg.m_82542_(1.0 / (double)animals.size(), 1.0 / (double)animals.size(), 1.0 / (double)animals.size()));
    }

    protected IAIState breedAnimals() {
        if (this.current_module == null) {
            this.worker.getCitizenItemHandler().removeHeldItem();
            return AIWorkerState.DECIDE;
        }
        if (this.breedTwoAnimals()) {
            return this.getState();
        }
        Predicate<Animal> predicate = ((Predicate<Animal>)this.current_module::isCompatible).and(AbstractEntityAIHerder::isBreedAble);
        List<Animal> breedables = this.searchForAnimals(predicate);
        if (breedables.size() < 2) {
            this.worker.getCitizenItemHandler().removeHeldItem();
            this.breedTimeOut = 1200;
            return AIWorkerState.DECIDE;
        }
        BlockPos center = this.getCenterOfHerd(breedables);
        breedables.sort(Comparator.comparingDouble(an -> an.m_20183_().m_123331_((Vec3i)center)));
        Animal animalOne = breedables.remove(0);
        Animal animalTwo = null;
        for (Animal animal : breedables) {
            if (!(animal.m_20270_((Entity)animalOne) <= 10.0f) || !AbstractEntityAIHerder.canMate(animalOne, animal)) continue;
            animalTwo = animal;
            break;
        }
        if (animalTwo == null) {
            this.worker.getCitizenItemHandler().removeHeldItem();
            this.breedTimeOut = 400;
            return AIWorkerState.DECIDE;
        }
        if (!this.equipItem(InteractionHand.MAIN_HAND, this.current_module.getBreedingItems())) {
            this.worker.getCitizenItemHandler().removeHeldItem();
            return AIWorkerState.START_WORKING;
        }
        this.animalsToBreed.add(animalOne);
        this.animalsToBreed.add(animalTwo);
        if (this.breedTwoAnimals()) {
            return this.getState();
        }
        this.breedTimeOut = 1200;
        this.worker.getCitizenItemHandler().removeHeldItem();
        return AIWorkerState.IDLE;
    }

    private static boolean canMate(Animal first, Animal second) {
        if (!AbstractEntityAIHerder.isBreedAble(first) || !AbstractEntityAIHerder.isBreedAble(second)) {
            return false;
        }
        int oldloveFirst = first.m_27591_();
        int oldloveSecond = second.m_27591_();
        first.m_27601_(5);
        second.m_27601_(5);
        boolean result = first.m_7848_(second);
        first.m_27601_(oldloveFirst);
        second.m_27601_(oldloveSecond);
        return result;
    }

    protected IAIState feedAnimal() {
        if (this.current_module == null) {
            return AIWorkerState.DECIDE;
        }
        if (!this.equipItem(InteractionHand.MAIN_HAND, this.current_module.getBreedingItems())) {
            return AIWorkerState.START_WORKING;
        }
        List<Animal> animals = this.searchForAnimals(this.current_module::isCompatible);
        Animal toFeed = null;
        for (Animal animal : animals) {
            if (this.worker.f_19853_.m_46467_() - this.fedRecently.getOrDefault(animal.m_20148_(), 0L) <= 6000L) continue;
            toFeed = animal;
            break;
        }
        if (toFeed == null) {
            return AIWorkerState.DECIDE;
        }
        if (!this.walkingToAnimal(toFeed)) {
            if (toFeed.m_6162_() && this.getSecondarySkillLevel() >= 10) {
                toFeed.m_146740_((int)((float)(-toFeed.m_146764_() / 20) * 0.1f), true);
            }
            this.worker.m_6674_(InteractionHand.MAIN_HAND);
            this.worker.m_21205_().m_41774_(1);
            this.building.getModule(BuildingModules.STATS_MODULE).increment("item_used;" + this.worker.m_21205_().m_41720_().m_5524_());
            this.worker.getCitizenExperienceHandler().addExperience(0.5);
            this.worker.f_19853_.m_7605_((Entity)toFeed, (byte)18);
            toFeed.m_5496_(SoundEvents.f_11912_, 1.0f, 1.0f);
            this.worker.getCitizenItemHandler().removeHeldItem();
            this.fedRecently.put(toFeed.m_20148_(), this.worker.f_19853_.m_46467_());
            return AIWorkerState.DECIDE;
        }
        this.worker.decreaseSaturationForContinuousAction();
        return this.getState();
    }

    private IAIState pickupItems() {
        List<ItemEntity> items = this.searchForItemsInArea();
        if (!items.isEmpty() && this.walkToBlock(items.get(0).m_20183_(), 1)) {
            return this.getState();
        }
        this.incrementActionsDoneAndDecSaturation();
        return AIWorkerState.DECIDE;
    }

    public List<? extends Animal> searchForAnimals(Predicate<Animal> predicate) {
        return WorldUtil.getEntitiesWithinBuilding(this.world, Animal.class, this.building, predicate);
    }

    public int getMaxAnimalMultiplier() {
        return 2;
    }

    public List<? extends ItemEntity> searchForItemsInArea() {
        return WorldUtil.getEntitiesWithinBuilding(this.world, ItemEntity.class, this.building, null);
    }

    public boolean walkingToAnimal(Animal animal) {
        if (animal != null) {
            return this.walkToBlock(animal.m_20183_());
        }
        return false;
    }

    private boolean breedTwoAnimals() {
        Iterator<Animal> it = this.animalsToBreed.iterator();
        while (it.hasNext()) {
            Animal animal = it.next();
            if (animal.m_27593_() || animal.m_21224_()) {
                it.remove();
                continue;
            }
            if (this.walkingToAnimal(animal)) break;
            animal.m_27595_(null);
            this.worker.m_6674_(InteractionHand.MAIN_HAND);
            this.building.getModule(BuildingModules.STATS_MODULE).increment("item_used;" + this.worker.m_21205_().m_41720_().m_5524_());
            this.worker.m_21205_().m_41774_(1);
            this.worker.getCitizenExperienceHandler().addExperience(0.5);
            this.worker.decreaseSaturationForAction();
            it.remove();
        }
        return !this.animalsToBreed.isEmpty();
    }

    public double chanceToButcher(List<? extends Animal> allAnimals) {
        int maxAnimals = this.building.getBuildingLevel() * this.getMaxAnimalMultiplier();
        if (!this.building.getSetting(AbstractBuilding.BREEDING).getValue().booleanValue() && allAnimals.size() <= maxAnimals) {
            return 0.0;
        }
        int grownUp = 0;
        for (Animal animal : allAnimals) {
            if (animal.m_6162_()) continue;
            ++grownUp;
        }
        if (grownUp <= 3) {
            return 0.0;
        }
        return 0.5 * (Math.pow(grownUp, 4.0) / Math.pow(maxAnimals, 4.0));
    }

    public boolean equipTool(InteractionHand hand, ToolType toolType) {
        if (this.getToolSlot(toolType) != -1) {
            this.worker.getCitizenItemHandler().setHeldItem(hand, this.getToolSlot(toolType));
            return true;
        }
        return false;
    }

    private int getToolSlot(ToolType toolType) {
        int slot = InventoryUtils.getFirstSlotOfItemHandlerContainingTool((IItemHandler)this.getInventory(), toolType, 0, this.building.getMaxToolLevel());
        if (slot == -1) {
            this.checkForToolOrWeapon(toolType);
        }
        return slot;
    }

    public boolean equipItem(InteractionHand hand, List<ItemStack> itemStacks) {
        for (ItemStack itemStack : itemStacks) {
            if (!this.checkIfRequestForItemExistOrCreateAsync(itemStack)) continue;
            this.worker.getCitizenItemHandler().setHeldItem(hand, this.getItemSlot(itemStack.m_41720_()));
            return true;
        }
        return false;
    }

    public int getItemSlot(Item item) {
        return InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.getInventory(), item);
    }

    protected void butcherAnimal(@Nullable Animal animal) {
        if (animal != null && !this.walkingToAnimal(animal) && !ItemStackUtils.isEmpty(this.worker.m_21205_())) {
            this.worker.m_6674_(InteractionHand.MAIN_HAND);
            DamageSource ds = animal.f_19853_.m_269111_().m_269075_((Player)this.getFakePlayer());
            animal.m_6469_(ds, (float)this.getButcheringAttackDamage());
            this.worker.getCitizenItemHandler().damageItemInHand(InteractionHand.MAIN_HAND, 1);
        }
    }

    public double getButcheringAttackDamage() {
        return 5.0;
    }

    public List<ItemStack> getRequestBreedingItems(AnimalHerdingModule module) {
        ArrayList<ItemStack> breedingItems = new ArrayList<ItemStack>();
        for (ItemStack stack : module.getBreedingItems()) {
            ItemStack requestable = stack.m_41777_();
            ItemStackUtils.setSize(requestable, stack.m_41613_() * 8);
            breedingItems.add(requestable);
        }
        return breedingItems;
    }
}

