/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.production;

import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.placement.AbstractBlueprintIterator;
import com.ldtteam.structurize.placement.BlockPlacementResult;
import com.ldtteam.structurize.placement.StructurePhasePlacementResult;
import com.ldtteam.structurize.placement.StructurePlacer;
import com.ldtteam.structurize.storage.ServerFutureProcessor;
import com.ldtteam.structurize.util.BlockUtils;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.workorders.IWorkOrder;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.ai.workers.util.IBuilderUndestroyable;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.entity.pathfinding.SurfaceType;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.colony.buildings.AbstractBuildingStructureBuilder;
import com.minecolonies.core.colony.buildings.modules.BuildingModules;
import com.minecolonies.core.colony.buildings.modules.QuarryModule;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingMiner;
import com.minecolonies.core.colony.interactionhandling.StandardInteraction;
import com.minecolonies.core.colony.jobs.JobQuarrier;
import com.minecolonies.core.colony.workorders.WorkOrderMiner;
import com.minecolonies.core.entity.ai.workers.AbstractEntityAIStructure;
import com.minecolonies.core.entity.ai.workers.AbstractEntityAIStructureWithWorkOrder;
import com.minecolonies.core.entity.ai.workers.util.BuildingStructureHandler;
import com.minecolonies.core.entity.ai.workers.util.WorkerLoadOnlyStructureHandler;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Future;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EntityAIQuarrier
extends AbstractEntityAIStructureWithWorkOrder<JobQuarrier, BuildingMiner> {
    private static final String RENDER_META_TORCH = "torch";
    private static final String RENDER_META_STONE = "stone";
    private static final int MAX_BLOCKS_MINED = 128;

    public EntityAIQuarrier(@NotNull JobQuarrier job) {
        super(job);
        super.registerTargets(new AITarget<AIWorkerState>(AIWorkerState.IDLE, AIWorkerState.START_WORKING, 1), new AITarget<Object>(AIWorkerState.START_WORKING, this::startWorkingAtOwnBuilding, 20), new AITarget<Object>(AIWorkerState.BUILDING_STEP, this::structureStep, 5));
        this.worker.m_21553_(true);
    }

    @Override
    public Class<BuildingMiner> getExpectedBuildingClass() {
        return BuildingMiner.class;
    }

    @NotNull
    private IAIState startWorkingAtOwnBuilding() {
        this.worker.getCitizenData().setVisibleStatus(VisibleCitizenStatus.WORKING);
        IBuilding quarry = ((JobQuarrier)this.job).findQuarry();
        if (quarry == null) {
            this.walkToBuilding();
            this.worker.getCitizenData().triggerInteraction(new StandardInteraction((Component)Component.m_237115_((String)"com.minecolonies.coremod.quarrier.noquarry"), ChatPriority.BLOCKING));
            return AIWorkerState.IDLE;
        }
        if (((QuarryModule)quarry.getFirstModuleOccurance(QuarryModule.class)).isFinished()) {
            this.walkToBuilding();
            this.worker.getCitizenData().triggerInteraction(new StandardInteraction((Component)Component.m_237115_((String)"com.minecolonies.coremod.quarrier.finishedquarry"), ChatPriority.BLOCKING));
            return AIWorkerState.IDLE;
        }
        if (this.walkToBlock(quarry.getPosition())) {
            return this.getState();
        }
        return AIWorkerState.LOAD_STRUCTURE;
    }

    @Override
    public IAIState loadRequirements() {
        if (((JobQuarrier)this.job).getWorkOrder() == null) {
            IBuilding quarry = ((JobQuarrier)this.job).findQuarry();
            if (quarry == null || ((QuarryModule)quarry.getFirstModuleOccurance(QuarryModule.class)).isFinished()) {
                return AIWorkerState.IDLE;
            }
            Tuple<String, String> shaft = this.getShaftPath(quarry);
            WorkOrderMiner wo = new WorkOrderMiner(quarry.getStructurePack(), shaft.getA(), shaft.getB(), quarry.getRotation(), quarry.getPosition().m_6625_(2), false, ((BuildingMiner)this.building).getPosition());
            wo.setClaimedBy(((BuildingMiner)this.building).getPosition());
            ((BuildingMiner)this.building).getColony().getWorkManager().addWorkOrder(wo, false);
            ((JobQuarrier)this.job).setWorkOrder(wo);
        }
        return super.loadRequirements();
    }

    private Tuple<String, String> getShaftPath(@NotNull IBuilding quarry) {
        Object path = "infrastructure/mineshafts/" + quarry.getSchematicName() + "shaft1.blueprint";
        AbstractTileEntityColonyBuilding tileEntity = quarry.getTileEntity();
        if (tileEntity != null) {
            String tag;
            Iterator iterator;
            path = quarry.getBlueprintPath().replace('\\', '/').replace("1.blueprint", "shaft1.blueprint");
            if (!((String)path).endsWith("shaft1.blueprint")) {
                path = ((String)path).replace(".blueprint", "shaft.blueprint");
            }
            if ((iterator = tileEntity.getPositionedTags().getOrDefault(BlockPos.f_121853_, Collections.emptyList()).iterator()).hasNext() && (tag = (String)iterator.next()).startsWith("shaft=")) {
                path = tag.contains("/") ? tag.substring(6) : ((String)path).substring(0, ((String)path).lastIndexOf(47) + 1) + tag.substring(6);
            }
            if (!((String)path).endsWith(".blueprint")) {
                path = (String)path + ".blueprint";
            }
        }
        String name = ((String)path).substring(((String)path).lastIndexOf(47) + 1).replace(".blueprint", "");
        return new Tuple<Object, String>(path, name);
    }

    @Override
    public void onBlockDropReception(List<ItemStack> blockDrops) {
        super.onBlockDropReception(blockDrops);
        for (ItemStack stack : blockDrops) {
            ((BuildingMiner)this.building).getModule(BuildingModules.STATS_MODULE).incrementBy("item_obtained;" + stack.m_41720_().m_5524_(), stack.m_41613_());
        }
    }

    @Override
    public void loadStructure(@NotNull IWorkOrder workOrder, int rotateTimes, BlockPos position, boolean isMirrored, boolean removal) {
        Future<Blueprint> blueprintFuture = workOrder.getBlueprintFuture();
        this.loadingBlueprint = true;
        ServerFutureProcessor.queueBlueprint((ServerFutureProcessor.BlueprintProcessingData)new ServerFutureProcessor.BlueprintProcessingData(blueprintFuture, this.world, blueprint -> {
            if (blueprint == null) {
                this.handleSpecificCancelActions();
                Log.getLogger().warn("Couldn't find structure with name: " + workOrder.getStructurePath() + " in: " + workOrder.getStructurePack() + ". Aborting loading procedure");
                this.loadingBlueprint = false;
                return;
            }
            BuildingStructureHandler<JobQuarrier, BuildingMiner> structure = new BuildingStructureHandler<JobQuarrier, BuildingMiner>(this.world, position, (Blueprint)blueprint, new PlacementSettings(isMirrored ? Mirror.FRONT_BACK : Mirror.NONE, BlockPosUtil.getRotationFromRotations(rotateTimes)), (AbstractEntityAIStructure<JobQuarrier, BuildingMiner>)this, new BuildingStructureHandler.Stage[]{BuildingStructureHandler.Stage.BUILD_SOLID, BuildingStructureHandler.Stage.DECORATE, BuildingStructureHandler.Stage.CLEAR});
            ((BuildingMiner)this.building).setTotalStages(3);
            if (!structure.hasBluePrint()) {
                this.handleSpecificCancelActions();
                Log.getLogger().warn("Couldn't find structure with name: " + workOrder.getStructurePath() + " aborting loading procedure");
                this.loadingBlueprint = false;
                return;
            }
            ((JobQuarrier)this.job).setBlueprint(structure.getBluePrint());
            ((JobQuarrier)this.job).getBlueprint().rotateWithMirror(BlockPosUtil.getRotationFromRotations(rotateTimes), isMirrored ? Mirror.FRONT_BACK : Mirror.NONE, this.world);
            this.setStructurePlacer(structure);
            if (this.getProgressPos() != null) {
                structure.setStage(this.getProgressPos().getB());
            }
            this.loadingBlueprint = false;
        }));
    }

    @Override
    protected IBuilding getBuildingToDump() {
        IBuilding quarry = ((JobQuarrier)this.job).findQuarry();
        return quarry == null ? super.getBuildingToDump() : quarry;
    }

    @Override
    protected IAIState structureStep() {
        StructurePhasePlacementResult result;
        if (((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getStage() == null) {
            return AIWorkerState.PICK_UP_RESIDUALS;
        }
        if (InventoryUtils.isItemHandlerFull((IItemHandler)this.worker.getInventoryCitizen())) {
            return AIWorkerState.INVENTORY_FULL;
        }
        this.checkForExtraBuildingActions();
        BlockPos progress = this.getProgressPos() == null ? AbstractBlueprintIterator.NULL_POS : this.getProgressPos().getA();
        BlockPos worldPos = ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getProgressPosInWorld(progress);
        if (this.getProgressPos() != null) {
            ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).setStage(this.getProgressPos().getB());
        }
        if (!progress.equals((Object)AbstractBlueprintIterator.NULL_POS) && !this.limitReached && (this.blockToMine == null ? !this.walkToConstructionSite(worldPos) : !this.walkToConstructionSite(this.blockToMine))) {
            return this.getState();
        }
        this.limitReached = false;
        StructurePlacer placer = (StructurePlacer)this.structurePlacer.getA();
        switch (((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getStage()) {
            case BUILD_SOLID: {
                result = placer.executeStructureStep(this.world, null, progress, StructurePlacer.Operation.BLOCK_PLACEMENT, () -> placer.getIterator().decrement(this.DONT_TOUCH_PREDICATE.or((info, pos, handler) -> !BlockUtils.isAnySolid((BlockState)info.getBlockInfo().getState()) || EntityAIQuarrier.isDecoItem(info.getBlockInfo().getState().m_60734_()) || pos.m_123342_() < worldPos.m_123342_())), false);
                if (progress.m_123342_() != -1 && result.getIteratorPos().m_123342_() < progress.m_123342_()) {
                    ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).nextStage();
                    this.storeProgressPos(new BlockPos(0, progress.m_123342_() + 1, 0), ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getStage());
                    break;
                }
                this.storeProgressPos(result.getIteratorPos(), ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getStage());
                break;
            }
            case DECORATE: {
                if (progress.m_123342_() >= ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getBluePrint().getSizeY()) {
                    ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).nextStage();
                    this.storeProgressPos(new BlockPos((int)((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getBluePrint().getSizeX(), progress.m_123342_() - 1, ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getBluePrint().getSizeZ() - 1), ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getStage());
                    return this.getState();
                }
                result = placer.executeStructureStep(this.world, null, progress, StructurePlacer.Operation.BLOCK_PLACEMENT, () -> placer.getIterator().increment(this.DONT_TOUCH_PREDICATE.or((info, pos, handler) -> BlockUtils.isAnySolid((BlockState)info.getBlockInfo().getState()) && !EntityAIQuarrier.isDecoItem(info.getBlockInfo().getState().m_60734_()) || pos.m_123342_() > worldPos.m_123342_())), false);
                if (result.getBlockResult().getResult() == BlockPlacementResult.Result.FINISHED) {
                    ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).nextStage();
                    this.storeProgressPos(new BlockPos((int)((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getBluePrint().getSizeX(), progress.m_123342_() - 1, ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getBluePrint().getSizeZ() - 1), ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getStage());
                    break;
                }
                if (progress.m_123342_() != -1 && result.getIteratorPos().m_123342_() > progress.m_123342_()) {
                    ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).nextStage();
                    this.storeProgressPos(new BlockPos((int)((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getBluePrint().getSizeX(), progress.m_123342_() - 1, ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getBluePrint().getSizeZ() - 1), ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getStage());
                    break;
                }
                this.storeProgressPos(result.getIteratorPos(), ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getStage());
                break;
            }
            default: {
                result = placer.executeStructureStep(this.world, null, progress, StructurePlacer.Operation.BLOCK_REMOVAL, () -> placer.getIterator().decrement((info, pos, handler) -> handler.getWorld().m_8055_(pos).m_60734_() instanceof IBuilderUndestroyable || handler.getWorld().m_8055_(pos).m_60734_() == Blocks.f_50752_ || handler.getWorld().m_8055_(pos).m_60734_() instanceof AirBlock || info.getBlockInfo().getState().m_60734_() == ModBlocks.blockFluidSubstitution.get() || !handler.getWorld().m_8055_(pos).m_60819_().m_76178_()), false);
                if (result.getBlockResult().getResult() == BlockPlacementResult.Result.FINISHED) {
                    ((BuildingMiner)this.building).nextStage();
                    ((BuildingMiner)this.building).setProgressPos(null, null);
                    this.worker.getCitizenData().setStatusPosition(null);
                    return AIWorkerState.COMPLETE_BUILD;
                }
                if (progress.m_123342_() != -1 && (result.getIteratorPos().m_123342_() < progress.m_123342_() || result.getBlockResult().getWorldPos().m_123342_() < worldPos.m_123342_())) {
                    ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).setStage(BuildingStructureHandler.Stage.BUILD_SOLID);
                    this.storeProgressPos(new BlockPos((int)((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getBluePrint().getSizeX(), progress.m_123342_() - 1, ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getBluePrint().getSizeZ() - 1), ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getStage());
                    break;
                }
                this.storeProgressPos(result.getIteratorPos(), ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getStage());
            }
        }
        if (result.getBlockResult().getResult() == BlockPlacementResult.Result.LIMIT_REACHED) {
            this.limitReached = true;
        }
        if (result.getBlockResult().getResult() == BlockPlacementResult.Result.MISSING_ITEMS) {
            if (EntityAIQuarrier.hasListOfResInInvOrRequest(this, result.getBlockResult().getRequiredItems(), result.getBlockResult().getRequiredItems().size() > 1) == AbstractEntityAIStructure.ItemCheckResult.RECALC) {
                ((JobQuarrier)this.job).getWorkOrder().setRequested(false);
                return AIWorkerState.LOAD_STRUCTURE;
            }
            return AIWorkerState.NEEDS_ITEM;
        }
        if (result.getBlockResult().getResult() == BlockPlacementResult.Result.BREAK_BLOCK) {
            BlockPos currentWorldPos = result.getBlockResult().getWorldPos();
            if (currentWorldPos.m_123342_() < this.worker.f_19853_.m_141937_() + 5) {
                ((BuildingMiner)this.building).setProgressPos(null, null);
                this.worker.getCitizenData().setStatusPosition(null);
                return AIWorkerState.COMPLETE_BUILD;
            }
            this.blockToMine = currentWorldPos;
            this.worker.getCitizenData().setStatusPosition(this.blockToMine);
            return AIWorkerState.MINE_BLOCK;
        }
        double decrease = 1.0 - this.worker.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.BLOCK_PLACE_SPEED);
        this.setDelay((int)((double)(150 / (this.getPlaceSpeedLevel() / 2 + 10)) * decrease));
        return this.getState();
    }

    @Override
    public boolean requestMaterials() {
        WorkerLoadOnlyStructureHandler<JobQuarrier, BuildingMiner> structure = new WorkerLoadOnlyStructureHandler<JobQuarrier, BuildingMiner>(this.world, ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getWorldPos(), ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getBluePrint(), new PlacementSettings(), true, this);
        ((JobQuarrier)this.job).getWorkOrder().setIteratorType("default");
        StructurePlacer placer = new StructurePlacer(structure, ((JobQuarrier)this.job).getWorkOrder().getIteratorType());
        if (this.requestProgress == null) {
            AbstractBuildingStructureBuilder buildingWorker = (AbstractBuildingStructureBuilder)this.building;
            buildingWorker.resetNeededResources();
            this.requestProgress = new BlockPos((int)((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getBluePrint().getSizeX(), ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getBluePrint().getSizeY() - 1, ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getBluePrint().getSizeZ() - 1);
            this.requestState = AbstractEntityAIStructureWithWorkOrder.RequestStage.SOLID;
        }
        BlockPos worldPos = structure.getProgressPosInWorld(this.requestProgress);
        AbstractEntityAIStructureWithWorkOrder.RequestStage currState = this.requestState;
        switch (currState) {
            case SOLID: {
                StructurePhasePlacementResult result = placer.executeStructureStep(this.world, null, this.requestProgress, StructurePlacer.Operation.GET_RES_REQUIREMENTS, () -> placer.getIterator().decrement(this.DONT_TOUCH_PREDICATE.or((info, pos, handler) -> !BlockUtils.isAnySolid((BlockState)info.getBlockInfo().getState()) || EntityAIQuarrier.isDecoItem(info.getBlockInfo().getState().m_60734_()) || pos.m_123342_() < worldPos.m_123342_())), false);
                for (ItemStack stack : result.getBlockResult().getRequiredItems()) {
                    ((BuildingMiner)this.building).addNeededResource(stack, stack.m_41613_());
                }
                if (this.requestProgress.m_123342_() != -1 && result.getIteratorPos().m_123342_() < this.requestProgress.m_123342_()) {
                    this.requestProgress = new BlockPos(0, this.requestProgress.m_123342_() + 1, 0);
                    this.requestState = AbstractEntityAIStructureWithWorkOrder.RequestStage.DECO;
                } else if (result.getBlockResult().getResult() == BlockPlacementResult.Result.FINISHED) {
                    this.requestProgress = new BlockPos(0, ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getBluePrint().getSizeY() - 2, 0);
                    this.requestState = AbstractEntityAIStructureWithWorkOrder.RequestStage.DECO;
                } else {
                    this.requestProgress = result.getIteratorPos();
                }
                return false;
            }
            case DECO: {
                if (this.requestProgress.m_123342_() >= ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getBluePrint().getSizeY()) {
                    this.requestState = AbstractEntityAIStructureWithWorkOrder.RequestStage.ENTITIES;
                    this.requestProgress = new BlockPos((int)((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getBluePrint().getSizeX(), this.requestProgress.m_123342_() - 1, ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getBluePrint().getSizeZ() - 1);
                    return false;
                }
                StructurePhasePlacementResult result = placer.executeStructureStep(this.world, null, this.requestProgress, StructurePlacer.Operation.GET_RES_REQUIREMENTS, () -> placer.getIterator().increment(this.DONT_TOUCH_PREDICATE.or((info, pos, handler) -> BlockUtils.isAnySolid((BlockState)info.getBlockInfo().getState()) && !EntityAIQuarrier.isDecoItem(info.getBlockInfo().getState().m_60734_()) || pos.m_123342_() > worldPos.m_123342_())), false);
                for (ItemStack stack : result.getBlockResult().getRequiredItems()) {
                    ((BuildingMiner)this.building).addNeededResource(stack, stack.m_41613_());
                }
                if (result.getBlockResult().getResult() == BlockPlacementResult.Result.FINISHED) {
                    this.requestState = AbstractEntityAIStructureWithWorkOrder.RequestStage.ENTITIES;
                    this.requestProgress = new BlockPos((int)((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getBluePrint().getSizeX(), this.requestProgress.m_123342_() - 1, ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getBluePrint().getSizeZ() - 1);
                } else if (this.requestProgress.m_123342_() != -1 && result.getIteratorPos().m_123342_() > this.requestProgress.m_123342_()) {
                    this.requestState = AbstractEntityAIStructureWithWorkOrder.RequestStage.ENTITIES;
                    this.requestProgress = new BlockPos((int)((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getBluePrint().getSizeX(), this.requestProgress.m_123342_() - 1, ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getBluePrint().getSizeZ() - 1);
                } else {
                    this.requestProgress = result.getIteratorPos();
                }
                return false;
            }
            case ENTITIES: {
                StructurePhasePlacementResult result = placer.executeStructureStep(this.world, null, this.requestProgress, StructurePlacer.Operation.GET_RES_REQUIREMENTS, () -> placer.getIterator().decrement(this.DONT_TOUCH_PREDICATE.or((info, pos, handler) -> info.getEntities().length == 0 || pos.m_123342_() < worldPos.m_123342_())), true);
                if (result.getBlockResult().getResult() == BlockPlacementResult.Result.FINISHED) {
                    this.requestState = AbstractEntityAIStructureWithWorkOrder.RequestStage.SOLID;
                    this.requestProgress = null;
                    return true;
                }
                if (this.requestProgress.m_123342_() != -1 && result.getIteratorPos().m_123342_() < this.requestProgress.m_123342_()) {
                    this.requestState = AbstractEntityAIStructureWithWorkOrder.RequestStage.SOLID;
                    this.requestProgress = new BlockPos((int)((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getBluePrint().getSizeX(), this.requestProgress.m_123342_() - 1, ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getBluePrint().getSizeZ() - 1);
                } else {
                    this.requestProgress = result.getIteratorPos();
                }
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean checkIfCanceled() {
        boolean isCanceled = false;
        if (((JobQuarrier)this.job).findQuarry() == null) {
            this.worker.getCitizenData().triggerInteraction(new StandardInteraction((Component)Component.m_237115_((String)"com.minecolonies.coremod.quarrier.noquarry"), ChatPriority.BLOCKING));
            isCanceled = true;
        } else if (((QuarryModule)((JobQuarrier)this.job).findQuarry().getFirstModuleOccurance(QuarryModule.class)).isFinished()) {
            this.worker.getCitizenData().triggerInteraction(new StandardInteraction((Component)Component.m_237115_((String)"com.minecolonies.coremod.quarrier.finishedquarry"), ChatPriority.BLOCKING));
            isCanceled = true;
        } else if (((JobQuarrier)this.job).getWorkOrder() != null && !((JobQuarrier)this.job).getWorkOrder().getLocation().equals((Object)((JobQuarrier)this.job).findQuarry().getPosition().m_6625_(2))) {
            isCanceled = true;
        }
        if (isCanceled) {
            if (((JobQuarrier)this.job).hasWorkOrder()) {
                ((JobQuarrier)this.job).getColony().getWorkManager().removeWorkOrder(((JobQuarrier)this.job).getWorkOrderId());
                ((JobQuarrier)this.job).setWorkOrder(null);
            }
            this.blockToMine = null;
            ((BuildingMiner)this.building).setProgressPos(null, null);
            this.worker.getCitizenData().setStatusPosition(null);
            return true;
        }
        return super.checkIfCanceled();
    }

    @Override
    public void setStructurePlacer(BuildingStructureHandler<JobQuarrier, BuildingMiner> structure) {
        this.structurePlacer = new Tuple<StructurePlacer, BuildingStructureHandler<JobQuarrier, BuildingMiner>>(new StructurePlacer(structure, "default"), structure);
    }

    @Override
    public int getBreakSpeedLevel() {
        return this.getPrimarySkillLevel();
    }

    @Override
    public int getPlaceSpeedLevel() {
        return this.getSecondarySkillLevel();
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return ((BuildingMiner)this.building).getBuildingLevel() * 128;
    }

    @Override
    protected void updateRenderMetaData() {
        StringBuilder renderData = new StringBuilder(this.getState() == AIWorkerState.MINER_MINING_SHAFT || this.getState() == AIWorkerState.MINE_BLOCK || this.getState() == AIWorkerState.BUILDING_STEP ? "working" : "");
        ItemStack block = new ItemStack((ItemLike)this.getMainFillBlock());
        for (int slot = 0; slot < this.worker.getInventoryCitizen().getSlots(); ++slot) {
            ItemStack stack = this.worker.getInventoryCitizen().getStackInSlot(slot);
            if (stack.m_41720_() == Items.f_42000_ && renderData.indexOf(RENDER_META_TORCH) == -1) {
                renderData.append(RENDER_META_TORCH);
                continue;
            }
            if (stack.m_41720_() == block.m_41720_() && renderData.indexOf(RENDER_META_STONE) == -1) {
                renderData.append(RENDER_META_STONE);
                continue;
            }
            if (stack.canPerformAction(ToolActions.PICKAXE_DIG) && renderData.indexOf("pickaxe") == -1) {
                renderData.append("pickaxe");
                continue;
            }
            if (!stack.canPerformAction(ToolActions.SHOVEL_DIG) || renderData.indexOf("shovel") != -1) continue;
            renderData.append("shovel");
        }
        this.worker.setRenderMetadata(renderData.toString());
    }

    @Override
    public IAIState doMining() {
        if (this.blockToMine == null) {
            return AIWorkerState.BUILDING_STEP;
        }
        for (Direction direction : Direction.values()) {
            BlockPos pos = this.blockToMine.m_121945_(direction);
            BlockState surroundingState = this.world.m_8055_(pos);
            FluidState fluid = this.world.m_6425_(pos);
            if (surroundingState.m_60734_() != Blocks.f_49991_ && (fluid == null || fluid.m_76178_() || fluid.m_76152_() != Fluids.f_76195_ && fluid.m_76152_() != Fluids.f_76194_) && !SurfaceType.isWater((BlockGetter)this.world, pos, surroundingState, fluid)) continue;
            this.setBlockFromInventory(pos, this.getMainFillBlock());
        }
        if (this.world.m_8055_(this.blockToMine).m_60734_() instanceof AirBlock) {
            this.blockToMine = null;
            return AIWorkerState.BUILDING_STEP;
        }
        if (!this.mineBlock(this.blockToMine, this.getCurrentWorkingPosition())) {
            this.worker.m_6674_(InteractionHand.MAIN_HAND);
            return this.getState();
        }
        this.worker.decreaseSaturationForContinuousAction();
        this.blockToMine = null;
        return AIWorkerState.BUILDING_STEP;
    }

    private Block getMainFillBlock() {
        return ((BuildingMiner)this.building).getSetting(BuildingMiner.FILL_BLOCK).getValue().m_40614_();
    }

    @Override
    public ItemStack getTotalAmount(ItemStack stack) {
        if (ItemStackUtils.isEmpty(stack)) {
            return null;
        }
        ItemStack copy = stack.m_41777_();
        copy.m_41764_(Math.max(super.getTotalAmount(stack).m_41613_(), copy.m_41741_() / 2));
        return copy;
    }

    @Override
    public IAIState afterStructureLoading() {
        return AIWorkerState.BUILDING_STEP;
    }

    private void setBlockFromInventory(@NotNull BlockPos location, Block block) {
        this.worker.m_6674_(this.worker.m_7655_());
        int slot = this.worker.getCitizenInventoryHandler().findFirstSlotInInventoryWith(block);
        if (slot != -1) {
            this.getInventory().extractItem(slot, 1, false);
            WorldUtil.setBlockState((LevelAccessor)this.world, location, block.m_49966_());
        }
    }

    @Override
    public void executeSpecificCompleteActions() {
        super.executeSpecificCompleteActions();
        IBuilding quarry = ((JobQuarrier)this.job).findQuarry();
        if (quarry != null) {
            ((QuarryModule)quarry.getFirstModuleOccurance(QuarryModule.class)).setFinished();
        }
    }

    @Override
    public boolean shallReplaceSolidSubstitutionBlock(Block worldBlock, BlockState worldMetadata) {
        return IColonyManager.getInstance().getCompatibilityManager().isOre(worldMetadata);
    }

    @Override
    public boolean walkToConstructionSite(BlockPos currentBlock) {
        if (this.workFrom == null) {
            this.workFrom = this.findRandomPositionToWalkTo(5, currentBlock);
            if (this.workFrom == null && this.pathBackupFactor > 10) {
                this.workFrom = this.worker.m_20183_();
            }
            return false;
        }
        if (BlockPosUtil.getDistance(this.worker.m_20183_(), currentBlock) <= (double)(5 + 5 * this.pathBackupFactor)) {
            return true;
        }
        if (this.walkToBlock(this.workFrom)) {
            return false;
        }
        if (BlockPosUtil.getDistance(this.worker.m_20183_(), currentBlock) > (double)(5 + 5 * this.pathBackupFactor)) {
            this.workFrom = null;
            return false;
        }
        if (this.pathBackupFactor > 1) {
            --this.pathBackupFactor;
        }
        return true;
    }

    @Override
    public BlockState getSolidSubstitution(BlockPos ignored) {
        return this.getMainFillBlock().m_49966_();
    }

    @Override
    protected void triggerMinedBlock(@NotNull BlockState blockToMine) {
        super.triggerMinedBlock(blockToMine);
        if (IColonyManager.getInstance().getCompatibilityManager().isOre(blockToMine)) {
            ((BuildingMiner)this.building).getColony().getStatisticsManager().increment("ores_mined", ((BuildingMiner)this.building).getColony().getDay());
        }
        ((BuildingMiner)this.building).getColony().getStatisticsManager().increment("blocks_mined", ((BuildingMiner)this.building).getColony().getDay());
    }
}

