/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.guard;

import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.core.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.core.colony.jobs.JobDruid;
import com.minecolonies.core.entity.ai.workers.guard.AbstractEntityAIGuard;
import com.minecolonies.core.entity.ai.workers.guard.DruidCombatAI;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import com.minecolonies.core.entity.pathfinding.MinecoloniesAdvancedPathNavigate;
import com.minecolonies.core.entity.pathfinding.pathjobs.PathJobWalkRandomEdge;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EntityAIDruid
extends AbstractEntityAIGuard<JobDruid, AbstractBuildingGuards> {
    public static final String RENDER_META_POTION = "potion";

    public EntityAIDruid(@NotNull JobDruid job) {
        super(job);
        new DruidCombatAI((EntityCitizen)this.worker, this.getStateAI(), this);
    }

    @Override
    protected void updateRenderMetaData() {
        Object renderMeta;
        Object object = renderMeta = this.getState() == AIWorkerState.IDLE ? "" : "working";
        if (this.worker.getCitizenInventoryHandler().hasItemInInventory(Items.f_42589_)) {
            renderMeta = (String)renderMeta + RENDER_META_POTION;
        }
        this.worker.setRenderMetadata((String)renderMeta);
    }

    @Override
    protected void atBuildingActions() {
        super.atBuildingActions();
        if (this.worker.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.DRUID_USE_POTIONS) > 0.0) {
            InventoryUtils.transferXOfFirstSlotInProviderWithIntoNextFreeSlotInItemHandler(this.building, item -> item.m_41720_() == ModItems.magicpotion, 32, (IItemHandler)this.worker.getInventoryCitizen());
            if (InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), item -> item.m_41720_() == ModItems.magicpotion) < 8) {
                this.checkIfRequestForItemExistOrCreateAsync(new ItemStack((ItemLike)ModItems.magicpotion), 16, 8);
            }
        }
    }

    @Override
    public void guardMovement() {
        if (this.worker.m_217043_().m_188503_(3) < 1) {
            this.worker.isWorkerAtSiteWithMove(this.buildingGuards.getGuardPos(), 3);
            return;
        }
        if (this.worker.isWorkerAtSiteWithMove(this.buildingGuards.getGuardPos(), 10) || Math.abs(this.buildingGuards.getGuardPos().m_123342_() - this.worker.m_20183_().m_123342_()) > 3) {
            ((MinecoloniesAdvancedPathNavigate)this.worker.getNavigation()).setPathJob(new PathJobWalkRandomEdge(this.world, this.buildingGuards.getGuardPos(), 20, (LivingEntity)this.worker), null, 1.0, true);
        }
    }
}

