/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.guard;

import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.ai.workers.util.GuardGear;
import com.minecolonies.api.entity.ai.workers.util.GuardGearBuilder;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.InventoryFunctions;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.GuardConstants;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.core.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.core.colony.jobs.AbstractJobGuard;
import com.minecolonies.core.entity.ai.workers.AbstractEntityAIInteract;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEntityAIFight<J extends AbstractJobGuard<J>, B extends AbstractBuildingGuards>
extends AbstractEntityAIInteract<J, B> {
    public final List<ToolType> toolsNeeded = new ArrayList<ToolType>();
    public final List<List<GuardGear>> itemsNeeded = new ArrayList<List<GuardGear>>();
    protected LivingEntity target = null;
    private static final double COMBAT_SPEED = 1.0;
    public static final double SPEED_LEVEL_BONUS = 0.01;

    public AbstractEntityAIFight(@NotNull J job) {
        super(job);
        super.registerTargets(new AITarget<AIWorkerState>(AIWorkerState.IDLE, AIWorkerState.START_WORKING, 1), new AITarget<Object>(AIWorkerState.START_WORKING, this::startWorkingAtOwnBuilding, 100), new AITarget<Object>(AIWorkerState.PREPARING, this::prepare, 20));
        this.worker.m_21553_(true);
        this.itemsNeeded.add(GuardGearBuilder.buildGearForLevel(0, 1, GuardConstants.LEATHER_BUILDING_LEVEL_RANGE, GuardConstants.GOLD_BUILDING_LEVEL_RANGE));
        this.itemsNeeded.add(GuardGearBuilder.buildGearForLevel(0, 2, GuardConstants.LEATHER_BUILDING_LEVEL_RANGE, GuardConstants.CHAIN_BUILDING_LEVEL_RANGE));
        this.itemsNeeded.add(GuardGearBuilder.buildGearForLevel(0, 3, GuardConstants.LEATHER_BUILDING_LEVEL_RANGE, GuardConstants.IRON_BUILDING_LEVEL_RANGE));
        this.itemsNeeded.add(GuardGearBuilder.buildGearForLevel(2, 4, GuardConstants.LEATHER_BUILDING_LEVEL_RANGE, GuardConstants.DIA_BUILDING_LEVEL_RANGE));
        this.itemsNeeded.add(GuardGearBuilder.buildGearForLevel(3, Integer.MAX_VALUE, GuardConstants.LEATHER_BUILDING_LEVEL_RANGE, GuardConstants.DIA_BUILDING_LEVEL_RANGE));
    }

    protected IAIState startWorkingAtOwnBuilding() {
        if (this.walkToBuilding()) {
            return this.getState();
        }
        return AIWorkerState.PREPARING;
    }

    @Override
    public IAIState afterRequestPickUp() {
        return AIWorkerState.PREPARING;
    }

    @Override
    public IAIState getStateAfterPickUp() {
        return AIWorkerState.PREPARING;
    }

    private IAIState prepare() {
        for (ToolType tool : this.toolsNeeded) {
            if (this.checkForToolOrWeapon(tool)) {
                return this.getState();
            }
            InventoryFunctions.matchFirstInProviderWithSimpleAction((ICapabilityProvider)this.worker, stack -> !ItemStackUtils.isEmpty(stack) && ItemStackUtils.doesItemServeAsWeapon(stack) && ItemStackUtils.hasToolLevel(stack, tool, 0, ((AbstractBuildingGuards)this.building).getMaxToolLevel()), itemStack -> this.worker.getCitizenItemHandler().setMainHeldItem((int)itemStack));
        }
        this.equipInventoryArmor();
        if (this.worker.m_20183_().m_123331_((Vec3i)((AbstractBuildingGuards)this.building).getID()) > 50.0) {
            return AIWorkerState.DECIDE;
        }
        this.atBuildingActions();
        return AIWorkerState.DECIDE;
    }

    protected void atBuildingActions() {
        for (GuardGear item : this.itemsNeeded.get(((AbstractBuildingGuards)this.building).getBuildingLevel() - 1)) {
            int slot;
            Map<IItemHandler, List<Integer>> items;
            if (((AbstractBuildingGuards)this.building).getBuildingLevel() < item.getMinBuildingLevelRequired() || ((AbstractBuildingGuards)this.building).getBuildingLevel() > item.getMaxBuildingLevelRequired() || item.getItemNeeded() == ToolType.SHIELD && this.worker.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.SHIELD_USAGE) <= 0.0) continue;
            int bestSlot = -1;
            int bestLevel = -1;
            IItemHandler bestHandler = null;
            if (item.getType().m_254934_()) {
                if (!ItemStackUtils.isEmpty(this.worker.getInventoryCitizen().getArmorInSlot(item.getType()))) {
                    bestLevel = ItemStackUtils.getMiningLevel(this.worker.getInventoryCitizen().getArmorInSlot(item.getType()), item.getItemNeeded());
                }
            } else if (!ItemStackUtils.isEmpty(this.worker.m_6844_(item.getType()))) {
                bestLevel = ItemStackUtils.getMiningLevel(this.worker.m_6844_(item.getType()), item.getItemNeeded());
            }
            if ((items = InventoryUtils.findAllSlotsInProviderWith(this.building, item)).isEmpty()) {
                if (item.getType().m_254934_() && ItemStackUtils.isEmpty(this.worker.getInventoryCitizen().getArmorInSlot(item.getType())) || !item.getType().m_254934_() && ItemStackUtils.isEmpty(this.worker.m_6844_(item.getType()))) {
                    this.checkForToolOrWeaponAsync(item.getItemNeeded(), item.getMinArmorLevel(), item.getMaxArmorLevel());
                }
            } else {
                for (Map.Entry<IItemHandler, List<Integer>> entry : items.entrySet()) {
                    for (Integer slot2 : entry.getValue()) {
                        int currentLevel;
                        ItemStack stack2 = entry.getKey().getStackInSlot(slot2.intValue());
                        if (ItemStackUtils.isEmpty(stack2) || (currentLevel = ItemStackUtils.getMiningLevel(stack2, item.getItemNeeded())) <= bestLevel) continue;
                        bestLevel = currentLevel;
                        bestSlot = slot2;
                        bestHandler = entry.getKey();
                    }
                }
            }
            if (bestHandler == null) continue;
            if (item.getType().m_254934_()) {
                if (!ItemStackUtils.isEmpty(this.worker.getInventoryCitizen().getArmorInSlot(item.getType()))) {
                    ItemStack armorStack = this.worker.getInventoryCitizen().getArmorInSlot(item.getType());
                    this.worker.getInventoryCitizen().moveArmorToInventory(item.getType());
                    int slot3 = InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith((IItemHandler)this.worker.getInventoryCitizen(), stack -> stack == armorStack);
                    if (slot3 > -1) {
                        InventoryUtils.transferItemStackIntoNextFreeSlotInProvider((IItemHandler)this.worker.getInventoryCitizen(), slot3, this.building);
                    }
                }
                ItemStack newStack = bestHandler.getStackInSlot(bestSlot);
                InventoryUtils.transferItemStackIntoNextFreeSlotInItemHandler(bestHandler, bestSlot, (IItemHandler)this.worker.getInventoryCitizen());
                int slot4 = InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith((IItemHandler)this.worker.getInventoryCitizen(), stack -> stack == newStack);
                if (slot4 <= -1) continue;
                this.worker.getInventoryCitizen().transferArmorToSlot(item.getType(), slot4);
                continue;
            }
            if (!ItemStackUtils.isEmpty(this.worker.m_6844_(item.getType())) && (slot = InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith((IItemHandler)this.worker.getInventoryCitizen(), stack -> stack == this.worker.m_6844_(item.getType()))) > -1) {
                InventoryUtils.transferItemStackIntoNextFreeSlotInProvider((IItemHandler)this.worker.getInventoryCitizen(), slot, this.building);
            }
            this.worker.m_8061_(item.getType(), bestHandler.getStackInSlot(bestSlot));
            InventoryUtils.transferItemStackIntoNextFreeSlotInItemHandler(bestHandler, bestSlot, (IItemHandler)this.worker.getInventoryCitizen());
        }
        this.equipInventoryArmor();
    }

    @Override
    public IAIState afterDump() {
        return AIWorkerState.PREPARING;
    }

    public void equipInventoryArmor() {
        this.cleanVisibleSlots();
        HashSet<EquipmentSlot> equipment = new HashSet<EquipmentSlot>();
        for (GuardGear item : this.itemsNeeded.get(((AbstractBuildingGuards)this.building).getBuildingLevel() - 1)) {
            int slot;
            if (equipment.contains(item.getType())) continue;
            if (item.getType().m_254934_()) {
                int newLevel;
                int currentLevel;
                if (((AbstractBuildingGuards)this.building).getBuildingLevel() < item.getMinBuildingLevelRequired() || ((AbstractBuildingGuards)this.building).getBuildingLevel() > item.getMaxBuildingLevelRequired() || (slot = InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith((IItemHandler)this.worker.getInventoryCitizen(), item)) <= -1) continue;
                equipment.add(item.getType());
                ItemStack current = this.worker.getInventoryCitizen().getArmorInSlot(item.getType());
                if (!current.m_41619_() && current.m_41720_() instanceof ArmorItem && (currentLevel = ItemStackUtils.getMiningLevel(current, item.getItemNeeded())) > (newLevel = ItemStackUtils.getMiningLevel(this.worker.getInventoryCitizen().getStackInSlot(slot), item.getItemNeeded()))) continue;
                this.worker.getInventoryCitizen().transferArmorToSlot(item.getType(), slot);
                continue;
            }
            if (!ItemStackUtils.isEmpty(this.worker.m_6844_(item.getType())) || ((AbstractBuildingGuards)this.building).getBuildingLevel() < item.getMinBuildingLevelRequired() || ((AbstractBuildingGuards)this.building).getBuildingLevel() > item.getMaxBuildingLevelRequired()) continue;
            equipment.add(item.getType());
            slot = InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith((IItemHandler)this.worker.getInventoryCitizen(), item);
            if (slot <= -1) continue;
            this.worker.m_8061_(item.getType(), this.worker.getInventoryCitizen().getStackInSlot(slot));
        }
    }

    public void cleanVisibleSlots() {
        ItemStack stack = this.worker.m_6844_(EquipmentSlot.OFFHAND);
        if (stack.m_41619_() || InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.getInventory(), itemStack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, itemStack, false, true)) == -1) {
            this.worker.m_8061_(EquipmentSlot.OFFHAND, ItemStackUtils.EMPTY);
        }
        this.worker.m_8061_(EquipmentSlot.HEAD, ItemStackUtils.EMPTY);
        this.worker.m_8061_(EquipmentSlot.CHEST, ItemStackUtils.EMPTY);
        this.worker.m_8061_(EquipmentSlot.LEGS, ItemStackUtils.EMPTY);
        this.worker.m_8061_(EquipmentSlot.FEET, ItemStackUtils.EMPTY);
    }
}

