/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.minimal;

import com.minecolonies.api.entity.ai.IStateAI;
import com.minecolonies.api.entity.ai.statemachine.AIEventTarget;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIBlockingEventType;
import com.minecolonies.api.entity.ai.statemachine.states.CitizenAIState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.citizen.AbstractCivilianEntity;
import com.minecolonies.api.entity.pathfinding.PathResult;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.colony.colonyEvents.citizenEvents.CitizenGrownUpEvent;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class EntityAICitizenChild
implements IStateAI {
    private static final int GROW_UP_NOTIFY_LIMIT = 10;
    protected final EntityCitizen child;
    private final Random rand = new Random();
    private int actionTimer = 0;
    private static final int START_FOLLOW_DISTANCE = 10;
    private int aiActiveTime = 0;
    private static final int MIN_ACTIVE_TIME = 4000;
    private static final int BONUS_TIME_COLONY = 2000;
    private WeakReference<Entity> followTarget = new WeakReference<Object>(null);
    private BlockPos followStart;
    private BlockPos visitHutPos;
    private PathResult visitingPath;

    public EntityAICitizenChild(@NotNull EntityCitizen citizen) {
        this.child = citizen;
        citizen.getCitizenAI().addTransition(new AITarget<Object>(CitizenAIState.IDLE, this::isReadyForActivity, () -> State.VISITING, 200));
        citizen.getCitizenAI().addTransition(new AIEventTarget<Supplier<Object>>(AIBlockingEventType.EVENT, this::tryGrowUp, () -> citizen.getCitizenAI().getState(), 500));
        citizen.getCitizenAI().addTransition(new AITarget<Object>(CitizenAIState.IDLE, this::searchEntityToFollow, () -> State.FOLLOWING, 200));
        citizen.getCitizenAI().addTransition(new AITarget<Object>(State.FOLLOWING, this::followingEntity, 20));
        citizen.getCitizenAI().addTransition(new AITarget<Object>(State.VISITING, this::visitHuts, 120));
    }

    private boolean isReadyForActivity() {
        if (this.actionTimer > 0) {
            this.actionTimer -= 100;
        }
        if (this.canUse() && this.actionTimer <= 0 && this.rand.nextInt(10) == 0) {
            this.setDelayForNextAction();
            return true;
        }
        return false;
    }

    private void setDelayForNextAction() {
        this.actionTimer = this.rand.nextInt(2400) + 3600;
    }

    private boolean searchEntityToFollow() {
        if (!this.isReadyForActivity()) {
            return false;
        }
        CompatibilityUtils.getWorldFromCitizen(this.child).m_6249_((Entity)this.child, this.child.m_20191_().m_82363_(10.0, 1.0, 10.0), target -> target.m_6084_() && (target instanceof AbstractCivilianEntity || target instanceof Player)).stream().findFirst().ifPresent(entity -> {
            this.followTarget = new WeakReference<Entity>((Entity)entity);
        });
        if (this.followTarget.get() != null) {
            this.actionTimer = this.rand.nextInt(600) + 600;
            this.followStart = this.child.m_20183_();
            return true;
        }
        return false;
    }

    private IState followingEntity() {
        this.actionTimer -= 20;
        if (this.actionTimer <= 0 || this.followTarget.get() == null) {
            this.child.getNavigation().moveToXYZ(this.followStart.m_123341_(), this.followStart.m_123342_(), this.followStart.m_123343_(), 1.0);
            this.setDelayForNextAction();
            return CitizenAIState.IDLE;
        }
        this.child.getNavigation().moveToLivingEntity((Entity)this.followTarget.get(), 1.0);
        return State.FOLLOWING;
    }

    private IState visitHuts() {
        if (this.visitingPath == null && this.child.getCitizenColonyHandler().getColony() != null) {
            if (this.actionTimer <= 0 && this.visitHutPos == null) {
                this.actionTimer = 3600;
            }
            int index = this.child.getCitizenColonyHandler().getColony().getBuildingManager().getBuildings().size();
            index = this.rand.nextInt(index);
            ArrayList<BlockPos> buildings = new ArrayList<BlockPos>(this.child.getCitizenColonyHandler().getColony().getBuildingManager().getBuildings().keySet());
            this.visitHutPos = (BlockPos)buildings.get(index);
            this.visitingPath = this.child.getNavigation().moveToXYZ(this.visitHutPos.m_123341_(), this.visitHutPos.m_123342_(), this.visitHutPos.m_123343_(), 1.0);
        }
        this.actionTimer -= 120;
        if (this.actionTimer > 0) {
            if (this.visitingPath != null && !this.visitingPath.isInProgress()) {
                this.visitingPath = this.child.getNavigation().moveToXYZ(this.visitHutPos.m_123341_(), this.visitHutPos.m_123342_(), this.visitHutPos.m_123343_(), 1.0);
            }
            return State.VISITING;
        }
        this.child.getNavigation().m_26573_();
        this.visitingPath = null;
        this.visitHutPos = null;
        this.setDelayForNextAction();
        return CitizenAIState.IDLE;
    }

    private boolean tryGrowUp() {
        double growthModifier;
        if (!this.child.m_6162_()) {
            return false;
        }
        if (this.child.getCitizenColonyHandler().getColony() != null && this.child.getCitizenColonyHandler().getColony().useAdditionalChildTime(2000)) {
            this.aiActiveTime += 2000;
        }
        if (this.aiActiveTime >= 4000 && (this.rand.nextInt((int)(70.0 / (growthModifier = 1.0 + this.child.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.GROWTH))) + 1) == 0 || (double)this.aiActiveTime > 70000.0 / growthModifier)) {
            this.child.getCitizenColonyHandler().getColony().getEventDescriptionManager().addEventDescription(new CitizenGrownUpEvent(this.child.m_20183_(), this.child.getCitizenData().getName()));
            if (this.child.getCitizenColonyHandler().getColony().getCitizenManager().getCitizens().size() <= 10) {
                MessageUtils.format("com.minecolonies.coremod.progress.childgrow", this.child.m_7755_().getString()).sendTo(this.child.getCitizenColonyHandler().getColony()).forAllPlayers();
            }
            this.child.setIsChild(false);
            this.child.setTextureDirty();
            this.child.getCitizenData().setIsChild(false);
            return true;
        }
        return false;
    }

    public boolean canUse() {
        return this.child.m_6162_() && this.child.getCitizenData() != null;
    }

    public static enum State implements IAIState
    {
        BORED,
        PLAYING,
        VISITING,
        FOLLOWING;


        @Override
        public boolean isOkayToEat() {
            return true;
        }
    }
}

