/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.workorders;

import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.storage.StructurePacks;
import com.ldtteam.structurize.util.IOPool;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.workorders.IWorkManager;
import com.minecolonies.api.colony.workorders.WorkOrderType;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.core.colony.jobs.JobMiner;
import com.minecolonies.core.colony.workorders.AbstractWorkOrder;
import java.util.concurrent.Future;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.NotNull;

public class WorkOrderMiner
extends AbstractWorkOrder {
    private BlockPos minerBuilding;

    public WorkOrderMiner() {
    }

    public WorkOrderMiner(String packName, String structureName, String workOrderName, int rotation, BlockPos location, boolean mirror, BlockPos minerBuilding) {
        super(packName, structureName, workOrderName, WorkOrderType.BUILD, location, rotation, mirror, 0, 1);
        this.minerBuilding = minerBuilding;
    }

    @Override
    public Future<Blueprint> getBlueprintFuture() {
        return IOPool.submit(() -> {
            Blueprint blueprint = StructurePacks.getBlueprint((String)this.getStructurePack(), (String)this.getStructurePath(), (boolean)true);
            if (blueprint == null && (blueprint = StructurePacks.getBlueprint((String)"Minecolonies Original", (String)this.getStructurePath())) != null) {
                this.packName = "Minecolonies Original";
                this.changed = true;
            }
            return blueprint;
        });
    }

    @Override
    public boolean canBuild(@NotNull ICitizenData citizen) {
        return this.minerBuilding.equals((Object)citizen.getWorkBuilding().getID());
    }

    @Override
    public boolean canBeMadeBy(IJob<?> job) {
        return job instanceof JobMiner;
    }

    @Override
    public boolean isValid(IColony colony) {
        return super.isValid(colony) && colony.getBuildingManager().getBuilding(this.minerBuilding) != null;
    }

    @Override
    public void read(@NotNull CompoundTag compound, IWorkManager manager) {
        super.read(compound, manager);
        this.minerBuilding = BlockPosUtil.read(compound, "pos");
    }

    @Override
    public void write(@NotNull CompoundTag compound) {
        super.write(compound);
        BlockPosUtil.write(compound, "pos", this.minerBuilding);
    }

    public BlockPos getMinerBuilding() {
        return this.minerBuilding;
    }
}

