/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.interactionhandling;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.AbstractTextBuilder;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.BOWindow;
import com.ldtteam.blockui.views.Box;
import com.minecolonies.api.colony.ICitizen;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.IVisitorData;
import com.minecolonies.api.colony.IVisitorViewData;
import com.minecolonies.api.colony.citizens.event.CitizenAddedEvent;
import com.minecolonies.api.colony.interactionhandling.IChatPriority;
import com.minecolonies.api.colony.interactionhandling.IInteractionResponseHandler;
import com.minecolonies.api.colony.interactionhandling.ModInteractionResponseHandlers;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.core.colony.interactionhandling.ServerCitizenInteraction;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class RecruitmentInteraction
extends ServerCitizenInteraction {
    private static final String RECRUITMENT_ICON = "recruitIcon";
    private static final ResourceLocation icon = new ResourceLocation("minecolonies", "textures/icons/recruiticon.png");
    private static final Tuple<Component, Component> recruitAnswer = new Tuple<MutableComponent, Object>(Component.m_237115_((String)"com.minecolonies.coremod.gui.chat.recruit"), null);
    private static final Tuple<Component, Component>[] responses = new Tuple[]{new Tuple<MutableComponent, Object>(Component.m_237115_((String)"com.minecolonies.coremod.gui.chat.showstats"), null), recruitAnswer, new Tuple<MutableComponent, Object>(Component.m_237115_((String)"com.minecolonies.coremod.gui.chat.notnow"), null)};
    private static final int BAD_VISITOR_CHANCE = 2;

    public RecruitmentInteraction(ICitizen data) {
        super(data);
    }

    public RecruitmentInteraction(Component inquiry, IChatPriority priority) {
        super(inquiry, true, priority, (ICitizenData d) -> true, null, responses);
    }

    @Override
    public List<IInteractionResponseHandler> genChildInteractions() {
        return Collections.emptyList();
    }

    @Override
    public String getType() {
        return ModInteractionResponseHandlers.RECRUITMENT.m_135815_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onWindowOpened(BOWindow window, ICitizenDataView dataView) {
        ButtonImage recruitButton = (ButtonImage)window.findPaneOfTypeByID("response_2", ButtonImage.class);
        Box group = (Box)window.findPaneOfTypeByID("responseOptions", Box.class);
        if (recruitButton != null && dataView instanceof IVisitorViewData) {
            ItemStack recruitCost = ((IVisitorViewData)dataView).getRecruitCost();
            IColonyView colony = (IColonyView)dataView.getColony();
            ((Text)window.findPaneOfTypeByID("chat", Text.class)).setText(((AbstractTextBuilder.TextBuilder)((AbstractTextBuilder.TextBuilder)((AbstractTextBuilder.TextBuilder)((AbstractTextBuilder.TextBuilder)PaneBuilders.textBuilder().append(Component.m_237113_((String)(dataView.getName() + ": ")))).append(this.getInquiry())).emptyLines(1)).append(Component.m_237110_((String)(colony.getCitizens().size() < colony.getCitizenCountLimit() ? "com.minecolonies.coremod.gui.chat.recruitcost" : "com.minecolonies.coremod.gui.chat.nospacerecruit"), (Object[])new Object[]{dataView.getName().split(" ")[0], recruitCost.m_41613_() + " " + recruitCost.m_41786_().getString()}))).getText());
            int iconPosX = recruitButton.getX() + recruitButton.getWidth() - 28;
            int iconPosY = recruitButton.getY() + recruitButton.getHeight() - 18;
            ItemIcon icon = new ItemIcon();
            icon.setID(RECRUITMENT_ICON);
            icon.setSize(15, 15);
            group.addChild((Pane)icon);
            icon.setItem(((IVisitorViewData)dataView).getRecruitCost());
            icon.setPosition(iconPosX, iconPosY);
            icon.setVisible(true);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean onClientResponseTriggered(int responseId, Player player, ICitizenDataView data, BOWindow window) {
        Component response = this.getPossibleResponses().get(responseId);
        if (response.equals(recruitAnswer.getA()) && data instanceof IVisitorViewData) {
            if (player.m_7500_() || InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((Container)player.m_150109_()), ((IVisitorViewData)data).getRecruitCost().m_41720_()) >= ((IVisitorViewData)data).getRecruitCost().m_41613_()) {
                return super.onClientResponseTriggered(responseId, player, data, window);
            }
            MessageUtils.format("com.minecolonies.coremod.gui.chat.notenoughitems", new Object[0]).sendTo(player);
        }
        return true;
    }

    @Override
    public void onServerResponseTriggered(int responseId, Player player, ICitizenData data) {
        Component response = this.getPossibleResponses().get(responseId);
        if (response.equals(recruitAnswer.getA()) && data instanceof IVisitorData) {
            IColony colony = data.getColony();
            if (colony.getCitizenManager().getCurrentCitizenCount() < colony.getCitizenManager().getPotentialMaxCitizens()) {
                if (player.m_7500_() || InventoryUtils.attemptReduceStackInItemHandler((IItemHandler)new InvWrapper((Container)player.m_150109_()), ((IVisitorData)data).getRecruitCost(), ((IVisitorData)data).getRecruitCost().m_41613_(), true, true)) {
                    colony.getVisitorManager().removeCivilian(data);
                    data.setHomeBuilding(null);
                    data.setJob(null);
                    if (colony.getWorld().f_46441_.m_188503_(100) <= 2) {
                        MessageUtils.format("com.minecolonies.coremod.recruit.runaway", data.getName()).sendTo(colony).forAllPlayers();
                        return;
                    }
                    ICitizenData newCitizen = colony.getCitizenManager().createAndRegisterCivilianData();
                    newCitizen.deserializeNBT((Tag)((CompoundTag)data.serializeNBT()));
                    newCitizen.setParents("", "");
                    newCitizen.updateEntityIfNecessary();
                    data.getEntity().ifPresent(e -> e.m_142687_(Entity.RemovalReason.DISCARDED));
                    if (data.hasCustomTexture()) {
                        MessageUtils.format("com.minecolonies.coremod.recruit.message.custom", data.getName()).sendTo(colony).forAllPlayers();
                    } else {
                        MessageUtils.format("com.minecolonies.coremod.recruit.message", data.getName()).sendTo(colony).forAllPlayers();
                    }
                    MinecraftForge.EVENT_BUS.post((Event)new CitizenAddedEvent(newCitizen, CitizenAddedEvent.Source.HIRED));
                }
            } else {
                MessageUtils.format("com.minecolonies.coremod.gui.chat.nospace", new Object[0]).sendTo(player);
            }
        }
    }

    @Override
    public ResourceLocation getInteractionIcon() {
        return icon;
    }
}

