/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.fields;

import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IBuildingModuleView;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.fields.IField;
import com.minecolonies.api.colony.fields.modules.IFieldModule;
import com.minecolonies.api.colony.fields.registry.FieldRegistries;
import com.minecolonies.api.colony.modules.ModuleContainerUtils;
import com.minecolonies.api.util.BlockPosUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractField
implements IField {
    private final List<IFieldModule> modules = new ArrayList<IFieldModule>();
    private final FieldRegistries.FieldEntry fieldType;
    private final BlockPos position;
    @Nullable
    private BlockPos buildingId = null;

    protected AbstractField(@NotNull FieldRegistries.FieldEntry fieldType, @NotNull BlockPos position) {
        this.fieldType = fieldType;
        this.position = position;
    }

    @Override
    public boolean hasModule(Class<? extends IFieldModule> clazz) {
        return ModuleContainerUtils.hasModule(this.modules, clazz);
    }

    @Override
    public boolean hasModule(BuildingEntry.ModuleProducer producer) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    @NotNull
    public <T extends IFieldModule> T getFirstModuleOccurance(Class<T> clazz) {
        return (T)((IFieldModule)ModuleContainerUtils.getFirstModuleOccurance(this.modules, clazz, "The module of class: " + clazz.toString() + "should never be null! Field:" + this.getFieldType().getRegistryName() + " pos:" + this.getPosition()));
    }

    @Override
    @NotNull
    public <M extends IBuildingModule, V extends IBuildingModuleView> M getModule(BuildingEntry.ModuleProducer<M, V> producer) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public IBuildingModule getModule(int id) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    @NotNull
    public <T extends IFieldModule> List<T> getModulesByType(Class<T> clazz) {
        return ModuleContainerUtils.getModules(this.modules, clazz);
    }

    @Override
    @NotNull
    public <T extends IFieldModule> T getModuleMatching(Class<T> clazz, Predicate<? super T> modulePredicate) {
        return (T)((IFieldModule)ModuleContainerUtils.getModuleMatching(this.modules, clazz, modulePredicate, "no matching module for Field:" + this.getFieldType().getRegistryName() + " pos:" + this.getPosition().m_123344_()));
    }

    @Override
    public void registerModule(@NotNull IFieldModule module) {
        this.modules.add(module);
    }

    @Override
    @NotNull
    public final FieldRegistries.FieldEntry getFieldType() {
        return this.fieldType;
    }

    @Override
    @NotNull
    public final BlockPos getPosition() {
        return this.position;
    }

    @Override
    @Nullable
    public final BlockPos getBuildingId() {
        return this.buildingId;
    }

    @Override
    public final void setBuilding(BlockPos buildingId) {
        this.buildingId = buildingId;
    }

    @Override
    public final void resetOwningBuilding() {
        this.buildingId = null;
    }

    @Override
    public final boolean isTaken() {
        return this.buildingId != null;
    }

    @Override
    public final int getSqDistance(IBuildingView building) {
        return (int)Math.sqrt(BlockPosUtil.getDistanceSquared(this.position, building.getPosition()));
    }

    @Override
    @NotNull
    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        if (this.buildingId != null) {
            BlockPosUtil.write(compound, "owner", this.buildingId);
        }
        return compound;
    }

    @Override
    public void deserializeNBT(@NotNull CompoundTag compound) {
        if (compound.m_128441_("owner")) {
            this.buildingId = BlockPosUtil.read(compound, "owner");
        }
    }

    @Override
    public void serialize(@NotNull FriendlyByteBuf buf) {
        buf.writeBoolean(this.buildingId != null);
        if (this.buildingId != null) {
            buf.m_130064_(this.buildingId);
        }
    }

    @Override
    public void deserialize(@NotNull FriendlyByteBuf buf) {
        if (buf.readBoolean()) {
            this.buildingId = buf.m_130135_();
        }
    }

    @Override
    public int hashCode() {
        int result = this.position.hashCode();
        result = 31 * result + this.fieldType.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractField that = (AbstractField)o;
        if (!this.position.equals((Object)that.position)) {
            return false;
        }
        return this.fieldType.equals(that.fieldType);
    }
}

