/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.colonyEvents.raidEvents.pirateEvent;

import com.google.common.collect.Lists;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.storage.StructurePacks;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.colonyEvents.IColonyRaidEvent;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.colony.colonyEvents.raidEvents.pirateEvent.ShipSize;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import org.jetbrains.annotations.NotNull;

public final class ShipBasedRaiderUtils {
    public static final String SHIP_FOLDER = "/ships/";
    private static final int SPAWNER_DISTANCE = 30;

    private ShipBasedRaiderUtils() {
    }

    public static boolean spawnPirateShip(BlockPos targetSpawnPoint, IColony colony, Blueprint blueprint, IColonyRaidEvent event) {
        return colony.getEventManager().getStructureManager().spawnTemporaryStructure(blueprint, targetSpawnPoint, event.getID());
    }

    public static void setupSpawner(BlockPos location, Level world, EntityType<?> mob, IColonyRaidEvent event, int colonyId) {
        world.m_7471_(location, false);
        world.m_46597_(location, Blocks.f_50085_.m_49966_());
        SpawnerBlockEntity spawner = new SpawnerBlockEntity(location, Blocks.f_50085_.m_49966_());
        spawner.m_59801_().f_45452_ = 30;
        spawner.m_59801_().m_253197_(mob, world, world.m_213780_(), location);
        spawner.m_59801_().f_45444_.m_186567_().m_128405_("mc_event_id", event.getID());
        spawner.m_59801_().f_45444_.m_186567_().m_128405_("colony", colonyId);
        event.addSpawner(location);
        world.m_151523_((BlockEntity)spawner);
    }

    public static boolean canSpawnShipAt(IColony colony, BlockPos spawnPoint, int raidLevel, int rotation, String shipName) {
        if (spawnPoint.equals((Object)colony.getCenter())) {
            return false;
        }
        Level world = colony.getWorld();
        String shipSize = ShipSize.getShipForRaiderAmount((int)raidLevel).schematicPrefix + shipName;
        Blueprint blueprint = StructurePacks.getBlueprint((String)"Minecolonies Original", (String)("decorations/ships/" + shipSize + ".blueprint"));
        blueprint.rotateWithMirror(BlockPosUtil.getRotationFromRotations(rotation), Mirror.NONE, colony.getWorld());
        return ShipBasedRaiderUtils.canPlaceShipAt(spawnPoint, blueprint, world) || ShipBasedRaiderUtils.canPlaceShipAt(spawnPoint.m_7495_(), blueprint, world);
    }

    public static boolean canPlaceShipAt(BlockPos pos, Blueprint ship, Level world) {
        BlockPos zeroPos = pos.m_121996_((Vec3i)ship.getPrimaryBlockOffset());
        ArrayList allowedShipMaterials = Lists.newArrayList();
        allowedShipMaterials.add(BlockBehaviour.BlockStateBase::m_278721_);
        allowedShipMaterials.add(state -> state.m_204336_(BlockTags.f_13047_));
        allowedShipMaterials.add(state -> !state.m_280555_() && state.m_60819_().m_205070_(FluidTags.f_13131_));
        if (((Boolean)MineColonies.getConfig().getServer().skyRaiders.get()).booleanValue()) {
            allowedShipMaterials.add(BlockBehaviour.BlockStateBase::m_60795_);
        }
        return ShipBasedRaiderUtils.isSurfaceAreaMostlyMaterial(allowedShipMaterials, world, pos.m_123342_(), zeroPos, new BlockPos(zeroPos.m_123341_() + ship.getSizeX() - 1, zeroPos.m_123342_(), zeroPos.m_123343_() + ship.getSizeZ() - 1), 0.85);
    }

    public static boolean isSurfaceAreaMostlyMaterial(@NotNull List<Predicate<BlockState>> materials, @NotNull Level world, int baseY, @NotNull BlockPos from, @NotNull BlockPos to, double percentRequired) {
        int xDist = Math.abs(from.m_123341_() - to.m_123341_());
        int zDist = Math.abs(from.m_123343_() - to.m_123343_());
        int wrongMaterialBlocks = 0;
        int neededMaterialBlocks = (int)(percentRequired * (double)(xDist * zDist));
        int wrongMaterialBlockThreshold = xDist * zDist - neededMaterialBlocks;
        int xDir = 1;
        int zDir = 1;
        if (from.m_123341_() > to.m_123341_()) {
            xDir = -1;
        }
        if (from.m_123343_() > to.m_123343_()) {
            zDir = -1;
        }
        for (int x = 0; x < xDist; ++x) {
            for (int z = 0; z < zDist; ++z) {
                BlockState state = world.m_8055_(new BlockPos(from.m_123341_() + x * xDir, baseY, from.m_123343_() + z * zDir));
                boolean suitableBlock = false;
                for (Predicate<BlockState> pred : materials) {
                    if (!pred.test(state)) continue;
                    suitableBlock = true;
                    break;
                }
                if (suitableBlock) {
                    for (int i = 1; i <= 5; ++i) {
                        if (!world.m_8055_(new BlockPos(from.m_123341_() + x * xDir, baseY + i, from.m_123343_() + z * zDir)).m_280555_()) continue;
                        suitableBlock = false;
                        break;
                    }
                }
                if (suitableBlock || ++wrongMaterialBlocks <= wrongMaterialBlockThreshold) continue;
                return false;
            }
        }
        return true;
    }

    public static BlockPos getLoadedPositionTowardsCenter(BlockPos startPos, IColony colony, int maxDistance, BlockPos maxDistancePos, int minDistance, int accuracy) {
        if (accuracy < 1) {
            return null;
        }
        if (WorldUtil.isBlockLoaded((LevelAccessor)colony.getWorld(), startPos)) {
            return BlockPosUtil.findAround(colony.getWorld(), startPos, 30, 3, (world, pos) -> (world.m_8055_(pos).m_60815_() || world.m_8055_(pos).m_278721_()) && world.m_8055_(pos.m_7494_()).m_60795_() && world.m_8055_(pos.m_6630_(2)).m_60795_());
        }
        BlockPos diff = colony.getCenter().m_121996_((Vec3i)startPos);
        diff = new BlockPos(diff.m_123341_() / accuracy, diff.m_123342_() / accuracy, diff.m_123343_() / accuracy);
        int sqMaxDist = maxDistance * maxDistance;
        int sqMinDist = minDistance * minDistance;
        BlockPos tempPos = new BlockPos((Vec3i)startPos);
        for (int i = 0; i < accuracy; ++i) {
            if (BlockPosUtil.getDistanceSquared2D(maxDistancePos, tempPos = tempPos.m_121955_((Vec3i)diff)) > (long)sqMaxDist || BlockPosUtil.getDistanceSquared2D(tempPos, colony.getCenter()) < (long)sqMinDist) {
                return null;
            }
            if (!WorldUtil.isBlockLoaded((LevelAccessor)colony.getWorld(), tempPos)) continue;
            return BlockPosUtil.getFloor(tempPos, colony.getWorld());
        }
        return null;
    }

    public static BlockPos findSpawnPosOnShip(BlockPos spawnPos, Level world, int radius) {
        for (int y = 0; y <= radius * 2; y += 2) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    if (!(world.m_8055_(spawnPos.m_7918_(x, y, z)).m_60734_() instanceof AirBlock) || !(world.m_8055_(spawnPos.m_7918_(x, y + 1, z)).m_60734_() instanceof AirBlock)) continue;
                    return spawnPos.m_7918_(x, y, z);
                }
            }
        }
        return spawnPos;
    }

    public static List<BlockPos> createWaypoints(Level world, Path path, int spacing) {
        ArrayList<BlockPos> wayPoints = new ArrayList<BlockPos>();
        if (path == null) {
            return wayPoints;
        }
        BlockPos lastPoint = BlockPos.f_121853_;
        for (int i = 0; i < path.m_77398_(); ++i) {
            BlockPos point = path.m_77375_(i).m_77288_();
            if (lastPoint.m_123333_((Vec3i)point) <= spacing || !world.m_8055_(point).m_60795_()) continue;
            wayPoints.add(point);
            lastPoint = point;
        }
        return wayPoints;
    }

    public static BlockPos chooseWaypointFor(List<BlockPos> wayPoints, BlockPos startPos, BlockPos target) {
        BlockPos closest = target;
        BlockPos secondClosest = target;
        for (BlockPos wayPoint : wayPoints) {
            int distToStart = wayPoint.m_123333_((Vec3i)startPos);
            if (distToStart <= 5 || distToStart >= closest.m_123333_((Vec3i)startPos)) continue;
            secondClosest = closest;
            closest = wayPoint;
        }
        if (secondClosest.m_123333_((Vec3i)target) < closest.m_123333_((Vec3i)target)) {
            closest = secondClosest;
        }
        if (closest.m_123333_((Vec3i)target) >= startPos.m_123333_((Vec3i)target)) {
            return target;
        }
        return closest;
    }
}

