/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.colonyEvents.raidEvents.barbarianEvent;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.colonyEvents.EventStatus;
import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.entity.mobs.AbstractEntityRaiderMob;
import com.minecolonies.core.colony.colonyEvents.raidEvents.HordeRaidEvent;
import com.minecolonies.core.entity.mobs.barbarians.EntityArcherBarbarian;
import com.minecolonies.core.entity.mobs.barbarians.EntityBarbarian;
import com.minecolonies.core.entity.mobs.barbarians.EntityChiefBarbarian;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;

public class BarbarianRaidEvent
extends HordeRaidEvent {
    public static final ResourceLocation BARBARIAN_RAID_EVENT_TYPE_ID = new ResourceLocation("minecolonies", "barbarian_raid");

    public BarbarianRaidEvent(IColony colony) {
        super(colony);
    }

    @Override
    public ResourceLocation getEventTypeID() {
        return BARBARIAN_RAID_EVENT_TYPE_ID;
    }

    @Override
    public void registerEntity(Entity entity) {
        if (!(entity instanceof AbstractEntityRaiderMob) || !entity.m_6084_()) {
            entity.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        if (entity instanceof EntityChiefBarbarian && this.boss.keySet().size() < this.horde.numberOfBosses) {
            this.boss.put(entity, entity.m_20148_());
            return;
        }
        if (entity instanceof EntityArcherBarbarian && this.archers.keySet().size() < this.horde.numberOfArchers) {
            this.archers.put(entity, entity.m_20148_());
            return;
        }
        if (entity instanceof EntityBarbarian && this.normal.keySet().size() < this.horde.numberOfRaiders) {
            this.normal.put(entity, entity.m_20148_());
            return;
        }
        entity.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    @Override
    public void onEntityDeath(LivingEntity entity) {
        super.onEntityDeath(entity);
        if (!(entity instanceof AbstractEntityRaiderMob)) {
            return;
        }
        if (entity instanceof EntityChiefBarbarian) {
            this.boss.remove(entity);
            --this.horde.numberOfBosses;
        }
        if (entity instanceof EntityArcherBarbarian) {
            this.archers.remove(entity);
            --this.horde.numberOfArchers;
        }
        if (entity instanceof EntityBarbarian) {
            this.normal.remove(entity);
            --this.horde.numberOfRaiders;
        }
        --this.horde.hordeSize;
        if (this.horde.hordeSize == 0) {
            this.status = EventStatus.DONE;
        }
        this.sendHordeMessage();
    }

    public static BarbarianRaidEvent loadFromNBT(IColony colony, CompoundTag compound) {
        BarbarianRaidEvent event = new BarbarianRaidEvent(colony);
        event.deserializeNBT(compound);
        return event;
    }

    @Override
    public EntityType<?> getNormalRaiderType() {
        return ModEntities.BARBARIAN;
    }

    @Override
    public EntityType<?> getArcherRaiderType() {
        return ModEntities.ARCHERBARBARIAN;
    }

    @Override
    public EntityType<?> getBossRaiderType() {
        return ModEntities.CHIEFBARBARIAN;
    }

    @Override
    protected MutableComponent getDisplayName() {
        return Component.m_237115_((String)"com.minecolonies.coremod.raid.barbarian.name");
    }
}

