/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.colonyEvents.citizenEvents;

import com.minecolonies.core.colony.colonyEvents.citizenEvents.AbstractCitizenEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class CitizenDiedEvent
extends AbstractCitizenEvent {
    public static final ResourceLocation CITIZEN_DIED_EVENT_ID = new ResourceLocation("minecolonies", "citizen_died");
    private String deathCause;

    public CitizenDiedEvent() {
    }

    public CitizenDiedEvent(BlockPos eventPos, String citizenName, String deathCause) {
        super(eventPos, citizenName);
        this.deathCause = deathCause;
    }

    @Override
    public ResourceLocation getEventTypeId() {
        return CITIZEN_DIED_EVENT_ID;
    }

    @Override
    public String getName() {
        return "Citizen Died";
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        compound.m_128359_("deathCause", this.deathCause);
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        this.deathCause = compound.m_128461_("deathCause");
    }

    @Override
    public void serialize(FriendlyByteBuf buf) {
        super.serialize(buf);
        buf.m_130070_(this.deathCause);
    }

    @Override
    public void deserialize(FriendlyByteBuf buf) {
        super.deserialize(buf);
        this.deathCause = buf.m_130277_();
    }

    public String getDeathCause() {
        return this.deathCause;
    }

    public void setDeathCause(String deathCause) {
        this.deathCause = deathCause;
    }

    public static CitizenDiedEvent loadFromNBT(@NotNull CompoundTag compound) {
        CitizenDiedEvent deathEvent = new CitizenDiedEvent();
        deathEvent.deserializeNBT(compound);
        return deathEvent;
    }

    public static CitizenDiedEvent loadFromFriendlyByteBuf(@NotNull FriendlyByteBuf buf) {
        CitizenDiedEvent deathEvent = new CitizenDiedEvent();
        deathEvent.deserialize(buf);
        return deathEvent;
    }
}

