/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.workerbuildings.plantation.modules.generic;

import com.minecolonies.api.colony.fields.IField;
import com.minecolonies.api.colony.fields.plantation.IPlantationModule;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.core.colony.buildings.workerbuildings.plantation.AbstractPlantationModule;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BoneMealedPlantModule
extends AbstractPlantationModule {
    private static final int DEFAULT_PERCENTAGE_CHANCE = 50;
    private static final int MAX_PLANTS = 121;
    private final Random random = new Random();

    protected BoneMealedPlantModule(IField field, String fieldTag, String workTag, Item item) {
        super(field, fieldTag, workTag, item);
    }

    @Override
    public IPlantationModule.PlantationModuleResult.Builder decideFieldWork(Level world, @NotNull BlockPos workingPosition) {
        IPlantationModule.ActionToPerform action = this.decideWorkAction(world, workingPosition);
        return switch (action) {
            case IPlantationModule.ActionToPerform.HARVEST -> new IPlantationModule.PlantationModuleResult.Builder().harvest(workingPosition.m_7494_()).pickNewPosition();
            case IPlantationModule.ActionToPerform.BONEMEAL -> new IPlantationModule.PlantationModuleResult.Builder().bonemeal(workingPosition).pickNewPosition();
            default -> IPlantationModule.PlantationModuleResult.NONE;
        };
    }

    private IPlantationModule.ActionToPerform decideWorkAction(Level world, BlockPos workPosition) {
        BlockState blockState = world.m_8055_(workPosition.m_7494_());
        if (this.isValidHarvestBlock(blockState)) {
            return IPlantationModule.ActionToPerform.HARVEST;
        }
        if (this.isValidBonemealLocation(blockState)) {
            return IPlantationModule.ActionToPerform.BONEMEAL;
        }
        return IPlantationModule.ActionToPerform.NONE;
    }

    protected boolean isValidHarvestBlock(BlockState blockState) {
        return !blockState.m_60795_();
    }

    protected boolean isValidBonemealLocation(BlockState blockState) {
        return blockState.m_60795_();
    }

    @Override
    @Nullable
    public BlockPos getNextWorkingPosition(Level world) {
        boolean willWork;
        BlockPos positionToHarvest = this.getPositionToHarvest(world);
        if (positionToHarvest != null) {
            return positionToHarvest;
        }
        int percentChance = Math.max(Math.min(this.getPercentageChance(), 100), 1);
        boolean bl = willWork = this.random.nextFloat() < (float)percentChance / 100.0f;
        if (willWork && !this.getWorkingPositions().isEmpty()) {
            List<BlockPos> workingPositions = this.getWorkingPositions();
            int idx = this.random.nextInt(0, workingPositions.size());
            return workingPositions.get(idx);
        }
        return null;
    }

    @Nullable
    private BlockPos getPositionToHarvest(Level world) {
        return this.getWorkingPositions().stream().filter(pos -> this.isValidHarvestBlock(world.m_8055_(pos.m_7494_()))).findFirst().orElse(null);
    }

    protected int getPercentageChance() {
        return 50;
    }

    @Override
    public int getActionLimit() {
        return 1;
    }

    @Override
    public List<ItemStack> getRequiredItemsForOperation() {
        return this.getValidBonemeal().stream().map(ItemStack::new).toList();
    }

    @Override
    protected int getMaxWorkingPositions() {
        return 121;
    }

    @Override
    public List<Item> getValidBonemeal() {
        return List.of(Items.f_42499_, ModItems.compost);
    }
}

