/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.workerbuildings;

import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.core.client.gui.huts.WindowBarracksBuilding;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingBarracksTower;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class BuildingBarracks
extends AbstractBuilding {
    private static final String SCHEMATIC_NAME = "barracks";
    private static final int BARRACKS_HUT_MAX_LEVEL = 5;
    private static final String TAG_TOWERS = "towers";
    private final List<BlockPos> towers = new ArrayList<BlockPos>();
    public static int SPIES_GOLD_COST = 5;

    public BuildingBarracks(@NotNull IColony colony, BlockPos pos) {
        super(colony, pos);
        this.keepX.put(stack -> stack.m_41720_() == Items.f_42417_, new Tuple((Object)64, (Object)true));
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return SCHEMATIC_NAME;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void onDestroyed() {
        Level world = this.getColony().getWorld();
        if (world != null) {
            for (BlockPos tower : this.towers) {
                world.m_46597_(tower, Blocks.f_50016_.m_49966_());
            }
        }
        super.onDestroyed();
        this.colony.getBuildingManager().guardBuildingChangedAt(this, 0);
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        super.onUpgradeComplete(newLevel);
        this.colony.getBuildingManager().guardBuildingChangedAt(this, newLevel);
    }

    @Override
    public void registerBlockPosition(@NotNull BlockState block, @NotNull BlockPos pos, @NotNull Level world) {
        IBuilding building;
        super.registerBlockPosition(block, pos, world);
        if (block.m_60734_() == ModBlocks.blockHutBarracksTower && (building = this.getColony().getBuildingManager().getBuilding(pos)) instanceof BuildingBarracksTower) {
            building.setStructurePack(this.getStructurePack());
            ((BuildingBarracksTower)building).addBarracks(this.getPosition());
            if (!this.towers.contains(pos)) {
                this.towers.add(pos);
            }
        }
    }

    @Override
    public void onColonyTick(@NotNull IColony colony) {
        super.onColonyTick(colony);
        if (colony.getWorld().f_46443_) {
            return;
        }
        if (colony.getRaiderManager().isRaided()) {
            if (!colony.getRaiderManager().areSpiesEnabled() && InventoryUtils.tryRemoveStackFromItemHandler((IItemHandler)this.getCapability(ForgeCapabilities.ITEM_HANDLER).orElseGet(null), new ItemStack((ItemLike)Items.f_42417_, SPIES_GOLD_COST))) {
                colony.getRaiderManager().setSpiesEnabled(true);
                colony.markDirty();
            }
        } else {
            colony.getRaiderManager().setSpiesEnabled(false);
        }
    }

    @Override
    public int getClaimRadius(int newLevel) {
        if (newLevel <= 0) {
            return 0;
        }
        int barracksClaimRadius = 3;
        for (BlockPos pos : this.towers) {
            IBuilding building = this.colony.getBuildingManager().getBuilding(pos);
            if (building == null || building.getBuildingLevel() >= 4) continue;
            barracksClaimRadius = 2;
            break;
        }
        return barracksClaimRadius;
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        this.towers.clear();
        this.towers.addAll(NBTUtils.streamCompound(compound.m_128437_(TAG_TOWERS, 10)).map(resultCompound -> BlockPosUtil.read(resultCompound, "pos")).collect(Collectors.toList()));
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        ListTag towerTagList = this.towers.stream().map(pos -> BlockPosUtil.write(new CompoundTag(), "pos", pos)).collect(NBTUtils.toListNBT());
        compound.m_128365_(TAG_TOWERS, (Tag)towerTagList);
        return compound;
    }

    public List<BlockPos> getTowers() {
        return this.towers;
    }

    public static class View
    extends AbstractBuildingView {
        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public BOWindow getWindow() {
            return new WindowBarracksBuilding(this);
        }
    }
}

