/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.moduleviews;

import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModuleView;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.registry.CraftingType;
import com.minecolonies.core.Network;
import com.minecolonies.core.client.gui.modules.WindowListRecipes;
import com.minecolonies.core.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.core.network.messages.server.colony.building.OpenCraftingGUIMessage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.MenuProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CraftingModuleView
extends AbstractBuildingModuleView {
    private String id;
    private JobEntry jobEntry;
    private Set<CraftingType> recipeTypeSet = new HashSet<CraftingType>();
    protected final List<IRecipeStorage> recipes = new ArrayList<IRecipeStorage>();
    protected final List<IRecipeStorage> disabledRecipes = new ArrayList<IRecipeStorage>();
    private int maxRecipes;
    private boolean isVisible = false;

    @Override
    public void deserialize(@NotNull FriendlyByteBuf buf) {
        this.jobEntry = buf.readBoolean() ? (JobEntry)buf.readRegistryIdSafe(JobEntry.class) : null;
        this.recipeTypeSet.clear();
        int size = buf.m_130242_();
        for (int i = 0; i < size; ++i) {
            CraftingType type = (CraftingType)buf.readRegistryIdUnsafe(MinecoloniesAPIProxy.getInstance().getCraftingTypeRegistry());
            if (type == null) continue;
            this.recipeTypeSet.add(type);
        }
        this.recipes.clear();
        this.disabledRecipes.clear();
        int recipesSize = buf.readInt();
        for (int i = 0; i < recipesSize; ++i) {
            IRecipeStorage storage = (IRecipeStorage)StandardFactoryController.getInstance().deserialize(buf.m_130260_());
            if (storage == null) continue;
            this.recipes.add(storage);
        }
        int disabledRecipeSize = buf.readInt();
        for (int i = 0; i < disabledRecipeSize; ++i) {
            IRecipeStorage storage = (IRecipeStorage)StandardFactoryController.getInstance().deserialize(buf.m_130260_());
            if (storage == null) continue;
            this.disabledRecipes.add(storage);
        }
        this.maxRecipes = buf.readInt();
        this.id = buf.m_130136_(Short.MAX_VALUE);
        this.isVisible = buf.readBoolean();
    }

    @Nullable
    public JobEntry getJobEntry() {
        return this.jobEntry;
    }

    public boolean isRecipeAlterationAllowed() {
        return !this.recipeTypeSet.isEmpty();
    }

    public boolean canLearn(CraftingType type) {
        return this.getSupportedCraftingTypes().contains(type);
    }

    public Set<CraftingType> getSupportedCraftingTypes() {
        return this.recipeTypeSet;
    }

    @Deprecated
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isPageVisible() {
        return this.isVisible;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BOWindow getWindow() {
        return new WindowListRecipes(this.buildingView, "minecolonies:gui/layouthuts/layoutlistrecipes.xml", this);
    }

    @Override
    public String getIcon() {
        return this.id;
    }

    @Override
    public String getDesc() {
        return "com.minecolonies.coremod.gui.workerhuts.recipe." + this.id;
    }

    public List<IRecipeStorage> getRecipes() {
        return this.recipes;
    }

    public void removeRecipe(int index) {
        this.recipes.remove(index);
    }

    public void switchOrder(int i, int j, boolean fullMove) {
        if (fullMove) {
            if (i > j) {
                this.recipes.add(0, this.recipes.remove(i));
            } else {
                this.recipes.add(this.recipes.remove(i));
            }
        } else if (i < this.recipes.size() && j < this.recipes.size() && i >= 0 && j >= 0) {
            IRecipeStorage storage = this.recipes.get(i);
            this.recipes.set(i, this.recipes.get(j));
            this.recipes.set(j, storage);
        }
    }

    public int getMaxRecipes() {
        return this.maxRecipes;
    }

    public void openCraftingGUI() {
        BlockPos pos = this.buildingView.getPosition();
        Minecraft.m_91087_().f_91074_.m_5893_((MenuProvider)Minecraft.m_91087_().f_91073_.m_7702_(pos));
        Network.getNetwork().sendToServer(new OpenCraftingGUIMessage((AbstractBuildingView)this.buildingView, this.getProducer().getRuntimeID()));
    }

    public void toggle(int row) {
        IRecipeStorage storage = this.recipes.get(row);
        if (this.disabledRecipes.contains(storage)) {
            this.disabledRecipes.remove(storage);
        } else {
            this.disabledRecipes.add(storage);
        }
    }

    public boolean isDisabled(IRecipeStorage recipe) {
        return this.disabledRecipes.contains(recipe);
    }
}

