/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.modules;

import com.google.common.collect.Lists;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.buildings.HiringMode;
import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IAssignsCitizen;
import com.minecolonies.api.colony.buildings.modules.IBuildingEventsModule;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractAssignedCitizenModule
extends AbstractBuildingModule
implements IAssignsCitizen,
IPersistentModule,
IBuildingEventsModule {
    protected final List<ICitizenData> assignedCitizen = Lists.newArrayList();
    private HiringMode hiringMode = HiringMode.DEFAULT;

    @Override
    public boolean removeCitizen(@NotNull ICitizenData citizen) {
        if (this.assignedCitizen.contains(citizen)) {
            this.assignedCitizen.remove(citizen);
            this.markDirty();
            this.onRemoval(citizen);
            return true;
        }
        this.onRemoval(citizen);
        return false;
    }

    @Override
    public boolean assignCitizen(ICitizenData citizen) {
        if (this.assignedCitizen.contains(citizen) || this.isFull() || citizen == null) {
            return false;
        }
        this.assignedCitizen.add(citizen);
        this.onAssignment(citizen);
        this.markDirty();
        return true;
    }

    abstract void onAssignment(ICitizenData var1);

    abstract void onRemoval(ICitizenData var1);

    @Override
    public void onDestroyed() {
        for (ICitizenData citizenData : new ArrayList<ICitizenData>(this.assignedCitizen)) {
            this.removeCitizen(citizenData);
        }
    }

    @Override
    public List<ICitizenData> getAssignedCitizen() {
        return new ArrayList<ICitizenData>(this.assignedCitizen);
    }

    @Nullable
    public ICitizenData getFirstCitizen() {
        return this.assignedCitizen.isEmpty() ? null : this.assignedCitizen.get(0);
    }

    @Override
    public boolean isFull() {
        return this.assignedCitizen.size() >= this.getModuleMax();
    }

    @Override
    public boolean hasAssignedCitizen(ICitizenData citizen) {
        return this.assignedCitizen.contains(citizen);
    }

    @Override
    @Nullable
    public List<Optional<AbstractEntityCitizen>> getAssignedEntities() {
        return this.assignedCitizen.stream().filter(Objects::nonNull).map(ICitizenData::getEntity).collect(Collectors.toList());
    }

    @Override
    public final boolean hasAssignedCitizen() {
        return !this.assignedCitizen.isEmpty();
    }

    @Override
    public void serializeNBT(CompoundTag compound) {
        compound.m_128405_("buildingHiringMode", this.hiringMode.ordinal());
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        this.hiringMode = compound.m_128441_("assigned") ? HiringMode.values()[compound.m_128469_("assigned").m_128451_("buildingHiringMode")] : (compound.m_128441_(this.getModuleSerializationIdentifier()) ? HiringMode.values()[compound.m_128469_(this.getModuleSerializationIdentifier()).m_128451_("buildingHiringMode")] : HiringMode.values()[compound.m_128451_("buildingHiringMode")]);
    }

    @Override
    public void serializeToView(@NotNull FriendlyByteBuf buf) {
        super.serializeToView(buf);
        buf.writeInt(this.assignedCitizen.size());
        for (ICitizenData citizen : this.assignedCitizen) {
            buf.writeInt(citizen.getId());
        }
        buf.writeInt(this.hiringMode.ordinal());
        buf.writeInt(this.getModuleMax());
    }

    @Override
    public void setHiringMode(HiringMode hiringMode) {
        this.hiringMode = hiringMode;
        this.markDirty();
    }

    @Override
    public HiringMode getHiringMode() {
        return this.hiringMode;
    }

    @Deprecated
    protected String getModuleSerializationIdentifier() {
        return null;
    }
}

