/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony;

import com.ldtteam.structurize.storage.StructurePacks;
import com.ldtteam.structurize.storage.rendering.RenderingCache;
import com.minecolonies.api.colony.CitizenNameFile;
import com.minecolonies.api.colony.ColonyState;
import com.minecolonies.api.colony.CompactColonyReference;
import com.minecolonies.api.colony.ICitizenDataManager;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.IVisitorViewData;
import com.minecolonies.api.colony.buildings.registry.IBuildingDataManager;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.buildings.workerbuildings.ITownHallView;
import com.minecolonies.api.colony.fields.IField;
import com.minecolonies.api.colony.managers.interfaces.ICitizenManager;
import com.minecolonies.api.colony.managers.interfaces.IColonyPackageManager;
import com.minecolonies.api.colony.managers.interfaces.IEventDescriptionManager;
import com.minecolonies.api.colony.managers.interfaces.IEventManager;
import com.minecolonies.api.colony.managers.interfaces.IGraveManager;
import com.minecolonies.api.colony.managers.interfaces.IRaiderManager;
import com.minecolonies.api.colony.managers.interfaces.IRegisteredStructureManager;
import com.minecolonies.api.colony.managers.interfaces.IReproductionManager;
import com.minecolonies.api.colony.managers.interfaces.IStatisticsManager;
import com.minecolonies.api.colony.managers.interfaces.IVisitorManager;
import com.minecolonies.api.colony.permissions.ColonyPlayer;
import com.minecolonies.api.colony.permissions.IPermissions;
import com.minecolonies.api.colony.permissions.Rank;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.workorders.IWorkManager;
import com.minecolonies.api.colony.workorders.IWorkOrderView;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.api.quests.IQuestManager;
import com.minecolonies.api.research.IResearchManager;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.ColonyUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.Network;
import com.minecolonies.core.client.render.worldevent.ColonyBlueprintRenderer;
import com.minecolonies.core.colony.Colony;
import com.minecolonies.core.colony.GraveManagerView;
import com.minecolonies.core.colony.VisitorDataView;
import com.minecolonies.core.colony.buildings.modules.BuildingModules;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingTownHall;
import com.minecolonies.core.colony.managers.ResearchManager;
import com.minecolonies.core.colony.managers.StatisticsManager;
import com.minecolonies.core.colony.permissions.PermissionsView;
import com.minecolonies.core.colony.requestsystem.management.manager.StandardRequestManager;
import com.minecolonies.core.colony.workorders.AbstractWorkOrder;
import com.minecolonies.core.datalistener.CitizenNameListener;
import com.minecolonies.core.network.messages.PermissionsMessage;
import com.minecolonies.core.network.messages.server.colony.ColonyFlagChangeMessage;
import com.minecolonies.core.network.messages.server.colony.TownHallRenameMessage;
import com.minecolonies.core.quests.QuestManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BannerPatterns;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ColonyView
implements IColonyView {
    private static final int REQUEST_MANAGER_MAX_SIZE = 700000;
    private final int id;
    private final Map<Integer, IWorkOrderView> workOrders = new HashMap<Integer, IWorkOrderView>();
    private final Map<Integer, BlockPos> workOrderClaimCache = new HashMap<Integer, BlockPos>();
    private int workOrderCachedCount;
    @NotNull
    private final PermissionsView permissions = new PermissionsView();
    @NotNull
    private final Map<BlockPos, IBuildingView> buildings = new HashMap<BlockPos, IBuildingView>();
    @NotNull
    private final Set<IField> fields = new HashSet<IField>();
    @NotNull
    private final Map<Integer, ICitizenDataView> citizens = new HashMap<Integer, ICitizenDataView>();
    private Map<Integer, IVisitorViewData> visitors = new HashMap<Integer, IVisitorViewData>();
    private String name = "Unknown";
    private ResourceKey<Level> dimensionId;
    private ChatFormatting teamColonyColor = ChatFormatting.WHITE;
    private ListTag colonyFlag = new BannerPattern.Builder().m_222705_(BannerPatterns.f_222726_, DyeColor.WHITE).m_58587_();
    private BlockPos center = BlockPos.f_121853_;
    @Nullable
    private ITownHallView townHall;
    private int citizenCount = 0;
    private int citizenCountWithEmptyGuardTowers = 0;
    private boolean hasColonyWarehouse;
    private final List<BlockPos> lastSpawnPoints = new ArrayList<BlockPos>();
    private final Set<BlockPos> freePositions = new HashSet<BlockPos>();
    private final Set<Block> freeBlocks = new HashSet<Block>();
    private final Map<BlockPos, BlockState> wayPoints = new HashMap<BlockPos, BlockState>();
    private double overallHappiness = 5.0;
    private int lastContactInHours = 0;
    private IRequestManager requestManager;
    private boolean isUnderRaid;
    private Level world;
    private boolean printProgress;
    private long mercenaryLastUseTime = 0L;
    private String style = "";
    private List<CompactColonyReference> allies;
    private List<CompactColonyReference> feuds;
    private final IResearchManager researchManager;
    private boolean spiesEnabled;
    private Set<Long> ticketedChunks = new HashSet<Long>();
    private String textureStyle;
    private final IGraveManager graveManager = new GraveManagerView();
    private List<String> nameFileIds = new ArrayList<String>();
    private String nameStyle;
    private IStatisticsManager statisticManager = new StatisticsManager();
    private IQuestManager questManager;
    private int day;

    private ColonyView(int id) {
        this.id = id;
        this.researchManager = new ResearchManager(this);
        this.questManager = new QuestManager(this);
    }

    @NotNull
    public static ColonyView createFromNetwork(int id) {
        return new ColonyView(id);
    }

    public static void serializeNetworkData(@NotNull Colony colony, @NotNull FriendlyByteBuf buf, boolean hasNewSubscribers) {
        buf.m_130070_(colony.getName());
        buf.m_130070_(colony.getDimension().m_135782_().toString());
        buf.m_130064_(colony.getCenter());
        buf.writeInt(colony.getCitizenManager().getMaxCitizens());
        buf.writeInt(colony.getCitizenManager().getPotentialMaxCitizens());
        Set<Block> freeBlocks = colony.getFreeBlocks();
        Set<BlockPos> freePos = colony.getFreePositions();
        Map<BlockPos, BlockState> waypoints = colony.getWayPoints();
        buf.writeInt(freeBlocks.size());
        for (Block block : freeBlocks) {
            buf.m_130070_(ForgeRegistries.BLOCKS.getKey((Object)block).toString());
        }
        buf.writeInt(freePos.size());
        for (BlockPos blockPos : freePos) {
            buf.m_130064_(blockPos);
        }
        buf.writeDouble(colony.getOverallHappiness());
        buf.writeBoolean(colony.hasWarehouse());
        buf.writeInt(waypoints.size());
        for (Map.Entry entry : waypoints.entrySet()) {
            buf.m_130064_((BlockPos)entry.getKey());
            buf.writeInt(Block.m_49956_((BlockState)((BlockState)entry.getValue())));
        }
        buf.writeInt(colony.getLastContactInHours());
        buf.m_130070_(colony.getTextureStyleId());
        buf.m_130070_(colony.getNameStyle());
        buf.writeInt(CitizenNameListener.nameFileMap.size());
        for (String string : CitizenNameListener.nameFileMap.keySet()) {
            buf.m_130070_(string);
        }
        if (colony.getRequestManager() != null && (colony.getRequestManager().isDirty() || hasNewSubscribers)) {
            int preSize = buf.writerIndex();
            buf.writeBoolean(true);
            colony.getRequestManager().serialize(StandardFactoryController.getInstance(), buf);
            int n = buf.writerIndex();
            if (n - preSize >= 700000) {
                Log.getLogger().warn("Colony " + colony.getID() + " has a very big memory imprint, this could be a memory leak, please contact the mod author!");
            }
        } else {
            buf.writeBoolean(false);
        }
        buf.writeInt(colony.getRaiderManager().getLastSpawnPoints().size());
        for (BlockPos blockPos : colony.getRaiderManager().getLastSpawnPoints()) {
            buf.m_130064_(blockPos);
        }
        buf.writeInt(colony.getTeamColonyColor().ordinal());
        CompoundTag flagNBT = new CompoundTag();
        flagNBT.m_128365_("Patterns", (Tag)colony.getColonyFlag());
        buf.m_130079_(flagNBT);
        buf.writeLong(colony.getMercenaryUseTime());
        buf.m_130070_(colony.getStructurePack());
        buf.writeBoolean(colony.getRaiderManager().isRaided());
        buf.writeBoolean(colony.getRaiderManager().areSpiesEnabled());
        ArrayList<IColony> arrayList = new ArrayList<IColony>();
        for (ColonyPlayer colonyPlayer : colony.getPermissions().getFilteredPlayers(Rank::isColonyManager)) {
            IColony col = IColonyManager.getInstance().getIColonyByOwner(colony.getWorld(), colonyPlayer.getID());
            if (col == null) continue;
            for (ColonyPlayer owner : colony.getPermissions().getPlayersByRank(colony.getPermissions().getRankOwner())) {
                if (!col.getPermissions().getRank(owner.getID()).isColonyManager() || col.getID() == colony.getID()) continue;
                arrayList.add(col);
            }
        }
        buf.writeInt(arrayList.size());
        for (IColony iColony : arrayList) {
            buf.m_130070_(iColony.getName());
            buf.m_130064_(iColony.getCenter());
            buf.writeInt(iColony.getID());
            buf.writeBoolean(iColony.hasTownHall());
            buf.m_130070_(iColony.getDimension().m_135782_().toString());
        }
        ArrayList<IColony> feuds = new ArrayList<IColony>();
        for (ColonyPlayer player : colony.getPermissions().getFilteredPlayers(Rank::isHostile)) {
            IColony col = IColonyManager.getInstance().getIColonyByOwner(colony.getWorld(), player.getID());
            if (col == null) continue;
            for (ColonyPlayer owner : colony.getPermissions().getPlayersByRank(colony.getPermissions().getRankOwner())) {
                if (!col.getPermissions().getRank(owner.getID()).isHostile()) continue;
                feuds.add(col);
            }
        }
        buf.writeInt(feuds.size());
        for (IColony col : feuds) {
            buf.m_130070_(col.getName());
            buf.m_130064_(col.getCenter());
            buf.writeInt(col.getID());
            buf.m_130070_(col.getDimension().m_135782_().toString());
        }
        if (hasNewSubscribers || colony.isTicketedChunksDirty()) {
            buf.writeInt(colony.getTicketedChunks().size());
            for (long pos : colony.getTicketedChunks()) {
                buf.writeLong(pos);
            }
        } else {
            buf.writeInt(-1);
        }
        CompoundTag compoundTag = new CompoundTag();
        colony.getGraveManager().write(compoundTag);
        buf.m_130079_(compoundTag);
        colony.getStatisticsManager().serialize(buf, hasNewSubscribers);
        buf.m_130079_((CompoundTag)colony.getQuestManager().serializeNBT());
        buf.writeInt(colony.getDay());
    }

    @Override
    public List<BlockPos> getFreePositions() {
        return new ArrayList<BlockPos>(this.freePositions);
    }

    @Override
    public List<Block> getFreeBlocks() {
        return new ArrayList<Block>(this.freeBlocks);
    }

    @Override
    public void addFreePosition(@NotNull BlockPos pos) {
        this.freePositions.add(pos);
    }

    @Override
    public void addFreeBlock(@NotNull Block block) {
        this.freeBlocks.add(block);
    }

    @Override
    public void removeFreePosition(@NotNull BlockPos pos) {
        this.freePositions.remove(pos);
    }

    @Override
    public void removeFreeBlock(@NotNull Block block) {
        this.freeBlocks.remove(block);
    }

    @Override
    public void setCanBeAutoDeleted(boolean canBeDeleted) {
    }

    @Override
    public ResourceKey<Level> getDimension() {
        return this.dimensionId;
    }

    @Override
    public boolean isManualHiring() {
        return this.townHall != null && this.townHall.getModuleView(BuildingModules.TOWNHALL_SETTINGS).getSetting(BuildingTownHall.AUTO_HIRING_MODE).getValue() == false;
    }

    @Override
    public CompoundTag write(CompoundTag colonyCompound) {
        return new CompoundTag();
    }

    @Override
    public void read(CompoundTag compound) {
    }

    @Override
    public boolean isManualHousing() {
        return this.townHall != null && this.townHall.getModuleView(BuildingModules.TOWNHALL_SETTINGS).getSetting(BuildingTownHall.AUTO_HOUSING_MODE).getValue() == false;
    }

    @Override
    public void addWayPoint(BlockPos pos, BlockState newWayPointState) {
    }

    @Override
    public boolean isValidAttackingGuard(AbstractEntityCitizen entity) {
        return false;
    }

    @Override
    public boolean canMoveIn() {
        return this.townHall != null && this.townHall.getModuleView(BuildingModules.TOWNHALL_SETTINGS).getSetting(BuildingTownHall.MOVE_IN).getValue() == false;
    }

    @Override
    public boolean useAdditionalChildTime(int amount) {
        return false;
    }

    @Override
    public void updateHasChilds() {
    }

    @Override
    public void addLoadedChunk(long chunkPos, LevelChunk chunk) {
    }

    @Override
    public void removeLoadedChunk(long chunkPos) {
    }

    @Override
    public int getLoadedChunkCount() {
        return 0;
    }

    @Override
    public Set<Long> getLoadedChunks() {
        return null;
    }

    @Override
    public ColonyState getState() {
        return null;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public Set<Long> getTicketedChunks() {
        return this.ticketedChunks;
    }

    @Override
    public void setTextureStyle(String style) {
        this.textureStyle = style;
    }

    @Override
    public String getTextureStyleId() {
        return this.textureStyle;
    }

    @Override
    @Nullable
    public ITownHallView getTownHall() {
        return this.townHall;
    }

    @Override
    public IBuildingView getBuilding(int x, int y, int z) {
        return this.getBuilding(new BlockPos(x, y, z));
    }

    @Override
    public IBuildingView getBuilding(BlockPos buildingId) {
        return this.buildings.get(buildingId);
    }

    @Override
    @NotNull
    public Map<UUID, ColonyPlayer> getPlayers() {
        return this.permissions.getPlayers();
    }

    @Override
    public int getCitizenCount() {
        return this.citizenCount;
    }

    @Override
    public int getCitizenCountLimit() {
        return this.citizenCountWithEmptyGuardTowers;
    }

    @Override
    public Map<Integer, ICitizenDataView> getCitizens() {
        return Collections.unmodifiableMap(this.citizens);
    }

    @Override
    public Collection<IWorkOrderView> getWorkOrders() {
        return Collections.unmodifiableCollection(this.workOrders.values());
    }

    @Override
    public ICitizenDataView getCitizen(int id) {
        if (id > 0) {
            return this.citizens.get(id);
        }
        return this.visitors.get(id);
    }

    @Override
    @Nullable
    public IMessage handleColonyViewMessage(@NotNull FriendlyByteBuf buf, @NotNull Level world, boolean isNewSubscription) {
        this.world = world;
        this.name = buf.m_130136_(Short.MAX_VALUE);
        this.dimensionId = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(buf.m_130136_(Short.MAX_VALUE)));
        this.center = buf.m_130135_();
        this.citizenCount = buf.readInt();
        this.citizenCountWithEmptyGuardTowers = buf.readInt();
        if (isNewSubscription) {
            this.citizens.clear();
            this.townHall = null;
            this.buildings.clear();
        }
        this.freePositions.clear();
        this.freeBlocks.clear();
        this.wayPoints.clear();
        this.lastSpawnPoints.clear();
        this.nameFileIds.clear();
        int blockListSize = buf.readInt();
        for (int i = 0; i < blockListSize; ++i) {
            this.freeBlocks.add((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(buf.m_130136_(Short.MAX_VALUE))));
        }
        int posListSize = buf.readInt();
        for (int i = 0; i < posListSize; ++i) {
            this.freePositions.add(buf.m_130135_());
        }
        this.overallHappiness = buf.readDouble();
        this.hasColonyWarehouse = buf.readBoolean();
        int wayPointListSize = buf.readInt();
        for (int i = 0; i < wayPointListSize; ++i) {
            this.wayPoints.put(buf.m_130135_(), Block.m_49803_((int)buf.readInt()));
        }
        this.lastContactInHours = buf.readInt();
        this.textureStyle = buf.m_130136_(Short.MAX_VALUE);
        this.nameStyle = buf.m_130136_(Short.MAX_VALUE);
        int nameFileIdSize = buf.readInt();
        for (int i = 0; i < nameFileIdSize; ++i) {
            this.nameFileIds.add(buf.m_130136_(Short.MAX_VALUE));
        }
        if (buf.readBoolean()) {
            this.requestManager = new StandardRequestManager(this);
            this.requestManager.deserialize(StandardFactoryController.getInstance(), buf);
        }
        int barbSpawnListSize = buf.readInt();
        for (int i = 0; i < barbSpawnListSize; ++i) {
            this.lastSpawnPoints.add(buf.m_130135_());
        }
        Collections.reverse(this.lastSpawnPoints);
        this.teamColonyColor = ChatFormatting.values()[buf.readInt()];
        this.colonyFlag = buf.m_130260_().m_128437_("Patterns", 10);
        this.mercenaryLastUseTime = buf.readLong();
        this.style = buf.m_130136_(Short.MAX_VALUE);
        if (isNewSubscription && StructurePacks.hasPack((String)this.style) && RenderingCache.getOrCreateBlueprintPreviewData((String)"blueprint").getBlueprint() == null && this.isCoordInColony(world, Minecraft.m_91087_().f_91074_.m_20183_())) {
            StructurePacks.selectedPack = StructurePacks.getStructurePack((String)this.style);
        }
        this.isUnderRaid = buf.readBoolean();
        this.spiesEnabled = buf.readBoolean();
        this.allies = new ArrayList<CompactColonyReference>();
        this.feuds = new ArrayList<CompactColonyReference>();
        int noOfAllies = buf.readInt();
        for (int i = 0; i < noOfAllies; ++i) {
            this.allies.add(new CompactColonyReference(buf.m_130136_(Short.MAX_VALUE), buf.m_130135_(), buf.readInt(), buf.readBoolean(), (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(buf.m_130136_(Short.MAX_VALUE)))));
        }
        int noOfFeuds = buf.readInt();
        for (int i = 0; i < noOfFeuds; ++i) {
            this.feuds.add(new CompactColonyReference(buf.m_130136_(Short.MAX_VALUE), buf.m_130135_(), buf.readInt(), false, (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(buf.m_130136_(Short.MAX_VALUE)))));
        }
        int ticketChunkCount = buf.readInt();
        if (ticketChunkCount != -1) {
            this.ticketedChunks = new HashSet<Long>(ticketChunkCount);
            for (int i = 0; i < ticketChunkCount; ++i) {
                this.ticketedChunks.add(buf.readLong());
            }
        }
        this.graveManager.read(buf.m_130260_());
        this.statisticManager.deserialize(buf);
        this.questManager.deserializeNBT((Tag)buf.m_130260_());
        this.day = buf.readInt();
        return null;
    }

    @Override
    @Nullable
    public IMessage handlePermissionsViewMessage(@NotNull FriendlyByteBuf buf) {
        this.permissions.deserialize(buf);
        return null;
    }

    @Override
    @Nullable
    public IMessage handleColonyViewWorkOrderMessage(FriendlyByteBuf buf) {
        boolean claimsChanged = false;
        this.workOrders.clear();
        int amount = buf.readInt();
        for (int i = 0; i < amount; ++i) {
            @Nullable IWorkOrderView workOrder = AbstractWorkOrder.createWorkOrderView(buf);
            if (workOrder == null) continue;
            this.workOrders.put(workOrder.getId(), workOrder);
            BlockPos oldClaimedBy = this.workOrderClaimCache.put(workOrder.getId(), workOrder.getClaimedBy());
            claimsChanged |= !Objects.equals(workOrder.getClaimedBy(), oldClaimedBy);
        }
        if (claimsChanged || this.workOrders.size() != this.workOrderCachedCount) {
            this.workOrderCachedCount = this.workOrders.size();
            ColonyBlueprintRenderer.invalidateCache();
        }
        return null;
    }

    @Override
    @Nullable
    public IMessage handleColonyViewCitizensMessage(int id, FriendlyByteBuf buf) {
        ICitizenDataView citizen = ICitizenDataManager.getInstance().createFromNetworkData(id, buf, this);
        if (citizen != null) {
            this.citizens.put(citizen.getId(), citizen);
        }
        return null;
    }

    @Override
    public void handleColonyViewVisitorMessage(FriendlyByteBuf visitorBuf, boolean refresh) {
        HashMap<Integer, IVisitorViewData> visitorCache = new HashMap<Integer, IVisitorViewData>(this.visitors);
        if (refresh) {
            this.visitors.clear();
        }
        int i = visitorBuf.readInt();
        for (int j = 0; j < i; ++j) {
            int id = visitorBuf.readInt();
            IVisitorViewData dataView = visitorCache.containsKey(id) ? (IVisitorViewData)visitorCache.get(id) : new VisitorDataView(id, this);
            dataView.deserialize(visitorBuf);
            this.visitors.put(dataView.getId(), dataView);
        }
    }

    @Override
    @Nullable
    public IMessage handleColonyViewRemoveCitizenMessage(int citizen) {
        this.citizens.remove(citizen);
        return null;
    }

    @Override
    @Nullable
    public IMessage handleColonyViewRemoveBuildingMessage(BlockPos buildingId) {
        IBuildingView building = this.buildings.remove(buildingId);
        if (this.townHall == building) {
            this.townHall = null;
        }
        return null;
    }

    @Override
    @Nullable
    public IMessage handleColonyViewRemoveWorkOrderMessage(int workOrderId) {
        this.workOrders.remove(workOrderId);
        return null;
    }

    @Override
    @Nullable
    public IMessage handleColonyBuildingViewMessage(BlockPos buildingId, @NotNull FriendlyByteBuf buf) {
        if (this.buildings.containsKey(buildingId)) {
            buf.m_130136_(Short.MAX_VALUE);
            this.buildings.get(buildingId).deserialize(buf);
        } else {
            @Nullable IBuildingView building = IBuildingDataManager.getInstance().createViewFrom(this, buildingId, buf);
            if (building != null) {
                this.buildings.put(building.getID(), building);
                if (building instanceof BuildingTownHall.View) {
                    this.townHall = (ITownHallView)building;
                }
            }
        }
        return null;
    }

    @Override
    public void handleColonyViewResearchManagerUpdate(CompoundTag compoundTag) {
        this.researchManager.readFromNBT(compoundTag);
    }

    @Override
    public void handleColonyFieldViewUpdateMessage(Set<IField> fields) {
        this.fields.clear();
        this.fields.addAll(fields);
    }

    @Override
    @NotNull
    public List<IField> getFields(Predicate<IField> matcher) {
        return this.fields.stream().filter(matcher).toList();
    }

    @Override
    @Nullable
    public IField getField(Predicate<IField> matcher) {
        return this.getFields(matcher).stream().findFirst().orElse(null);
    }

    @Override
    public void addPlayer(String player) {
        Network.getNetwork().sendToServer(new PermissionsMessage.AddPlayer(this, player));
    }

    @Override
    public void removePlayer(UUID player) {
        Network.getNetwork().sendToServer(new PermissionsMessage.RemovePlayer(this, player));
    }

    @Override
    public double getOverallHappiness() {
        return this.overallHappiness;
    }

    @Override
    public BlockPos getCenter() {
        return this.center;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ChatFormatting getTeamColonyColor() {
        return this.teamColonyColor;
    }

    @Override
    public ListTag getColonyFlag() {
        return this.colonyFlag;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        Network.getNetwork().sendToServer(new TownHallRenameMessage(this, name));
    }

    @Override
    @NotNull
    public IPermissions getPermissions() {
        return this.permissions;
    }

    @Override
    public boolean isCoordInColony(@NotNull Level w, @NotNull BlockPos pos) {
        LevelChunk chunk = w.m_46745_(pos);
        return ColonyUtils.getOwningColony(chunk) == this.getID();
    }

    @Override
    public long getDistanceSquared(@NotNull BlockPos pos) {
        return BlockPosUtil.getDistanceSquared2D(this.center, pos);
    }

    @Override
    public boolean hasTownHall() {
        return this.townHall != null;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public boolean hasWarehouse() {
        return this.hasColonyWarehouse;
    }

    @Override
    public boolean hasBuilding(String name, int level, boolean singleBuilding) {
        int sum = 0;
        for (IBuildingView building : this.buildings.values()) {
            if (!building.getBuildingType().getRegistryName().m_135815_().equalsIgnoreCase(name) || !(singleBuilding ? building.getBuildingLevel() >= level : (sum += building.getBuildingLevel()) >= level)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDay() {
        return false;
    }

    @Override
    public PlayerTeam getTeam() {
        return this.world.m_6188_().m_83489_(this.getTeamName());
    }

    @Override
    public int getLastContactInHours() {
        return this.lastContactInHours;
    }

    @Override
    public Level getWorld() {
        return this.world;
    }

    @Override
    @NotNull
    public IRequestManager getRequestManager() {
        return this.requestManager;
    }

    @Override
    public void markDirty() {
    }

    @Override
    public boolean canBeAutoDeleted() {
        return false;
    }

    @Override
    @Nullable
    public IRequester getRequesterBuildingForPosition(@NotNull BlockPos pos) {
        return this.getBuilding(pos);
    }

    @Override
    public void removeVisitingPlayer(Player player) {
    }

    @Override
    @NotNull
    public List<Player> getMessagePlayerEntities() {
        return new ArrayList<Player>();
    }

    @Override
    public void addVisitingPlayer(Player player) {
    }

    @Override
    public void onWorldLoad(@NotNull Level w) {
    }

    @Override
    public void onWorldUnload(@NotNull Level w) {
    }

    @Override
    public void onServerTick(@NotNull TickEvent.ServerTickEvent event) {
    }

    @Override
    @NotNull
    public IWorkManager getWorkManager() {
        return null;
    }

    @Override
    public void onWorldTick(@NotNull TickEvent.LevelTickEvent event) {
    }

    @Override
    public Map<BlockPos, BlockState> getWayPoints() {
        return this.wayPoints;
    }

    @Override
    public List<BlockPos> getLastSpawnPoints() {
        return new ArrayList<BlockPos>(this.lastSpawnPoints);
    }

    @Override
    public boolean isRemote() {
        return true;
    }

    @Override
    public CompoundTag getColonyTag() {
        return null;
    }

    @Override
    public boolean isColonyUnderAttack() {
        return false;
    }

    @Override
    public boolean isValidAttackingPlayer(Player entity) {
        return false;
    }

    @Override
    public void addGuardToAttackers(AbstractEntityCitizen entityCitizen, Player followPlayer) {
    }

    @Override
    public void setColonyColor(ChatFormatting color) {
    }

    @Override
    public void setColonyFlag(ListTag colonyFlag) {
        this.colonyFlag = colonyFlag;
        Network.getNetwork().sendToServer(new ColonyFlagChangeMessage(this, colonyFlag));
    }

    @Override
    public List<IBuildingView> getBuildings() {
        return new ArrayList<IBuildingView>(this.buildings.values());
    }

    @Override
    @NotNull
    public List<Player> getImportantMessageEntityPlayers() {
        return new ArrayList<Player>();
    }

    @Override
    public String getStructurePack() {
        return this.style;
    }

    @Override
    public void setStructurePack(String style) {
        this.style = style;
    }

    @Override
    public IRegisteredStructureManager getBuildingManager() {
        return null;
    }

    @Override
    public IGraveManager getGraveManager() {
        return this.graveManager;
    }

    @Override
    public ICitizenManager getCitizenManager() {
        return null;
    }

    @Override
    public IVisitorManager getVisitorManager() {
        return null;
    }

    @Override
    public IRaiderManager getRaiderManager() {
        return null;
    }

    @Override
    public IEventManager getEventManager() {
        return null;
    }

    @Override
    public IReproductionManager getReproductionManager() {
        return null;
    }

    @Override
    public IEventDescriptionManager getEventDescriptionManager() {
        return null;
    }

    @Override
    public IColonyPackageManager getPackageManager() {
        return null;
    }

    @Override
    public boolean isRaiding() {
        return this.isUnderRaid;
    }

    @Override
    public long getMercenaryUseTime() {
        return this.mercenaryLastUseTime;
    }

    @Override
    public void usedMercenaries() {
        this.mercenaryLastUseTime = this.world.m_46467_();
    }

    @Override
    public List<CompactColonyReference> getAllies() {
        return this.allies;
    }

    @Override
    public List<CompactColonyReference> getFeuds() {
        return this.feuds;
    }

    @Override
    public IResearchManager getResearchManager() {
        return this.researchManager;
    }

    @Override
    public boolean areSpiesEnabled() {
        return this.spiesEnabled;
    }

    @Override
    public ICitizenDataView getVisitor(int citizenId) {
        return this.visitors.get(citizenId);
    }

    @Override
    public void setNameStyle(String style) {
        this.nameStyle = style;
        this.markDirty();
    }

    @Override
    public String getNameStyle() {
        return this.nameStyle;
    }

    @Override
    public List<String> getNameFileIds() {
        return this.nameFileIds;
    }

    @Override
    public CitizenNameFile getCitizenNameFile() {
        return CitizenNameListener.nameFileMap.getOrDefault(this.nameStyle, CitizenNameListener.nameFileMap.get("default"));
    }

    @Override
    public IStatisticsManager getStatisticsManager() {
        return this.statisticManager;
    }

    @Override
    public int getDay() {
        return this.day;
    }

    @Override
    public IQuestManager getQuestManager() {
        return this.questManager;
    }
}

