/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.containers;

import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.crafting.ModCraftingTypes;
import com.minecolonies.api.crafting.registry.CraftingType;
import com.minecolonies.api.inventory.container.ContainerCrafting;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.core.Network;
import com.minecolonies.core.colony.buildings.moduleviews.CraftingModuleView;
import com.minecolonies.core.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.core.network.messages.server.colony.building.worker.AddRemoveRecipeMessage;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class WindowCrafting
extends AbstractContainerScreen<ContainerCrafting> {
    private static final ResourceLocation CRAFTING_TABLE_GUI_TEXTURES = new ResourceLocation("minecolonies", "textures/gui/crafting2x2.png");
    private static final ResourceLocation CRAFTING_TABLE_GUI_TEXTURES3X3 = new ResourceLocation("minecolonies", "textures/gui/crafting3x3.png");
    private static final int BUTTON_X_OFFSET = 1;
    private static final int BUTTON_Y_POS = 170;
    private static final int BUTTON_WIDTH = 150;
    private static final int BUTTON_HEIGHT = 20;
    private static final int GUI_COLOR = 0x404040;
    private static final int X_OFFSET = 97;
    private static final int Y_OFFSET = 8;
    private static final int CRAFTING_GRID_SIZE = 4;
    private static final int MAX_CRAFTING_GRID_SIZE = 9;
    private final AbstractBuildingView building;
    private final boolean completeCrafting;
    private final CraftingModuleView module;

    public WindowCrafting(ContainerCrafting container, Inventory playerInventory, Component iTextComponent) {
        super((AbstractContainerMenu)container, playerInventory, iTextComponent);
        this.building = (AbstractBuildingView)IColonyManager.getInstance().getBuildingView((ResourceKey<Level>)playerInventory.f_35978_.f_19853_.m_46472_(), container.getPos());
        this.module = (CraftingModuleView)this.building.getModuleView(container.getModuleId());
        this.completeCrafting = this.module.canLearn((CraftingType)ModCraftingTypes.LARGE_CRAFTING.get());
    }

    @NotNull
    public AbstractBuildingView getBuildingView() {
        return this.building;
    }

    public boolean isCompleteCrafting() {
        return this.completeCrafting;
    }

    protected void m_7856_() {
        super.m_7856_();
        MutableComponent buttonDisplay = Component.m_237115_((String)(this.module.canLearn((CraftingType)ModCraftingTypes.SMALL_CRAFTING.get()) ? "gui.done" : "com.minecolonies.coremod.gui.recipe.full"));
        Button doneButton = new Button.Builder((Component)buttonDisplay, (Button.OnPress)new OnButtonPress()).m_252794_(this.f_97735_ + 1, this.f_97736_ + 170).m_253046_(150, 20).m_253136_();
        this.m_142416_((GuiEventListener)doneButton);
        if (!this.module.canLearn((CraftingType)ModCraftingTypes.SMALL_CRAFTING.get())) {
            doneButton.f_93623_ = false;
        }
    }

    protected void m_280003_(@NotNull GuiGraphics stack, int mouseX, int mouseY) {
        stack.m_280056_(this.f_96547_, Component.m_237115_((String)"container.crafting").getString(), 97, 8, 0x404040, false);
    }

    protected void m_7286_(@NotNull GuiGraphics stack, float partialTicks, int mouseX, int mouseY) {
        ResourceLocation texture = this.completeCrafting ? CRAFTING_TABLE_GUI_TEXTURES3X3 : CRAFTING_TABLE_GUI_TEXTURES;
        stack.m_280218_(texture, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
    }

    public void m_88315_(@NotNull GuiGraphics stack, int x, int y, float z) {
        this.m_280273_(stack);
        super.m_88315_(stack, x, y, z);
        this.m_280072_(stack, x, y);
    }

    public class OnButtonPress
    implements Button.OnPress {
        public void m_93750_(Button button) {
            if (WindowCrafting.this.module.canLearn((CraftingType)ModCraftingTypes.SMALL_CRAFTING.get())) {
                LinkedList<ItemStorage> input = new LinkedList<ItemStorage>();
                for (int i = 0; i < (WindowCrafting.this.completeCrafting ? 9 : 4); ++i) {
                    ItemStack stack = ((ContainerCrafting)((WindowCrafting)WindowCrafting.this).f_97732_).craftMatrix.m_8020_(i);
                    ItemStack copy = stack.m_41777_();
                    ItemStackUtils.setSize(copy, 1);
                    input.add(new ItemStorage(copy));
                }
                ItemStack primaryOutput = ((ContainerCrafting)((WindowCrafting)WindowCrafting.this).f_97732_).craftResult.m_8020_(0).m_41777_();
                List<ItemStack> secondaryOutputs = ((ContainerCrafting)WindowCrafting.this.f_97732_).getRemainingItems();
                if (!ItemStackUtils.isEmpty(primaryOutput)) {
                    Network.getNetwork().sendToServer(new AddRemoveRecipeMessage((IBuildingView)WindowCrafting.this.building, input, WindowCrafting.this.completeCrafting ? 3 : 2, primaryOutput, secondaryOutputs, false, WindowCrafting.this.module.getProducer().getRuntimeID()));
                }
            }
        }
    }
}

