/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface OptionalPredicate<T> {
    @NotNull
    public Optional<Boolean> test(T var1);

    @NotNull
    public static <T> OptionalPredicate<T> empty() {
        return t -> Optional.empty();
    }

    @NotNull
    public static <T> OptionalPredicate<T> of(@NotNull Predicate<T> predicate) {
        return t -> Optional.of(predicate.test(t));
    }

    @NotNull
    public static <T> OptionalPredicate<T> passIf(@NotNull Predicate<T> predicate) {
        return t -> predicate.test(t) ? Optional.of(true) : Optional.empty();
    }

    @NotNull
    public static <T> OptionalPredicate<T> failIf(@NotNull Predicate<T> predicate) {
        return t -> predicate.test(t) ? Optional.of(false) : Optional.empty();
    }

    @NotNull
    default public Predicate<T> orElse(boolean fallback) {
        return t -> this.test(t).orElse(fallback);
    }

    @NotNull
    default public OptionalPredicate<T> combine(@NotNull OptionalPredicate<T> other) {
        return t -> OptionalPredicate.combine(this.test(t), () -> other.test(t));
    }

    public static <X> Optional<X> combine(@NotNull Optional<X> a, @NotNull Supplier<Optional<X>> b) {
        return a.isPresent() ? a : b.get();
    }

    @NotNull
    default public OptionalPredicate<T> negate() {
        return t -> this.test(t).map(b -> b == false);
    }

    @NotNull
    default public OptionalPredicate<T> and(@NotNull OptionalPredicate<T> other) {
        return t -> {
            Optional<Boolean> lhs = this.test(t);
            if (lhs.isPresent() && !lhs.get().booleanValue()) {
                return lhs;
            }
            Optional<Boolean> rhs = other.test(t);
            return rhs.isPresent() ? rhs : lhs;
        };
    }

    @NotNull
    default public OptionalPredicate<T> or(@NotNull OptionalPredicate<T> other) {
        return t -> {
            Optional<Boolean> lhs = this.test(t);
            if (lhs.isPresent() && lhs.get().booleanValue()) {
                return lhs;
            }
            Optional<Boolean> rhs = other.test(t);
            return rhs.isPresent() ? rhs : lhs;
        };
    }
}

