/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.ChunkCapData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.Nullable;

public final class ColonyUtils {
    private ColonyUtils() {
    }

    public static Tuple<BlockPos, BlockPos> calculateCorners(BlockPos pos, Level world, Blueprint blueprint, int rotation, boolean isMirrored) {
        if (blueprint == null) {
            return new Tuple((Object)pos, (Object)pos);
        }
        blueprint.rotateWithMirror(BlockPosUtil.getRotationFromRotations(rotation), isMirrored ? Mirror.FRONT_BACK : Mirror.NONE, world);
        BlockPos zeroPos = pos.m_121996_((Vec3i)blueprint.getPrimaryBlockOffset());
        BlockPos pos1 = new BlockPos(zeroPos.m_123341_(), zeroPos.m_123342_(), zeroPos.m_123343_());
        BlockPos pos2 = new BlockPos(zeroPos.m_123341_() + blueprint.getSizeX() - 1, zeroPos.m_123342_() + blueprint.getSizeY() - 1, zeroPos.m_123343_() + blueprint.getSizeZ() - 1);
        return new Tuple((Object)pos1, (Object)pos2);
    }

    public static int getOwningColony(LevelChunk chunk) {
        IColonyTagCapability cap = chunk.getCapability(IColony.CLOSE_COLONY_CAP, null).resolve().orElse(null);
        return cap == null ? 0 : cap.getOwningColony();
    }

    public static Map<Integer, Set<BlockPos>> getAllClaimingBuildings(LevelChunk chunk) {
        IColonyTagCapability cap = chunk.getCapability(IColony.CLOSE_COLONY_CAP, null).resolve().orElse(null);
        return cap == null ? new HashMap() : cap.getAllClaimingBuildings();
    }

    public static List<Integer> getStaticClaims(LevelChunk chunk) {
        IColonyTagCapability cap = chunk.getCapability(IColony.CLOSE_COLONY_CAP, null).resolve().orElse(null);
        return cap == null ? new ArrayList() : cap.getStaticClaimColonies();
    }

    @Nullable
    public static ChunkCapData getChunkCapData(LevelChunk chunk) {
        IColonyTagCapability cap = chunk.getCapability(IColony.CLOSE_COLONY_CAP, null).resolve().orElse(null);
        return cap == null ? new ChunkCapData(chunk.m_7697_().f_45578_, chunk.m_7697_().f_45579_) : new ChunkCapData(chunk.m_7697_().f_45578_, chunk.m_7697_().f_45579_, cap.getOwningColony(), cap.getStaticClaimColonies(), cap.getAllClaimingBuildings());
    }
}

