/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.quests.registries;

import com.google.gson.JsonObject;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.quests.IQuestDialogueAnswer;
import com.minecolonies.api.quests.IQuestObjectiveTemplate;
import com.minecolonies.api.quests.IQuestRewardTemplate;
import com.minecolonies.api.quests.IQuestTriggerTemplate;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class QuestRegistries {
    public static ResourceLocation ITEM_REWARD_ID = new ResourceLocation("minecolonies", "item");
    public static ResourceLocation SKILL_REWARD_ID = new ResourceLocation("minecolonies", "skill");
    public static ResourceLocation RESEARCH_REWARD_ID = new ResourceLocation("minecolonies", "research");
    public static ResourceLocation RAID_REWARD_ID = new ResourceLocation("minecolonies", "raid");
    public static ResourceLocation RELATIONSHIP_REWARD_ID = new ResourceLocation("minecolonies", "relationship");
    public static ResourceLocation HAPPINESS_REWARD_ID = new ResourceLocation("minecolonies", "happiness");
    public static ResourceLocation UNLOCK_QUEST_REWARD_ID = new ResourceLocation("minecolonies", "unlockquest");
    public static ResourceLocation QUEST_REPUTATION_REWARD_ID = new ResourceLocation("minecolonies", "questreputation");
    public static ResourceLocation DIALOGUE_OBJECTIVE_ID = new ResourceLocation("minecolonies", "dialogue");
    public static ResourceLocation BREAKBLOCK_OBJECTIVE_ID = new ResourceLocation("minecolonies", "breakblock");
    public static ResourceLocation DELIVERY_OBJECTIVE_ID = new ResourceLocation("minecolonies", "delivery");
    public static ResourceLocation KILLENTITY_OBJECTIVE_ID = new ResourceLocation("minecolonies", "killentity");
    public static ResourceLocation PLACEBLOCK_OBJECTIVE_ID = new ResourceLocation("minecolonies", "placeblock");
    public static ResourceLocation BUILD_BUILDING_OBJECTIVE_ID = new ResourceLocation("minecolonies", "buildbuilding");
    public static ResourceLocation STATE_TRIGGER_ID = new ResourceLocation("minecolonies", "state");
    public static ResourceLocation RANDOM_TRIGGER_ID = new ResourceLocation("minecolonies", "random");
    public static ResourceLocation CITIZEN_TRIGGER_ID = new ResourceLocation("minecolonies", "citizen");
    public static ResourceLocation UNLOCK_TRIGGER_ID = new ResourceLocation("minecolonies", "unlock");
    public static ResourceLocation QUEST_REPUTATION_TRIGGER_ID = new ResourceLocation("minecolonies", "questreputation");
    public static ResourceLocation WORLD_DIFFICULTY_TRIGGER_ID = new ResourceLocation("minecolonies", "difficulty");
    public static ResourceLocation DIALOGUE_ANSWER_ID = new ResourceLocation("minecolonies", "dialogue");
    public static ResourceLocation RETURN_ANSWER_ID = new ResourceLocation("minecolonies", "return");
    public static ResourceLocation CANCEL_ANSWER_ID = new ResourceLocation("minecolonies", "cancel");
    public static ResourceLocation GOTO_ANSWER_ID = new ResourceLocation("minecolonies", "advanceobjective");
    public static RegistryObject<RewardEntry> itemReward;
    public static RegistryObject<RewardEntry> skillReward;
    public static RegistryObject<RewardEntry> researchReward;
    public static RegistryObject<RewardEntry> raidReward;
    public static RegistryObject<RewardEntry> relationshipReward;
    public static RegistryObject<RewardEntry> happinessReward;
    public static RegistryObject<RewardEntry> unlockQuestReward;
    public static RegistryObject<RewardEntry> questReputationReward;
    public static RegistryObject<ObjectiveEntry> dialogueObjective;
    public static RegistryObject<ObjectiveEntry> breakBlockObjective;
    public static RegistryObject<ObjectiveEntry> deliveryObjective;
    public static RegistryObject<ObjectiveEntry> killEntityObjective;
    public static RegistryObject<ObjectiveEntry> placeBlockObjective;
    public static RegistryObject<ObjectiveEntry> buildBuildingObjective;
    public static RegistryObject<TriggerEntry> stateTrigger;
    public static RegistryObject<TriggerEntry> randomTrigger;
    public static RegistryObject<TriggerEntry> citizenTrigger;
    public static RegistryObject<TriggerEntry> unlockTrigger;
    public static RegistryObject<TriggerEntry> questReputationTrigger;
    public static RegistryObject<TriggerEntry> worldDifficultyTrigger;
    public static RegistryObject<DialogueAnswerEntry> dialogueAnswerResult;
    public static RegistryObject<DialogueAnswerEntry> returnAnswerResult;
    public static RegistryObject<DialogueAnswerEntry> cancelAnswerResult;
    public static RegistryObject<DialogueAnswerEntry> gotoAnswerResult;

    static IForgeRegistry<RewardEntry> getQuestRewardsRegistry() {
        return IMinecoloniesAPI.getInstance().getQuestRewardRegistry();
    }

    static IForgeRegistry<ObjectiveEntry> getQuestObjectiveRegistry() {
        return IMinecoloniesAPI.getInstance().getQuestObjectiveRegistry();
    }

    static IForgeRegistry<TriggerEntry> getQuestTriggerRegistry() {
        return IMinecoloniesAPI.getInstance().getQuestTriggerRegistry();
    }

    static IForgeRegistry<DialogueAnswerEntry> getDialogueAnswerResultRegistry() {
        return IMinecoloniesAPI.getInstance().getQuestDialogueAnswerRegistry();
    }

    public static class DialogueAnswerEntry {
        private final Function<JsonObject, IQuestDialogueAnswer> producer;

        public DialogueAnswerEntry(Function<JsonObject, IQuestDialogueAnswer> productionFunction) {
            this.producer = productionFunction;
        }

        public IQuestDialogueAnswer produce(JsonObject jsonObject) {
            return this.producer.apply(jsonObject);
        }
    }

    public static class TriggerEntry {
        private final Function<JsonObject, IQuestTriggerTemplate> producer;

        public TriggerEntry(Function<JsonObject, IQuestTriggerTemplate> productionFunction) {
            this.producer = productionFunction;
        }

        public IQuestTriggerTemplate produce(JsonObject jsonObject) {
            return this.producer.apply(jsonObject);
        }
    }

    public static class ObjectiveEntry {
        private final Function<JsonObject, IQuestObjectiveTemplate> producer;

        public ObjectiveEntry(Function<JsonObject, IQuestObjectiveTemplate> productionFunction) {
            this.producer = productionFunction;
        }

        public IQuestObjectiveTemplate produce(JsonObject jsonObject) {
            return this.producer.apply(jsonObject);
        }
    }

    public static class RewardEntry {
        private final Function<JsonObject, IQuestRewardTemplate> producer;

        public RewardEntry(Function<JsonObject, IQuestRewardTemplate> productionFunction) {
            this.producer = productionFunction;
        }

        public IQuestRewardTemplate produce(JsonObject jsonObject) {
            return this.producer.apply(jsonObject);
        }
    }
}

