/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.inventory.container;

import com.minecolonies.api.colony.ICitizen;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.entity.ai.workers.util.GuardGear;
import com.minecolonies.api.entity.ai.workers.util.GuardGearBuilder;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.inventory.ModContainers;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.GuardConstants;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class ContainerCitizenInventory
extends AbstractContainerMenu {
    private final Inventory playerInventory;
    private final int inventorySize;
    private ICitizen citizenData;
    private Optional<? extends Entity> entity = Optional.empty();
    private String displayName;

    public static ContainerCitizenInventory fromFriendlyByteBuf(int windowId, Inventory inv, FriendlyByteBuf packetBuffer) {
        int colonyId = packetBuffer.m_130242_();
        int citizenId = packetBuffer.m_130242_();
        return new ContainerCitizenInventory(windowId, inv, colonyId, citizenId);
    }

    public ContainerCitizenInventory(int windowId, Inventory inv, int colonyId, final int citizenId) {
        super((MenuType)ModContainers.citizenInv.get(), windowId);
        int i;
        int j;
        BlockPos workBuilding;
        InventoryCitizen inventory;
        this.playerInventory = inv;
        final IColony colony = inv.f_35978_.m_9236_().f_46443_ ? IColonyManager.getInstance().getColonyView(colonyId, (ResourceKey<Level>)inv.f_35978_.m_9236_().m_46472_()) : IColonyManager.getInstance().getColonyByWorld(colonyId, inv.f_35978_.m_9236_());
        if (colony == null) {
            this.inventorySize = 0;
            return;
        }
        int workBuildingLevel = 0;
        if (inv.f_35978_.m_9236_().f_46443_) {
            data = ((IColonyView)colony).getCitizen(citizenId);
            this.entity = Optional.of(inv.f_35978_.f_19853_.m_6815_(data.getEntityId()));
            this.citizenData = data;
            inventory = data.getInventory();
            this.displayName = data.getName();
            workBuilding = data.getWorkBuilding();
            if (workBuilding != null) {
                workBuildingLevel = ((IColonyView)colony).getBuilding(workBuilding).getBuildingLevel();
            }
        } else {
            data = citizenId > 0 ? colony.getCitizenManager().getCivilian(citizenId) : (ICitizenData)colony.getVisitorManager().getCivilian(citizenId);
            this.entity = data.getEntity();
            this.citizenData = data;
            inventory = data.getInventory();
            this.displayName = data.getName();
            BlockPos blockPos = workBuilding = data.getWorkBuilding() == null ? null : data.getWorkBuilding().getID();
            if (workBuilding != null) {
                workBuildingLevel = data.getWorkBuilding().getBuildingLevel();
            }
        }
        this.inventorySize = inventory.getSlots() / 9;
        int size = inventory.getSlots();
        int columns = this.inventorySize <= 8 ? 9 : size / 8 + 1;
        int extraOffset = (this.inventorySize <= 8 ? 0 : 2) + 1;
        int newOffset = 5;
        int index = 0;
        final List guardGear = switch (workBuildingLevel) {
            case 5 -> GuardGearBuilder.buildGearForLevel(3, Integer.MAX_VALUE, GuardConstants.LEATHER_BUILDING_LEVEL_RANGE, GuardConstants.DIA_BUILDING_LEVEL_RANGE);
            case 4 -> GuardGearBuilder.buildGearForLevel(2, 4, GuardConstants.LEATHER_BUILDING_LEVEL_RANGE, GuardConstants.DIA_BUILDING_LEVEL_RANGE);
            case 3 -> GuardGearBuilder.buildGearForLevel(0, 3, GuardConstants.LEATHER_BUILDING_LEVEL_RANGE, GuardConstants.IRON_BUILDING_LEVEL_RANGE);
            case 2 -> GuardGearBuilder.buildGearForLevel(0, 2, GuardConstants.LEATHER_BUILDING_LEVEL_RANGE, GuardConstants.CHAIN_BUILDING_LEVEL_RANGE);
            case 1 -> GuardGearBuilder.buildGearForLevel(0, 1, GuardConstants.LEATHER_BUILDING_LEVEL_RANGE, GuardConstants.GOLD_BUILDING_LEVEL_RANGE);
            default -> Collections.emptyList();
        };
        for (j = 0; j < Math.min(this.inventorySize, 8); ++j) {
            for (int k = 0; k < columns; ++k) {
                if (index >= size) continue;
                this.m_38897_((Slot)new SlotItemHandler((IItemHandler)inventory, index, 8 + k * 18, 23 + j * 18){

                    public void m_5852_(@NotNull ItemStack stack) {
                        if (workBuilding != null && !ContainerCitizenInventory.this.playerInventory.f_35978_.m_9236_().f_46443_ && !ItemStackUtils.isEmpty(stack)) {
                            IBuilding building = colony.getBuildingManager().getBuilding(workBuilding);
                            ICitizenData citizenData = colony.getCitizenManager().getCivilian(citizenId);
                            building.overruleNextOpenRequestOfCitizenWithStack(citizenData, stack);
                        }
                        super.m_5852_(stack);
                    }
                });
                ++index;
            }
        }
        index = 3;
        for (j = 0; j < 4; ++j) {
            final EquipmentSlot equipmentSlot = EquipmentSlot.m_20744_((EquipmentSlot.Type)EquipmentSlot.Type.ARMOR, (int)index);
            this.m_38897_(new Slot((Container)new SimpleContainer(new ItemStack[]{inventory.getArmorInSlot(equipmentSlot)}), 0, 223, 23 + j * 18){

                public void m_5852_(@NotNull ItemStack stack) {
                    if (workBuilding != null && !ContainerCitizenInventory.this.playerInventory.f_35978_.f_19853_.f_46443_ && !ItemStackUtils.isEmpty(stack)) {
                        IBuilding building = colony.getBuildingManager().getBuilding(workBuilding);
                        ICitizenData citizenData = colony.getCitizenManager().getCivilian(citizenId);
                        building.overruleNextOpenRequestOfCitizenWithStack(citizenData, stack);
                    }
                    super.m_5852_(stack);
                    inventory.forceArmorStackToSlot(equipmentSlot, stack);
                }

                public ItemStack m_6201_(int slot) {
                    ItemStack stack = inventory.getArmorInSlot(equipmentSlot);
                    inventory.forceClearArmorInSlot(equipmentSlot, stack);
                    return stack;
                }

                public boolean m_5857_(ItemStack stack) {
                    ArmorItem armorItem;
                    Item item = stack.m_41720_();
                    if (item instanceof ArmorItem && (armorItem = (ArmorItem)item).m_40402_() == equipmentSlot) {
                        for (GuardGear gear : guardGear) {
                            if (!gear.test(stack)) continue;
                            return true;
                        }
                        return false;
                    }
                    return false;
                }
            });
            --index;
        }
        for (i = 0; i < 3; ++i) {
            for (int j2 = 0; j2 < 9; ++j2) {
                this.m_38897_(new Slot((Container)this.playerInventory, j2 + i * 9 + 9, 8 + j2 * 18, 35 + extraOffset + 18 * Math.min(this.inventorySize, 8) + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)this.playerInventory, i, 8 + i * 18, 93 + extraOffset + 18 * Math.min(this.inventorySize, 8)));
        }
    }

    @NotNull
    public ItemStack m_7648_(Player playerIn, int index) {
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot == null || !slot.m_6657_()) {
            return ItemStackUtils.EMPTY;
        }
        ItemStack stackCopy = slot.m_7993_().m_41777_();
        int maxIndex = this.inventorySize * 9;
        if (index < maxIndex ? !this.m_38903_(stackCopy, maxIndex, this.f_38839_.size(), true) : !this.m_38903_(stackCopy, 0, maxIndex, false)) {
            return ItemStackUtils.EMPTY;
        }
        if (ItemStackUtils.getSize(stackCopy) == 0) {
            slot.m_5852_(ItemStackUtils.EMPTY);
        } else {
            slot.m_5852_(stackCopy);
        }
        return stackCopy;
    }

    public boolean m_6875_(@NotNull Player playerIn) {
        return true;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Optional<? extends Entity> getEntity() {
        return this.entity;
    }
}

