/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity.pathfinding;

public class PathingOptions {
    public double jumpCost = 3.0;
    public double dropCost = 2.0;
    public double onPathCost = 0.25;
    public double onRailCost = 0.1;
    public double railsExitCost = 5.0;
    public double swimCost = 3.0;
    public double caveAirCost = 4.0;
    public double swimCostEnter = 25.0;
    public double traverseToggleAbleCost = 10.0;
    public double nonLadderClimbableCost = 4.0;
    private boolean canUseRails = false;
    private boolean canSwim = false;
    private boolean enterDoors = false;
    private boolean canOpenDoors = false;
    private boolean canClimbNonLadders = false;
    private boolean canPassDanger = false;

    public boolean canOpenDoors() {
        return this.canOpenDoors;
    }

    public void setCanOpenDoors(boolean canOpenDoors) {
        this.canOpenDoors = canOpenDoors;
    }

    public boolean canUseRails() {
        return this.canUseRails;
    }

    public boolean canClimbNonLadders() {
        return this.canClimbNonLadders;
    }

    public void setCanUseRails(boolean canUseRails) {
        this.canUseRails = canUseRails;
    }

    public void setCanClimbNonLadders(boolean canClimbNonLadders) {
        this.canClimbNonLadders = canClimbNonLadders;
    }

    public boolean canSwim() {
        return this.canSwim;
    }

    public void setCanSwim(boolean canSwim) {
        this.canSwim = canSwim;
    }

    public boolean canEnterDoors() {
        return this.enterDoors;
    }

    public void setEnterDoors(boolean enterDoors) {
        this.enterDoors = enterDoors;
    }

    public void setPassDanger(boolean danger) {
        this.canPassDanger = danger;
    }

    public boolean canPassDanger() {
        return this.canPassDanger;
    }

    public PathingOptions withStartSwimCost(double startSwimCost) {
        this.swimCostEnter = startSwimCost;
        return this;
    }

    public PathingOptions withSwimCost(double swimCost) {
        this.swimCost = swimCost;
        return this;
    }

    public PathingOptions withJumpCost(double jumpCost) {
        this.jumpCost = jumpCost;
        return this;
    }

    public PathingOptions withDropCost(double dropCost) {
        this.dropCost = dropCost;
        return this;
    }

    public PathingOptions withOnPathCost(double onPathCost) {
        this.onPathCost = onPathCost;
        return this;
    }

    public PathingOptions withOnRailCost(double onRailCost) {
        this.onRailCost = onRailCost;
        return this;
    }

    public PathingOptions withRailExitCost(double railExitCost) {
        this.railsExitCost = railExitCost;
        return this;
    }

    public PathingOptions withToggleCost(double toggleCost) {
        this.traverseToggleAbleCost = toggleCost;
        return this;
    }

    public PathingOptions withNonLadderClimbableCost(double nonLadderClimbableCost) {
        this.nonLadderClimbableCost = nonLadderClimbableCost;
        return this;
    }

    public PathingOptions withCanSwim(boolean canswim) {
        this.setCanSwim(canswim);
        return this;
    }

    public PathingOptions withCanEnterDoors(boolean canEnter) {
        this.setEnterDoors(canEnter);
        return this;
    }

    public void importFrom(PathingOptions pathingOptions) {
        this.jumpCost = pathingOptions.jumpCost;
        this.dropCost = pathingOptions.dropCost;
        this.onPathCost = pathingOptions.onPathCost;
        this.onRailCost = pathingOptions.onRailCost;
        this.railsExitCost = pathingOptions.railsExitCost;
        this.swimCost = pathingOptions.swimCost;
        this.caveAirCost = pathingOptions.caveAirCost;
        this.swimCostEnter = pathingOptions.swimCostEnter;
        this.traverseToggleAbleCost = pathingOptions.traverseToggleAbleCost;
        this.nonLadderClimbableCost = pathingOptions.nonLadderClimbableCost;
        this.canUseRails = pathingOptions.canUseRails;
        this.canSwim = pathingOptions.canSwim;
        this.enterDoors = pathingOptions.enterDoors;
        this.canOpenDoors = pathingOptions.canOpenDoors;
        this.canClimbNonLadders = pathingOptions.canClimbNonLadders;
        this.canPassDanger = pathingOptions.canPassDanger;
    }
}

