/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity.pathfinding;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.pathfinding.IPathJob;
import com.minecolonies.api.entity.pathfinding.IStuckHandler;
import com.minecolonies.api.entity.pathfinding.PathResult;
import com.minecolonies.api.entity.pathfinding.PathingOptions;
import com.minecolonies.api.entity.pathfinding.TreePathResult;
import com.minecolonies.api.entity.pathfinding.WaterPathResult;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractAdvancedPathNavigate
extends GroundPathNavigation {
    protected final Mob ourEntity;
    @Nullable
    protected BlockPos destination;
    protected double walkSpeedFactor = 1.0;
    @Nullable
    protected BlockPos originalDestination;
    private PathingOptions pathingOptions = new PathingOptions();

    public AbstractAdvancedPathNavigate(Mob entityLiving, Level worldIn) {
        super(entityLiving, worldIn);
        this.ourEntity = this.f_26494_;
    }

    @Nullable
    public BlockPos getDestination() {
        return this.destination;
    }

    public abstract PathResult<? extends IPathJob> moveAwayFromXYZ(BlockPos var1, double var2, double var4, boolean var6);

    public abstract PathResult<? extends IPathJob> moveToXYZ(double var1, double var3, double var5, double var7);

    public abstract WaterPathResult moveToWater(int var1, double var2, List<com.minecolonies.api.util.Tuple<BlockPos, BlockPos>> var4);

    public abstract PathResult<? extends IPathJob> moveAwayFromLivingEntity(Entity var1, double var2, double var4);

    public abstract boolean tryMoveToBlockPos(BlockPos var1, double var2);

    public abstract PathResult<? extends IPathJob> moveToRandomPos(double var1, double var3);

    public abstract PathResult<? extends IPathJob> moveToRandomPosAroundX(int var1, double var2, BlockPos var4);

    public abstract PathResult<? extends IPathJob> moveToRandomPos(int var1, double var2, Tuple<BlockPos, BlockPos> var4, RestrictionType var5);

    public abstract TreePathResult moveToTree(BlockPos var1, BlockPos var2, double var3, List<ItemStorage> var5, int var6, IColony var7);

    public abstract TreePathResult moveToTree(int var1, double var2, List<ItemStorage> var4, int var5, IColony var6);

    public abstract PathResult<? extends IPathJob> moveToLivingEntity(@NotNull Entity var1, double var2);

    public PathingOptions getPathingOptions() {
        return this.pathingOptions;
    }

    public Mob getOurEntity() {
        return this.ourEntity;
    }

    public abstract BlockPos getDesiredPos();

    public abstract void setStuckHandler(IStuckHandler var1);

    public abstract void setSwimSpeedFactor(double var1);

    public static enum RestrictionType {
        NONE,
        XZ,
        XYZ;

    }
}

