/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.api.util.MessageUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public final class TeleportHelper {
    private static final double MIDDLE_BLOCK_OFFSET = 0.5;

    private TeleportHelper() {
    }

    public static boolean teleportCitizen(AbstractEntityCitizen citizen, Level world, BlockPos location) {
        if (citizen == null || world == null || world.f_46443_) {
            return false;
        }
        BlockPos spawnPoint = EntityUtils.getSpawnPoint(world, location);
        if (spawnPoint == null) {
            return false;
        }
        if (citizen.getCitizenSleepHandler().isAsleep()) {
            citizen.getCitizenSleepHandler().onWakeUp();
        }
        citizen.m_8127_();
        citizen.m_7678_((double)spawnPoint.m_123341_() + 0.5, spawnPoint.m_123342_(), (double)spawnPoint.m_123343_() + 0.5, citizen.getRotationYaw(), citizen.getRotationPitch());
        if (citizen.getProxy() != null) {
            citizen.getProxy().reset();
        }
        citizen.getNavigation().m_26573_();
        if (citizen.getProxy() != null) {
            citizen.getProxy().reset();
        }
        return true;
    }

    public static void homeTeleport(@NotNull ServerPlayer player) {
        IColony colony = IColonyManager.getInstance().getIColonyByOwner(player.m_20193_(), (Player)player);
        if (colony == null) {
            MessageUtils.format("com.minecolonies.command.colonyidnotfound", new Object[0]).sendTo(new Player[]{player});
            return;
        }
        TeleportHelper.colonyTeleport(player, colony);
    }

    public static void surfaceTeleport(@NotNull ServerPlayer player) {
        BlockPos position = BlockPos.m_274561_((double)player.m_20185_(), (double)250.0, (double)player.m_20189_());
        ServerLevel world = (ServerLevel)player.f_19853_;
        position = BlockPosUtil.findLand(position, (Level)world);
        ChunkPos chunkpos = new ChunkPos(position);
        world.m_7726_().m_8387_(TicketType.f_9448_, chunkpos, 1, (Object)player.m_19879_());
        player.m_8127_();
        if (player.m_5803_()) {
            player.m_6145_(true, true);
        }
        player.m_8999_(world, (double)position.m_123341_(), (double)position.m_123342_() + 2.0, (double)position.m_123343_(), player.m_146908_(), player.m_146909_());
    }

    public static void colonyTeleportByID(@NotNull ServerPlayer player, int id, ResourceKey<Level> dimension) {
        IColony colony = IColonyManager.getInstance().getColonyByDimension(id, dimension);
        if (colony == null) {
            MessageUtils.format("com.minecolonies.command.colonyidnotfound", new Object[0]).sendTo(new Player[]{player});
            return;
        }
        TeleportHelper.colonyTeleport(player, colony);
    }

    public static void colonyTeleport(@NotNull ServerPlayer player, @NotNull IColony colony) {
        BlockPos position = colony.getBuildingManager().getTownHall() != null ? colony.getBuildingManager().getTownHall().getPosition() : colony.getCenter();
        ServerLevel world = player.m_20194_().m_129880_(colony.getDimension());
        position = BlockPosUtil.findAround((Level)world, position, 5, 5, (predWorld, predPos) -> predWorld.m_8055_(predPos).m_60795_() && predWorld.m_8055_(predPos.m_7494_()).m_60795_());
        if (position == null) {
            return;
        }
        ChunkPos chunkpos = new ChunkPos(position);
        world.m_7726_().m_8387_(TicketType.f_9448_, chunkpos, 1, (Object)player.m_19879_());
        player.m_8127_();
        if (player.m_5803_()) {
            player.m_6145_(true, true);
        }
        player.m_8999_(world, (double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_(), player.m_146908_(), player.m_146909_());
        MessageUtils.format("com.minecolonies.command.teleport.success", colony.getName()).sendTo(new Player[]{player});
    }
}

