/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import com.minecolonies.api.colony.IChunkmanagerCapability;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.ChunkLoadStorage;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.IColonyManagerCapability;
import com.minecolonies.coremod.network.messages.client.UpdateChunkCapabilityMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.Nullable;

public final class ChunkDataHelper {
    private ChunkDataHelper() {
    }

    public static void loadChunk(LevelChunk chunk, Level world) {
        IColony colony;
        int closeColony;
        int distanceToDelete = (Integer)MineColonies.getConfig().getServer().maxColonySize.get() * 16 * 2 * 5;
        IChunkmanagerCapability chunkManager = world.getCapability(MineColonies.CHUNK_STORAGE_UPDATE_CAP, null).resolve().orElse(null);
        if (chunkManager == null) {
            Log.getLogger().error("Unable to find Chunk manager in world capability, please report this to the mod author!", (Throwable)new Exception());
            return;
        }
        if (!chunkManager.getAllChunkStorages().isEmpty()) {
            IColonyManagerCapability cap = world.getCapability(MineColonies.COLONY_MANAGER_CAP, null).resolve().orElse(null);
            if (cap == null) {
                return;
            }
            ChunkLoadStorage existingStorage = chunkManager.getChunkStorage(chunk.m_7697_().f_45578_, chunk.m_7697_().f_45579_);
            if (existingStorage != null) {
                ChunkDataHelper.addStorageToChunk(chunk, existingStorage);
            }
        }
        if ((closeColony = chunk.getCapability(IColony.CLOSE_COLONY_CAP, null).map(IColonyTagCapability::getOwningColony).orElse(0).intValue()) != 0 && (colony = IColonyManager.getInstance().getColonyByDimension(closeColony, (ResourceKey<Level>)world.m_46472_())) != null) {
            colony.addLoadedChunk(ChunkPos.m_45589_((int)chunk.m_7697_().f_45578_, (int)chunk.m_7697_().f_45579_), chunk);
        }
    }

    public static void unloadChunk(LevelChunk chunk, Level world) {
        IColony colony;
        int closeColony = chunk.getCapability(IColony.CLOSE_COLONY_CAP, null).map(IColonyTagCapability::getOwningColony).orElse(0);
        if (closeColony != 0 && (colony = IColonyManager.getInstance().getColonyByDimension(closeColony, (ResourceKey<Level>)world.m_46472_())) != null) {
            colony.removeLoadedChunk(ChunkPos.m_45589_((int)chunk.m_7697_().f_45578_, (int)chunk.m_7697_().f_45579_));
        }
    }

    public static void addStorageToChunk(LevelChunk chunk, ChunkLoadStorage storage) {
        if (chunk.m_7697_().equals((Object)ChunkPos.f_186419_)) {
            Log.getLogger().warn("Trying to claim zero chunk!", (Throwable)new Exception());
        }
        IColonyTagCapability cap = chunk.getCapability(IColony.CLOSE_COLONY_CAP, null).resolve().orElse(null);
        storage.applyToCap(cap, chunk);
        if (cap != null) {
            Network.getNetwork().sendToEveryone(new UpdateChunkCapabilityMessage(cap, chunk.m_7697_().f_45578_, chunk.m_7697_().f_45579_));
        }
    }

    public static void claimColonyChunks(Level world, boolean add, int id, BlockPos center) {
        int range = (Integer)MineColonies.getConfig().getServer().initialColonySize.get();
        ChunkDataHelper.staticClaimInRange(id, add, center, add ? range : range * 2, world, false);
    }

    public static void claimBuildingChunks(IColony colony, boolean add, BlockPos center, int range, @Nullable Tuple<BlockPos, BlockPos> corners) {
        ChunkDataHelper.buildingClaimInRange(colony, add, range, center, false);
        if (corners != null) {
            ChunkDataHelper.buildingClaimBox(colony, center, add, corners);
        }
    }

    public static boolean canClaimChunksInRange(Level w, BlockPos pos, int range) {
        IChunkmanagerCapability worldCapability = w.getCapability(MineColonies.CHUNK_STORAGE_UPDATE_CAP, null).resolve().orElse(null);
        if (worldCapability == null) {
            return true;
        }
        LevelChunk centralChunk = w.m_46745_(pos);
        int chunkX = centralChunk.m_7697_().f_45578_;
        int chunkZ = centralChunk.m_7697_().f_45579_;
        for (int i = chunkX - range; i <= chunkX + range; ++i) {
            for (int j = chunkZ - range; j <= chunkZ + range; ++j) {
                LevelChunk chunk = w.m_6325_(i, j);
                IColonyTagCapability colonyCap = chunk.getCapability(IColony.CLOSE_COLONY_CAP, null).resolve().orElse(null);
                if (colonyCap == null) {
                    return true;
                }
                ChunkLoadStorage storage = worldCapability.getChunkStorage(chunk.m_7697_().f_45578_, chunk.m_7697_().f_45579_);
                if (storage != null) {
                    storage.applyToCap(colonyCap, chunk);
                }
                if (colonyCap.getOwningColony() == 0) continue;
                return false;
            }
        }
        return true;
    }

    private static void buildingClaimInRange(IColony colony, boolean add, int range, BlockPos center, boolean force) {
        Level world = colony.getWorld();
        IChunkmanagerCapability chunkManager = world.getCapability(MineColonies.CHUNK_STORAGE_UPDATE_CAP, null).resolve().orElse(null);
        if (chunkManager == null) {
            Log.getLogger().error("Unable to find Chunk manager in world capability, please report this to the mod author!", (Throwable)new Exception());
            return;
        }
        BlockPos colonyCenterCompare = new BlockPos(colony.getCenter().m_123341_(), 0, colony.getCenter().m_123343_());
        int chunkX = center.m_123341_() >> 4;
        int chunkZ = center.m_123343_() >> 4;
        int maxColonySize = (Integer)MineColonies.getConfig().getServer().maxColonySize.get();
        for (int i = chunkX - range; i <= chunkX + range; ++i) {
            for (int j = chunkZ - range; j <= chunkZ + range; ++j) {
                BlockPos pos = new BlockPos(i * 16, 0, j * 16);
                if (!force && maxColonySize != 0 && pos.m_123331_((Vec3i)colonyCenterCompare) > Math.pow(maxColonySize * 16, 2.0)) {
                    Log.getLogger().debug("Tried to claim chunk at pos X:" + pos.m_123341_() + " Z:" + pos.m_123343_() + " too far away from the colony:" + colony.getID() + " center:" + colony.getCenter() + " max is config workingRangeTownHall ^2");
                    continue;
                }
                if (!ChunkDataHelper.tryClaimBuilding(world, pos, add, colony, center, chunkManager)) continue;
            }
        }
        if (add && range > 0) {
            IBuilding building = colony.getBuildingManager().getBuilding(center);
            MessageUtils.format("com.minecolonies.coremod.colonysizechange", range, building.getSchematicName()).sendTo(colony).forManagers();
        }
    }

    private static void buildingClaimBox(IColony colony, BlockPos anchor, boolean add, Tuple<BlockPos, BlockPos> corners) {
        Level world = colony.getWorld();
        IChunkmanagerCapability chunkManager = world.getCapability(MineColonies.CHUNK_STORAGE_UPDATE_CAP, null).resolve().orElse(null);
        if (chunkManager == null) {
            Log.getLogger().error("Unable to find Chunk manager in world capability, please report this to the mod author!", (Throwable)new Exception());
            return;
        }
        int maxColonySize = (Integer)MineColonies.getConfig().getServer().maxColonySize.get();
        BlockPos colonyCenterCompare = new BlockPos(colony.getCenter().m_123341_(), 0, colony.getCenter().m_123343_());
        for (ChunkPos chunk : ChunkPos.m_45599_((ChunkPos)new ChunkPos((BlockPos)corners.m_14418_()), (ChunkPos)new ChunkPos((BlockPos)corners.m_14419_())).toList()) {
            BlockPos pos = chunk.m_45615_();
            if (maxColonySize != 0 && pos.m_123331_((Vec3i)colonyCenterCompare) > Math.pow(maxColonySize * 16, 2.0)) {
                Log.getLogger().debug("Tried to claim chunk at pos X:" + pos.m_123341_() + " Z:" + pos.m_123343_() + " too far away from the colony:" + colony.getID() + " center:" + colony.getCenter() + " max is config workingRangeTownHall ^2");
                continue;
            }
            ChunkDataHelper.tryClaimBuilding(world, pos, add, colony, anchor, chunkManager);
        }
    }

    public static void staticClaimInRange(int colonyId, boolean add, BlockPos center, int range, Level world, boolean forceOwnerChange) {
        IChunkmanagerCapability chunkManager = world.getCapability(MineColonies.CHUNK_STORAGE_UPDATE_CAP, null).resolve().orElse(null);
        if (chunkManager == null) {
            Log.getLogger().error("Unable to find Chunk manager in world capability, please report this to the mod author!", (Throwable)new Exception());
            return;
        }
        LevelChunk centralChunk = world.m_46745_(center);
        int chunkXMax = centralChunk.m_7697_().f_45578_;
        int chunkZMax = centralChunk.m_7697_().f_45579_;
        for (int chunkPosX = chunkXMax - range; chunkPosX <= chunkXMax + range; ++chunkPosX) {
            for (int chunkPosZ = chunkZMax - range; chunkPosZ <= chunkZMax + range; ++chunkPosZ) {
                ChunkDataHelper.tryClaim(world, new BlockPos(chunkPosX * 16, 0, chunkPosZ * 16), add, colonyId, chunkManager, forceOwnerChange);
            }
        }
    }

    public static boolean tryClaim(Level world, BlockPos chunkBlockPos, boolean add, int id, IChunkmanagerCapability chunkManager, boolean forceOwnerChange) {
        if (!WorldUtil.isBlockLoaded((LevelAccessor)world, chunkBlockPos)) {
            ChunkLoadStorage newStorage = new ChunkLoadStorage(id, ChunkPos.m_151388_((BlockPos)chunkBlockPos), add, world.m_46472_().m_135782_(), forceOwnerChange);
            chunkManager.addChunkStorage(SectionPos.m_123171_((int)chunkBlockPos.m_123341_()), SectionPos.m_123171_((int)chunkBlockPos.m_123343_()), newStorage);
            return false;
        }
        LevelChunk chunk = (LevelChunk)world.m_46865_(chunkBlockPos);
        IColonyTagCapability cap = chunk.getCapability(IColony.CLOSE_COLONY_CAP, null).resolve().orElse(null);
        if (cap == null) {
            return false;
        }
        ChunkLoadStorage chunkLoadStorage = chunkManager.getChunkStorage(chunk.m_7697_().f_45578_, chunk.m_7697_().f_45579_);
        if (chunkLoadStorage != null) {
            chunkLoadStorage.applyToCap(cap, chunk);
        }
        if (add) {
            cap.addColony(id, chunk);
            if (forceOwnerChange) {
                cap.setOwningColony(id, chunk);
                IColony colony = IColonyManager.getInstance().getColonyByDimension(id, (ResourceKey<Level>)world.m_46472_());
                if (colony != null) {
                    colony.addLoadedChunk(ChunkPos.m_45589_((int)chunk.m_7697_().f_45578_, (int)chunk.m_7697_().f_45579_), chunk);
                }
            }
        } else {
            cap.removeColony(id, chunk);
        }
        Network.getNetwork().sendToTrackingChunk(new UpdateChunkCapabilityMessage(cap, chunk.m_7697_().f_45578_, chunk.m_7697_().f_45579_), chunk);
        return true;
    }

    public static boolean tryClaimBuilding(Level world, BlockPos chunkBlockPos, boolean add, IColony colony, BlockPos buildingPos, IChunkmanagerCapability chunkManager) {
        ChunkLoadStorage chunkLoadStorage;
        if (!WorldUtil.isBlockLoaded((LevelAccessor)world, chunkBlockPos)) {
            ChunkLoadStorage newStorage = new ChunkLoadStorage(colony.getID(), ChunkPos.m_151388_((BlockPos)chunkBlockPos), world.m_46472_().m_135782_(), buildingPos, add);
            chunkManager.addChunkStorage(SectionPos.m_123171_((int)chunkBlockPos.m_123341_()), SectionPos.m_123171_((int)chunkBlockPos.m_123343_()), newStorage);
            return false;
        }
        LevelChunk chunk = world.m_46745_(chunkBlockPos);
        IColonyTagCapability cap = chunk.getCapability(IColony.CLOSE_COLONY_CAP, null).resolve().orElse(null);
        if (cap == null) {
            return false;
        }
        if (chunk.m_7697_().equals((Object)ChunkPos.f_186419_) && chunk.m_7697_().equals((Object)ChunkPos.f_186419_) && (colony == null || BlockPosUtil.getDistance2D(colony.getCenter(), BlockPos.f_121853_) > 200L)) {
            Log.getLogger().warn("Trying to claim at zero chunk pos!:", (Throwable)new Exception());
        }
        if ((chunkLoadStorage = chunkManager.getChunkStorage(chunk.m_7697_().f_45578_, chunk.m_7697_().f_45579_)) != null) {
            chunkLoadStorage.applyToCap(cap, chunk);
        }
        if (add) {
            cap.addBuildingClaim(colony.getID(), buildingPos, chunk);
        } else {
            cap.removeBuildingClaim(colony.getID(), buildingPos, chunk);
        }
        Network.getNetwork().sendToTrackingChunk(new UpdateChunkCapabilityMessage(cap, chunk.m_7697_().f_45578_, chunk.m_7697_().f_45579_), chunk);
        return true;
    }
}

