/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.research.costs;

import com.google.gson.JsonObject;
import com.minecolonies.api.research.ModResearchCostTypes;
import com.minecolonies.api.research.costs.IResearchCost;
import com.minecolonies.coremod.research.GlobalResearch;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class TagItemCost
implements IResearchCost {
    private final ModResearchCostTypes.ResearchCostType type;
    private int count;
    private TagKey<Item> tag;

    public TagItemCost(ModResearchCostTypes.ResearchCostType type) {
        this.type = type;
    }

    @Override
    public ModResearchCostTypes.ResearchCostType getType() {
        return this.type;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public List<Item> getItems() {
        return ForgeRegistries.ITEMS.tags().getTag(this.tag).stream().toList();
    }

    @Override
    public Component getTranslatedName() {
        return Component.m_237115_((String)String.format("com.minecolonies.coremod.research.tags.%s", this.tag.f_203868_()));
    }

    @Override
    public void read(@NotNull CompoundTag compound) {
        this.count = compound.m_128451_("cost-count");
        this.tag = ForgeRegistries.ITEMS.tags().createTagKey(new ResourceLocation(compound.m_128461_("cost-tag")));
    }

    @Override
    public void write(@NotNull CompoundTag compound) {
        compound.m_128405_("cost-count", this.count);
        compound.m_128359_("cost-tag", this.tag.f_203868_().toString());
    }

    @Override
    public void serialize(@NotNull FriendlyByteBuf buf) {
        buf.writeInt(this.count);
        buf.m_130085_(this.tag.f_203868_());
    }

    @Override
    public void deserialize(@NotNull FriendlyByteBuf buf) {
        this.count = buf.readInt();
        this.tag = TagKey.m_203882_((ResourceKey)ForgeRegistries.ITEMS.getRegistryKey(), (ResourceLocation)buf.m_130281_());
    }

    @Override
    public boolean hasCorrectJsonFields(JsonObject jsonObject) {
        return jsonObject.getAsJsonObject().has("item") && jsonObject.getAsJsonObject().get("item").isJsonObject() && jsonObject.getAsJsonObject().getAsJsonObject("item").has("tag");
    }

    @Override
    public void parseFromJson(JsonObject jsonObject) {
        String tagKey = jsonObject.getAsJsonObject("item").getAsJsonPrimitive("tag").getAsString();
        this.tag = ForgeRegistries.ITEMS.tags().createTagKey(new ResourceLocation(tagKey));
        this.count = GlobalResearch.parseItemCount(jsonObject);
    }

    public int hashCode() {
        int result = this.count;
        result = 31 * result + this.tag.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TagItemCost that = (TagItemCost)o;
        if (this.count != that.count) {
            return false;
        }
        return this.tag.equals(that.tag);
    }
}

